/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.math.spatial.BoundingBoxF;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.physics.geometry.ConvexMesh;
import de.fabmax.kool.scene.geometry.IndexedVertexList;
import de.fabmax.kool.scene.geometry.MeshBuilder;
import de.fabmax.kool.scene.geometry.VertexView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0012H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lde/fabmax/kool/physics/geometry/ConvexMeshGeometry;", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "convexMesh", "Lde/fabmax/kool/physics/geometry/ConvexMesh;", "getConvexMesh", "()Lde/fabmax/kool/physics/geometry/ConvexMesh;", "scale", "Lde/fabmax/kool/math/Vec3f;", "getScale", "()Lde/fabmax/kool/math/Vec3f;", "generateMesh", "", "target", "Lde/fabmax/kool/scene/geometry/MeshBuilder;", "getBounds", "Lde/fabmax/kool/math/spatial/BoundingBoxF;", "result", "estimateInertiaForMass", "Lde/fabmax/kool/math/MutableVec3f;", "mass", "", "kool-physics"})
public interface ConvexMeshGeometry
extends CollisionGeometry {
    @NotNull
    public ConvexMesh getConvexMesh();

    @NotNull
    public Vec3f getScale();

    @Override
    public void generateMesh(@NotNull MeshBuilder var1);

    @Override
    @NotNull
    public BoundingBoxF getBounds(@NotNull BoundingBoxF var1);

    @Override
    @NotNull
    public MutableVec3f estimateInertiaForMass(float var1, @NotNull MutableVec3f var2);

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nConvexMeshGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvexMeshGeometry.kt\nde/fabmax/kool/physics/geometry/ConvexMeshGeometry$DefaultImpls\n+ 2 MeshBuilder.kt\nde/fabmax/kool/scene/geometry/MeshBuilder\n+ 3 IndexedVertexList.kt\nde/fabmax/kool/scene/geometry/IndexedVertexList\n*L\n1#1,46:1\n57#2,2:47\n59#2,2:54\n312#3,5:49\n*S KotlinDebug\n*F\n+ 1 ConvexMeshGeometry.kt\nde/fabmax/kool/physics/geometry/ConvexMeshGeometry$DefaultImpls\n*L\n18#1:47,2\n18#1:54,2\n22#1:49,5\n*E\n"})
    public static final class DefaultImpls {
        public static void generateMesh(@NotNull ConvexMeshGeometry $this, @NotNull MeshBuilder target) {
            MeshBuilder meshBuilder;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            MeshBuilder $this$generateMesh_u24lambda_u242 = meshBuilder = target;
            boolean bl = false;
            MeshBuilder this_$iv = $this$generateMesh_u24lambda_u242;
            boolean $i$f$withTransform = false;
            this_$iv.getTransform().push();
            MeshBuilder $this$generateMesh_u24lambda_u242_u24lambda_u241 = this_$iv;
            boolean bl2 = false;
            $this$generateMesh_u24lambda_u242_u24lambda_u241.scale($this.getScale().getX(), $this.getScale().getY(), $this.getScale().getZ());
            IndexedVertexList hull = $this.getConvexMesh().getConvexHull();
            List inds = new ArrayList();
            IndexedVertexList this_$iv2 = hull;
            boolean $i$f$forEach = false;
            int n = this_$iv2.getNumVertices();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                this_$iv2.getVertexIt().setIndex(i$iv);
                VertexView it = this_$iv2.getVertexIt();
                boolean bl3 = false;
                ((Collection)inds).add(MeshBuilder.vertex$default((MeshBuilder)$this$generateMesh_u24lambda_u242_u24lambda_u241, (Vec3f)((Vec3f)it), (Vec3f)((Vec3f)it.getNormal()), null, (int)4, null));
            }
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)hull.getNumIndices())), (int)3);
            int i = intProgression.getFirst();
            int n2 = intProgression.getLast();
            n = intProgression.getStep();
            if (n > 0 && i <= n2 || n < 0 && n2 <= i) {
                while (true) {
                    int i0 = ((Number)inds.get(hull.getIndices().get(i))).intValue();
                    int i1 = ((Number)inds.get(hull.getIndices().get(i + 1))).intValue();
                    int i2 = ((Number)inds.get(hull.getIndices().get(i + 2))).intValue();
                    $this$generateMesh_u24lambda_u242_u24lambda_u241.getGeometry().addTriIndices(i0, i1, i2);
                    if (i == n2) break;
                    i += n;
                }
            }
            this_$iv.getTransform().pop();
        }

        @NotNull
        public static BoundingBoxF getBounds(@NotNull ConvexMeshGeometry $this, @NotNull BoundingBoxF result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return result.set($this.getConvexMesh().getConvexHull().getBounds());
        }

        @NotNull
        public static MutableVec3f estimateInertiaForMass(@NotNull ConvexMeshGeometry $this, float mass, @NotNull MutableVec3f result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            BoundingBoxF bounds = $this.getConvexMesh().getConvexHull().getBounds();
            result.setX(mass / 12.0f * (bounds.getSize().getY() * bounds.getSize().getY() + bounds.getSize().getZ() * bounds.getSize().getZ()));
            result.setZ(mass / 12.0f * (bounds.getSize().getX() * bounds.getSize().getX() + bounds.getSize().getY() * bounds.getSize().getY()));
            result.setY(mass / 12.0f * (bounds.getSize().getX() * bounds.getSize().getX() + bounds.getSize().getZ() * bounds.getSize().getZ()));
            return result;
        }
    }
}

