/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.character;

import de.fabmax.kool.math.AngleKt;
import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MutableVec3d;
import de.fabmax.kool.math.Vec3d;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.PhysicsWorldImpl;
import de.fabmax.kool.physics.RigidDynamic;
import de.fabmax.kool.physics.RigidDynamicImpl;
import de.fabmax.kool.physics.character.CharacterController;
import de.fabmax.kool.physics.character.CharacterControllerManager;
import de.fabmax.kool.physics.character.ControllerBahaviorCallback;
import de.fabmax.kool.physics.character.ControllerHitListener;
import de.fabmax.kool.physics.character.NonWalkableMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import physx.character.PxCapsuleController;
import physx.character.PxControllerCollisionFlagEnum;
import physx.character.PxControllerCollisionFlags;
import physx.character.PxControllerFilters;
import physx.character.PxControllerNonWalkableModeEnum;
import physx.character.PxExtendedVec3;
import physx.common.PxVec3;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020!H\u0014J\u0010\u0010:\u001a\u0002062\u0006\u0010\"\u001a\u00020!H\u0016J\b\u0010;\u001a\u000206H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020!@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010'\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020!@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R&\u0010+\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020*@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010.\u001a\u0004\b,\u0010$\"\u0004\b-\u0010&R$\u00100\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020/@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006<"}, d2={"Lde/fabmax/kool/physics/character/JvmCharacterController;", "Lde/fabmax/kool/physics/character/CharacterController;", "pxController", "Lphysx/character/PxCapsuleController;", "hitListener", "Lde/fabmax/kool/physics/character/ControllerHitListener;", "behaviorCallback", "Lde/fabmax/kool/physics/character/ControllerBahaviorCallback;", "manager", "Lde/fabmax/kool/physics/character/CharacterControllerManager;", "world", "Lde/fabmax/kool/physics/PhysicsWorldImpl;", "<init>", "(Lphysx/character/PxCapsuleController;Lde/fabmax/kool/physics/character/ControllerHitListener;Lde/fabmax/kool/physics/character/ControllerBahaviorCallback;Lde/fabmax/kool/physics/character/CharacterControllerManager;Lde/fabmax/kool/physics/PhysicsWorldImpl;)V", "bufPosition", "Lde/fabmax/kool/math/MutableVec3d;", "bufPxPosition", "Lphysx/character/PxExtendedVec3;", "bufPxVec3", "Lphysx/common/PxVec3;", "pxControllerFilters", "Lphysx/character/PxControllerFilters;", "value", "Lde/fabmax/kool/math/Vec3d;", "position", "getPosition", "()Lde/fabmax/kool/math/Vec3d;", "setPosition", "(Lde/fabmax/kool/math/Vec3d;)V", "actor", "Lde/fabmax/kool/physics/RigidDynamic;", "getActor", "()Lde/fabmax/kool/physics/RigidDynamic;", "", "height", "getHeight", "()F", "setHeight", "(F)V", "radius", "getRadius", "setRadius", "Lde/fabmax/kool/math/AngleF;", "slopeLimit", "getSlopeLimit-H2B9tyM", "setSlopeLimit-7PBAxM4", "F", "Lde/fabmax/kool/physics/character/NonWalkableMode;", "nonWalkableMode", "getNonWalkableMode", "()Lde/fabmax/kool/physics/character/NonWalkableMode;", "setNonWalkableMode", "(Lde/fabmax/kool/physics/character/NonWalkableMode;)V", "move", "", "displacement", "Lde/fabmax/kool/math/Vec3f;", "timeStep", "resize", "release", "kool-physics"})
public final class JvmCharacterController
extends CharacterController {
    @NotNull
    private final PxCapsuleController pxController;
    @NotNull
    private final ControllerHitListener hitListener;
    @NotNull
    private final ControllerBahaviorCallback behaviorCallback;
    @NotNull
    private final MutableVec3d bufPosition;
    @NotNull
    private final PxExtendedVec3 bufPxPosition;
    @NotNull
    private final PxVec3 bufPxVec3;
    @NotNull
    private final PxControllerFilters pxControllerFilters;
    @NotNull
    private final RigidDynamic actor;
    private float height;
    private float radius;
    private float slopeLimit;
    @NotNull
    private NonWalkableMode nonWalkableMode;

    public JvmCharacterController(@NotNull PxCapsuleController pxController, @NotNull ControllerHitListener hitListener, @NotNull ControllerBahaviorCallback behaviorCallback, @NotNull CharacterControllerManager manager, @NotNull PhysicsWorldImpl world) {
        NonWalkableMode nonWalkableMode;
        Intrinsics.checkNotNullParameter((Object)pxController, (String)"pxController");
        Intrinsics.checkNotNullParameter((Object)((Object)hitListener), (String)"hitListener");
        Intrinsics.checkNotNullParameter((Object)((Object)behaviorCallback), (String)"behaviorCallback");
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        Intrinsics.checkNotNullParameter((Object)((Object)world), (String)"world");
        super(manager, world);
        this.pxController = pxController;
        this.hitListener = hitListener;
        this.behaviorCallback = behaviorCallback;
        this.bufPosition = new MutableVec3d();
        this.bufPxPosition = new PxExtendedVec3();
        this.bufPxVec3 = new PxVec3();
        this.pxControllerFilters = new PxControllerFilters();
        this.actor = new RigidDynamicImpl(1.0f, Mat4f.Companion.getIDENTITY(), false, this.pxController.getActor());
        this.height = this.pxController.getHeight();
        this.radius = this.pxController.getRadius();
        this.slopeLimit = AngleKt.getRad((float)((float)Math.acos(this.pxController.getSlopeLimit())));
        PxControllerNonWalkableModeEnum pxControllerNonWalkableModeEnum = this.pxController.getNonWalkableMode();
        Intrinsics.checkNotNull((Object)pxControllerNonWalkableModeEnum);
        switch (WhenMappings.$EnumSwitchMapping$0[pxControllerNonWalkableModeEnum.ordinal()]) {
            case 1: {
                nonWalkableMode = NonWalkableMode.PREVENT_CLIMBING;
                break;
            }
            case 2: {
                nonWalkableMode = NonWalkableMode.PREVENT_CLIMBING_AND_FORCE_SLIDING;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.nonWalkableMode = nonWalkableMode;
        this.hitListener.setController(this);
        this.behaviorCallback.setController(this);
        world.registerActorReference$kool_physics(this.getActor());
    }

    @Override
    @NotNull
    public Vec3d getPosition() {
        PxExtendedVec3 pxExtendedVec3 = this.pxController.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)pxExtendedVec3, (String)"getPosition(...)");
        return (Vec3d)PhysXExtensionsKt.toVec3d(pxExtendedVec3, this.bufPosition);
    }

    @Override
    public void setPosition(@NotNull Vec3d value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.pxController.setPosition(PhysXExtensionsKt.toPxExtendedVec3(value, this.bufPxPosition));
        this.getPrevPosition().set(value);
    }

    @Override
    @NotNull
    public RigidDynamic getActor() {
        return this.actor;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(float value) {
        this.height = value;
        this.pxController.setHeight(value);
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(float value) {
        this.radius = value;
        this.pxController.setRadius(value);
    }

    @Override
    public float getSlopeLimit-H2B9tyM() {
        return this.slopeLimit;
    }

    @Override
    public void setSlopeLimit-7PBAxM4(float value) {
        this.slopeLimit = value;
        this.pxController.setSlopeLimit((float)Math.cos(value));
    }

    @Override
    @NotNull
    public NonWalkableMode getNonWalkableMode() {
        return this.nonWalkableMode;
    }

    @Override
    public void setNonWalkableMode(@NotNull NonWalkableMode value) {
        PxControllerNonWalkableModeEnum pxControllerNonWalkableModeEnum;
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.nonWalkableMode = value;
        switch (WhenMappings.$EnumSwitchMapping$1[value.ordinal()]) {
            case 1: {
                pxControllerNonWalkableModeEnum = PxControllerNonWalkableModeEnum.ePREVENT_CLIMBING;
                break;
            }
            case 2: {
                pxControllerNonWalkableModeEnum = PxControllerNonWalkableModeEnum.ePREVENT_CLIMBING_AND_FORCE_SLIDING;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.pxController.setNonWalkableMode(pxControllerNonWalkableModeEnum);
    }

    @Override
    protected void move(@NotNull Vec3f displacement, float timeStep) {
        Intrinsics.checkNotNullParameter((Object)displacement, (String)"displacement");
        PxControllerCollisionFlags flags = this.pxController.move(PhysXExtensionsKt.toPxVec3(displacement, this.bufPxVec3), 0.001f, timeStep, this.pxControllerFilters);
        this.setDownCollision(flags.isSet(PxControllerCollisionFlagEnum.eCOLLISION_DOWN));
        this.setUpCollision(flags.isSet(PxControllerCollisionFlagEnum.eCOLLISION_UP));
        this.setSideCollision(flags.isSet(PxControllerCollisionFlagEnum.eCOLLISION_SIDES));
    }

    @Override
    public void resize(float height) {
        this.pxController.resize(height);
    }

    @Override
    public void release() {
        super.release();
        PhysicsWorld physicsWorld = this.getWorld();
        Intrinsics.checkNotNull((Object)((Object)physicsWorld), (String)"null cannot be cast to non-null type de.fabmax.kool.physics.PhysicsWorldImpl");
        ((PhysicsWorldImpl)physicsWorld).deleteActorReference$kool_physics(this.getActor());
        this.pxController.release();
        this.bufPxPosition.destroy();
        this.bufPxVec3.destroy();
        this.pxControllerFilters.destroy();
        this.hitListener.destroy();
        this.behaviorCallback.destroy();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PxControllerNonWalkableModeEnum.values().length];
            try {
                nArray[PxControllerNonWalkableModeEnum.ePREVENT_CLIMBING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PxControllerNonWalkableModeEnum.ePREVENT_CLIMBING_AND_FORCE_SLIDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[NonWalkableMode.values().length];
            try {
                nArray[NonWalkableMode.PREVENT_CLIMBING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NonWalkableMode.PREVENT_CLIMBING_AND_FORCE_SLIDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

