/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.character;

import de.fabmax.kool.math.MathKt;
import de.fabmax.kool.math.MutableVec3d;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3d;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.RigidDynamic;
import de.fabmax.kool.physics.RigidStatic;
import de.fabmax.kool.physics.character.CharacterControllerManager;
import de.fabmax.kool.physics.character.HitActorBehavior;
import de.fabmax.kool.physics.character.HitActorBehaviorCallback;
import de.fabmax.kool.physics.character.NonWalkableMode;
import de.fabmax.kool.physics.character.OnHitActorListener;
import de.fabmax.kool.util.BaseReleasable;
import de.fabmax.kool.util.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0001nB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010d\u001a\u00020X2\u0006\u0010e\u001a\u00020\u0015H\u0016J\u0010\u0010U\u001a\u00020X2\u0006\u0010e\u001a\u00020\u0015H\u0016J%\u0010f\u001a\u00020X2\u0006\u0010\n\u001a\u00020g2\u0006\u0010h\u001a\u0002032\u0006\u0010i\u001a\u000203H\u0000\u00a2\u0006\u0002\bjJ\u0018\u0010k\u001a\u00020X2\u0006\u00100\u001a\u0002032\u0006\u0010e\u001a\u00020\u0015H$J\u0010\u0010l\u001a\u00020X2\u0006\u0010\u0014\u001a\u00020\u0015H&J\b\u0010m\u001a\u00020XH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0015X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u0015X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u0018\u0010\u001d\u001a\u00020\u001eX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0017\"\u0004\b \u0010\u0019R\u0018\u0010!\u001a\u00020\"X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b:\u00105R\u001a\u0010;\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0017\"\u0004\b=\u0010\u0019R\u001a\u0010>\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0017\"\u0004\b@\u0010\u0019R\u001a\u0010A\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR$\u0010H\u001a\u00020B2\u0006\u0010G\u001a\u00020B@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010D\"\u0004\bI\u0010FR$\u0010J\u001a\u00020B2\u0006\u0010G\u001a\u00020B@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010D\"\u0004\bK\u0010FR$\u0010L\u001a\u00020B2\u0006\u0010G\u001a\u00020B@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010D\"\u0004\bM\u0010FR\u000e\u0010N\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010S\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010\u0017R#\u0010U\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020X0W0V\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010ZR\u0017\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0V\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010ZR\u001c\u0010^\u001a\u0004\u0018\u00010_X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010c\u00a8\u0006o"}, d2={"Lde/fabmax/kool/physics/character/CharacterController;", "Lde/fabmax/kool/util/BaseReleasable;", "manager", "Lde/fabmax/kool/physics/character/CharacterControllerManager;", "world", "Lde/fabmax/kool/physics/PhysicsWorld;", "<init>", "(Lde/fabmax/kool/physics/character/CharacterControllerManager;Lde/fabmax/kool/physics/PhysicsWorld;)V", "getWorld", "()Lde/fabmax/kool/physics/PhysicsWorld;", "actor", "Lde/fabmax/kool/physics/RigidDynamic;", "getActor", "()Lde/fabmax/kool/physics/RigidDynamic;", "position", "Lde/fabmax/kool/math/Vec3d;", "getPosition", "()Lde/fabmax/kool/math/Vec3d;", "setPosition", "(Lde/fabmax/kool/math/Vec3d;)V", "height", "", "getHeight", "()F", "setHeight", "(F)V", "radius", "getRadius", "setRadius", "slopeLimit", "Lde/fabmax/kool/math/AngleF;", "getSlopeLimit-H2B9tyM", "setSlopeLimit-7PBAxM4", "nonWalkableMode", "Lde/fabmax/kool/physics/character/NonWalkableMode;", "getNonWalkableMode", "()Lde/fabmax/kool/physics/character/NonWalkableMode;", "setNonWalkableMode", "(Lde/fabmax/kool/physics/character/NonWalkableMode;)V", "prevPosition", "Lde/fabmax/kool/math/MutableVec3d;", "getPrevPosition", "()Lde/fabmax/kool/math/MutableVec3d;", "posBuffer", "tmpVec", "Lde/fabmax/kool/math/MutableVec3f;", "gravityVelocity", "jumpVelocity", "displacement", "mutVelocity", "gravity", "Lde/fabmax/kool/math/Vec3f;", "getGravity", "()Lde/fabmax/kool/math/Vec3f;", "movement", "getMovement", "()Lde/fabmax/kool/math/MutableVec3f;", "velocity", "getVelocity", "maxFallSpeed", "getMaxFallSpeed", "setMaxFallSpeed", "jumpSpeed", "getJumpSpeed", "setJumpSpeed", "jump", "", "getJump", "()Z", "setJump", "(Z)V", "value", "isDownCollision", "setDownCollision", "isUpCollision", "setUpCollision", "isSideCollision", "setSideCollision", "lastGroundTouch", "isStandingOnGround", "isStaticGroundHit", "slopeObserver", "Lde/fabmax/kool/physics/character/CharacterController$GroundSlopeObserver;", "slopeSlideFac", "getSlopeSlideFac", "onPhysicsUpdate", "", "Lkotlin/Function1;", "", "getOnPhysicsUpdate", "()Ljava/util/List;", "onHitActorListeners", "Lde/fabmax/kool/physics/character/OnHitActorListener;", "getOnHitActorListeners", "hitActorBehaviorCallback", "Lde/fabmax/kool/physics/character/HitActorBehaviorCallback;", "getHitActorBehaviorCallback", "()Lde/fabmax/kool/physics/character/HitActorBehaviorCallback;", "setHitActorBehaviorCallback", "(Lde/fabmax/kool/physics/character/HitActorBehaviorCallback;)V", "onAdvancePhysics", "timeStep", "onHitActor", "Lde/fabmax/kool/physics/RigidActor;", "hitWorldPos", "hitWorldNormal", "onHitActor$kool_physics", "move", "resize", "release", "GroundSlopeObserver", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nCharacterController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterController.kt\nde/fabmax/kool/physics/character/CharacterController\n+ 2 Math.kt\nde/fabmax/kool/math/MathKt\n*L\n1#1,166:1\n34#2:167\n*S KotlinDebug\n*F\n+ 1 CharacterController.kt\nde/fabmax/kool/physics/character/CharacterController\n*L\n65#1:167\n*E\n"})
public abstract class CharacterController
extends BaseReleasable {
    @NotNull
    private final CharacterControllerManager manager;
    @NotNull
    private final PhysicsWorld world;
    @NotNull
    private final MutableVec3d prevPosition;
    @NotNull
    private final MutableVec3d posBuffer;
    @NotNull
    private final MutableVec3f tmpVec;
    @NotNull
    private final MutableVec3f gravityVelocity;
    @NotNull
    private final MutableVec3f jumpVelocity;
    @NotNull
    private final MutableVec3f displacement;
    @NotNull
    private final MutableVec3f mutVelocity;
    @NotNull
    private final MutableVec3f movement;
    private float maxFallSpeed;
    private float jumpSpeed;
    private boolean jump;
    private boolean isDownCollision;
    private boolean isUpCollision;
    private boolean isSideCollision;
    private float lastGroundTouch;
    private boolean isStandingOnGround;
    private boolean isStaticGroundHit;
    @NotNull
    private final GroundSlopeObserver slopeObserver;
    @NotNull
    private final List<Function1<Float, Unit>> onPhysicsUpdate;
    @NotNull
    private final List<OnHitActorListener> onHitActorListeners;
    @Nullable
    private HitActorBehaviorCallback hitActorBehaviorCallback;

    public CharacterController(@NotNull CharacterControllerManager manager, @NotNull PhysicsWorld world) {
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        Intrinsics.checkNotNullParameter((Object)((Object)world), (String)"world");
        this.manager = manager;
        this.world = world;
        this.prevPosition = new MutableVec3d();
        this.posBuffer = new MutableVec3d();
        this.tmpVec = new MutableVec3f();
        this.gravityVelocity = new MutableVec3f();
        this.jumpVelocity = new MutableVec3f();
        this.displacement = new MutableVec3f();
        this.mutVelocity = new MutableVec3f();
        this.movement = new MutableVec3f();
        this.maxFallSpeed = 30.0f;
        this.jumpSpeed = 6.0f;
        this.slopeObserver = new GroundSlopeObserver();
        this.onPhysicsUpdate = new ArrayList();
        this.onHitActorListeners = new ArrayList();
        this.hitActorBehaviorCallback = CharacterController::hitActorBehaviorCallback$lambda$0;
    }

    @NotNull
    public final PhysicsWorld getWorld() {
        return this.world;
    }

    @NotNull
    public abstract RigidDynamic getActor();

    @NotNull
    public abstract Vec3d getPosition();

    public abstract void setPosition(@NotNull Vec3d var1);

    public abstract float getHeight();

    public abstract void setHeight(float var1);

    public abstract float getRadius();

    public abstract void setRadius(float var1);

    public abstract float getSlopeLimit-H2B9tyM();

    public abstract void setSlopeLimit-7PBAxM4(float var1);

    @NotNull
    public abstract NonWalkableMode getNonWalkableMode();

    public abstract void setNonWalkableMode(@NotNull NonWalkableMode var1);

    @NotNull
    protected final MutableVec3d getPrevPosition() {
        return this.prevPosition;
    }

    private final Vec3f getGravity() {
        return this.world.getGravity();
    }

    @NotNull
    public final MutableVec3f getMovement() {
        return this.movement;
    }

    @NotNull
    public final Vec3f getVelocity() {
        return (Vec3f)this.mutVelocity;
    }

    public final float getMaxFallSpeed() {
        return this.maxFallSpeed;
    }

    public final void setMaxFallSpeed(float f) {
        this.maxFallSpeed = f;
    }

    public final float getJumpSpeed() {
        return this.jumpSpeed;
    }

    public final void setJumpSpeed(float f) {
        this.jumpSpeed = f;
    }

    public final boolean getJump() {
        return this.jump;
    }

    public final void setJump(boolean bl) {
        this.jump = bl;
    }

    public final boolean isDownCollision() {
        return this.isDownCollision;
    }

    protected final void setDownCollision(boolean bl) {
        this.isDownCollision = bl;
    }

    public final boolean isUpCollision() {
        return this.isUpCollision;
    }

    protected final void setUpCollision(boolean bl) {
        this.isUpCollision = bl;
    }

    public final boolean isSideCollision() {
        return this.isSideCollision;
    }

    protected final void setSideCollision(boolean bl) {
        this.isSideCollision = bl;
    }

    private final float getSlopeSlideFac() {
        return this.getNonWalkableMode() == NonWalkableMode.PREVENT_CLIMBING ? 0.0f : MathKt.smoothStep((float)(this.getSlopeLimit-H2B9tyM() * 0.7f), (float)this.getSlopeLimit-H2B9tyM(), (float)this.slopeObserver.getGroundSlopeRad());
    }

    @NotNull
    public final List<Function1<Float, Unit>> getOnPhysicsUpdate() {
        return this.onPhysicsUpdate;
    }

    @NotNull
    public final List<OnHitActorListener> getOnHitActorListeners() {
        return this.onHitActorListeners;
    }

    @Nullable
    public final HitActorBehaviorCallback getHitActorBehaviorCallback() {
        return this.hitActorBehaviorCallback;
    }

    public final void setHitActorBehaviorCallback(@Nullable HitActorBehaviorCallback hitActorBehaviorCallback) {
        this.hitActorBehaviorCallback = hitActorBehaviorCallback;
    }

    public void onAdvancePhysics(float timeStep) {
        boolean isNoMove;
        float $this$isFuzzyZero_u24default$iv = this.movement.length();
        float eps$iv = 1.0E-5f;
        boolean $i$f$isFuzzyZero = false;
        boolean bl = isNoMove = Math.abs($this$isFuzzyZero_u24default$iv) <= eps$iv;
        if (!isNoMove || this.jump) {
            this.isStandingOnGround = false;
            this.isStaticGroundHit = false;
        }
        if (!this.isDownCollision && !this.isStandingOnGround) {
            if (this.lastGroundTouch == 0.0f) {
                this.gravityVelocity.set(new Vec3f(0.0f, this.getVelocity().getY(), 0.0f));
            }
            this.gravityVelocity.add((Vec3f)this.tmpVec.set(this.getGravity()).mul(timeStep));
            this.lastGroundTouch += timeStep;
        } else {
            this.gravityVelocity.set(this.getGravity().times(RangesKt.coerceAtLeast((float)(0.25f * this.getSlopeSlideFac()), (float)0.001f)));
            this.lastGroundTouch = 0.0f;
            if (isNoMove && this.isDownCollision && this.isStaticGroundHit) {
                this.isStandingOnGround = true;
            }
        }
        float fallSpeed = this.tmpVec.set(this.getGravity()).norm().dot((Vec3f)this.gravityVelocity);
        if (this.jump && this.lastGroundTouch < 0.25f && fallSpeed >= 0.0f) {
            this.gravityVelocity.set((Vec3f)this.tmpVec.set(this.getGravity()).norm().mul(-this.jumpSpeed));
        }
        this.displacement.set((Vec3f)this.movement).mul(timeStep).add((Vec3f)this.tmpVec.set((Vec3f)this.gravityVelocity).mul(timeStep));
        this.move((Vec3f)this.displacement, timeStep);
    }

    public void onPhysicsUpdate(float timeStep) {
        this.posBuffer.set(this.getPosition());
        this.mutVelocity.set((float)(this.posBuffer.getX() - this.prevPosition.getX()), (float)(this.posBuffer.getY() - this.prevPosition.getY()), (float)(this.posBuffer.getZ() - this.prevPosition.getZ())).mul(1.0f / timeStep);
        this.prevPosition.set((Vec3d)this.posBuffer);
        this.getActor().onPhysicsUpdate(timeStep);
        int n = ((Collection)this.onPhysicsUpdate).size();
        for (int i = 0; i < n; ++i) {
            this.onPhysicsUpdate.get(i).invoke((Object)Float.valueOf(timeStep));
        }
    }

    public final void onHitActor$kool_physics(@NotNull RigidActor actor, @NotNull Vec3f hitWorldPos, @NotNull Vec3f hitWorldNormal) {
        Vec3f upDir;
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        Intrinsics.checkNotNullParameter((Object)hitWorldPos, (String)"hitWorldPos");
        Intrinsics.checkNotNullParameter((Object)hitWorldNormal, (String)"hitWorldNormal");
        this.slopeObserver.onTouch(hitWorldNormal);
        if (actor instanceof RigidStatic && hitWorldNormal.dot(upDir = this.getGravity().normed(this.tmpVec).times(-1.0f)) > (float)Math.cos(this.getSlopeLimit-H2B9tyM())) {
            this.isStaticGroundHit = true;
        }
        int n = ((Collection)this.onHitActorListeners).size();
        for (int i = 0; i < n; ++i) {
            this.onHitActorListeners.get(i).onHitActor(actor, hitWorldPos, hitWorldNormal);
        }
    }

    protected abstract void move(@NotNull Vec3f var1, float var2);

    public abstract void resize(float var1);

    public void release() {
        this.manager.removeController(this);
        super.release();
    }

    private static final HitActorBehavior hitActorBehaviorCallback$lambda$0(RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        return actor.getCharacterControllerHitBehavior();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/fabmax/kool/physics/character/CharacterController$GroundSlopeObserver;", "", "<init>", "()V", "groundSlopeRad", "", "getGroundSlopeRad", "()F", "setGroundSlopeRad", "(F)V", "frameIdx", "", "onTouch", "", "normal", "Lde/fabmax/kool/math/Vec3f;", "kool-physics"})
    private static final class GroundSlopeObserver {
        private float groundSlopeRad;
        private int frameIdx = -1;

        public final float getGroundSlopeRad() {
            return this.groundSlopeRad;
        }

        public final void setGroundSlopeRad(float f) {
            this.groundSlopeRad = f;
        }

        public final void onTouch(@NotNull Vec3f normal) {
            Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
            float slope = (float)Math.acos(normal.dot(Vec3f.Companion.getY_AXIS()));
            this.groundSlopeRad = Time.INSTANCE.getFrameCount() != this.frameIdx ? slope : Math.min(slope, this.groundSlopeRad);
        }
    }
}

