/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.articulations;

import de.fabmax.kool.math.PoseF;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsImpl;
import de.fabmax.kool.physics.articulations.Articulation;
import de.fabmax.kool.physics.articulations.ArticulationLink;
import de.fabmax.kool.physics.articulations.ArticulationLinkImpl;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import physx.common.PxTransform;
import physx.physics.PxArticulationFlagEnum;
import physx.physics.PxArticulationLink;
import physx.physics.PxArticulationReducedCoordinate;
import physx.support.SupportFunctions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lde/fabmax/kool/physics/articulations/ArticulationImpl;", "Lde/fabmax/kool/physics/articulations/Articulation;", "isFixedBase", "", "<init>", "(Z)V", "()Z", "pxArticulation", "Lphysx/physics/PxArticulationReducedCoordinate;", "getPxArticulation$kool_physics", "()Lphysx/physics/PxArticulationReducedCoordinate;", "value", "", "minPositionIterations", "getMinPositionIterations", "()I", "setMinPositionIterations", "(I)V", "minVelocityIterations", "getMinVelocityIterations", "setMinVelocityIterations", "createLink", "Lde/fabmax/kool/physics/articulations/ArticulationLink;", "parent", "pose", "Lde/fabmax/kool/math/PoseF;", "wakeUp", "", "putToSleep", "release", "kool-physics"})
public final class ArticulationImpl
extends Articulation {
    private final boolean isFixedBase;
    @NotNull
    private final PxArticulationReducedCoordinate pxArticulation;

    public ArticulationImpl(boolean isFixedBase) {
        this.isFixedBase = isFixedBase;
        PhysicsImpl.INSTANCE.checkIsLoaded();
        PxArticulationReducedCoordinate pxArticulationReducedCoordinate = PhysicsImpl.INSTANCE.getPhysics().createArticulationReducedCoordinate();
        Intrinsics.checkNotNullExpressionValue((Object)pxArticulationReducedCoordinate, (String)"createArticulationReducedCoordinate(...)");
        this.pxArticulation = pxArticulationReducedCoordinate;
        if (this.isFixedBase) {
            this.pxArticulation.setArticulationFlag(PxArticulationFlagEnum.eFIX_BASE, true);
        }
    }

    public final boolean isFixedBase() {
        return this.isFixedBase;
    }

    @NotNull
    public final PxArticulationReducedCoordinate getPxArticulation$kool_physics() {
        return this.pxArticulation;
    }

    @Override
    public int getMinPositionIterations() {
        return SupportFunctions.PxArticulationReducedCoordinate_getMinSolverPositionIterations((PxArticulationReducedCoordinate)this.pxArticulation);
    }

    @Override
    public void setMinPositionIterations(int value) {
        this.pxArticulation.setSolverIterationCounts(value, this.getMinVelocityIterations());
    }

    @Override
    public int getMinVelocityIterations() {
        return SupportFunctions.PxArticulationReducedCoordinate_getMinSolverVelocityIterations((PxArticulationReducedCoordinate)this.pxArticulation);
    }

    @Override
    public void setMinVelocityIterations(int value) {
        this.pxArticulation.setSolverIterationCounts(this.getMinPositionIterations(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ArticulationLink createLink(@Nullable ArticulationLink parent, @NotNull PoseF pose) {
        ArticulationLinkImpl articulationLinkImpl;
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        ArticulationLinkImpl cfr_ignored_0 = (ArticulationLinkImpl)parent;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            PxTransform pxPose = PhysXExtensionsKt.toPxTransform(pose, pxTransform);
            ArticulationLinkImpl articulationLinkImpl2 = (ArticulationLinkImpl)parent;
            PxArticulationLink pxLink = this.pxArticulation.createLink((PxArticulationLink)(articulationLinkImpl2 != null ? articulationLinkImpl2.getHolder() : null), pxPose);
            Intrinsics.checkNotNull((Object)pxLink);
            ArticulationLinkImpl link = new ArticulationLinkImpl(pxLink, (ArticulationLinkImpl)parent);
            ((Collection)this.get_links()).add(link);
            articulationLinkImpl = link;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return articulationLinkImpl;
    }

    @Override
    public void wakeUp() {
        this.pxArticulation.wakeUp();
    }

    @Override
    public void putToSleep() {
        this.pxArticulation.putToSleep();
    }

    public void release() {
        super.release();
        this.pxArticulation.release();
    }
}

