/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.RayF;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.ContactPoint;
import de.fabmax.kool.physics.FilterDataBuilder;
import de.fabmax.kool.physics.FilterDataKt;
import de.fabmax.kool.physics.HitResult;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsImpl;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.RigidDynamic;
import de.fabmax.kool.physics.TriggerListener;
import de.fabmax.kool.physics.articulations.Articulation;
import de.fabmax.kool.physics.articulations.ArticulationImpl;
import de.fabmax.kool.physics.articulations.ArticulationLink;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.scene.Scene;
import de.fabmax.kool.util.Log;
import de.fabmax.kool.util.LogPrinter;
import de.fabmax.kool.util.Releasable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxCpuDispatcher;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxActor;
import physx.physics.PxContactPair;
import physx.physics.PxContactPairHeader;
import physx.physics.PxContactPairPoint;
import physx.physics.PxPairFlagEnum;
import physx.physics.PxPairFlags;
import physx.physics.PxRaycastCallback;
import physx.physics.PxRaycastHit;
import physx.physics.PxRaycastResult;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxScene;
import physx.physics.PxSceneDesc;
import physx.physics.PxSceneFlagEnum;
import physx.physics.PxSimulationEventCallback;
import physx.physics.PxSimulationEventCallbackImpl;
import physx.physics.PxSweepCallback;
import physx.physics.PxSweepHit;
import physx.physics.PxSweepResult;
import physx.physics.PxTriggerPair;
import physx.support.PxArray_PxActorPtr;
import physx.support.PxArray_PxContactPairPoint;
import physx.support.SupportFunctions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001FB\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020'H\u0016J\u0015\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020%H\u0000\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020'2\u0006\u0010,\u001a\u00020%H\u0000\u00a2\u0006\u0002\b/J\u0010\u00100\u001a\u0004\u0018\u00010%2\u0006\u00101\u001a\u00020$J\u0010\u00102\u001a\u00020'2\u0006\u0010,\u001a\u00020%H\u0016J\u0010\u00103\u001a\u00020'2\u0006\u0010,\u001a\u00020%H\u0016J\u0010\u00104\u001a\u00020'2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020'2\u0006\u00105\u001a\u000206H\u0016J\b\u00108\u001a\u00020'H\u0016J \u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020>H\u0016J0\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020)2\u0006\u0010=\u001a\u00020>H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lde/fabmax/kool/physics/PhysicsWorldImpl;", "Lde/fabmax/kool/physics/PhysicsWorld;", "Lde/fabmax/kool/util/Releasable;", "scene", "Lde/fabmax/kool/scene/Scene;", "isContinuousCollisionDetection", "", "<init>", "(Lde/fabmax/kool/scene/Scene;Z)V", "()Z", "pxScene", "Lphysx/physics/PxScene;", "getPxScene", "()Lphysx/physics/PxScene;", "raycastResult", "Lphysx/physics/PxRaycastResult;", "sweepResult", "Lphysx/physics/PxSweepResult;", "bufPxGravity", "Lphysx/common/PxVec3;", "bufGravity", "Lde/fabmax/kool/math/MutableVec3f;", "value", "Lde/fabmax/kool/math/Vec3f;", "gravity", "getGravity", "()Lde/fabmax/kool/math/Vec3f;", "setGravity", "(Lde/fabmax/kool/math/Vec3f;)V", "mutActiveActors", "", "activeActors", "getActiveActors", "()I", "pxActors", "", "Lphysx/physics/PxActor;", "Lde/fabmax/kool/physics/RigidActor;", "singleStepAsync", "", "timeStep", "", "fetchAsyncStepResults", "registerActorReference", "actor", "registerActorReference$kool_physics", "deleteActorReference", "deleteActorReference$kool_physics", "getActor", "pxActor", "addActor", "removeActor", "addArticulation", "articulation", "Lde/fabmax/kool/physics/articulations/Articulation;", "removeArticulation", "release", "raycast", "ray", "Lde/fabmax/kool/math/RayF;", "maxDistance", "result", "Lde/fabmax/kool/physics/HitResult;", "sweepTest", "testGeometry", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "geometryPose", "Lde/fabmax/kool/math/Mat4f;", "testDirection", "distance", "SimEventCallback", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nPhysicsWorld.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsWorld.desktop.kt\nde/fabmax/kool/physics/PhysicsWorldImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1#2:269\n1869#3,2:270\n1869#3,2:272\n*S KotlinDebug\n*F\n+ 1 PhysicsWorld.desktop.kt\nde/fabmax/kool/physics/PhysicsWorldImpl\n*L\n120#1:270,2\n126#1:272,2\n*E\n"})
public final class PhysicsWorldImpl
extends PhysicsWorld
implements Releasable {
    private final boolean isContinuousCollisionDetection;
    @NotNull
    private final PxScene pxScene;
    @NotNull
    private final PxRaycastResult raycastResult;
    @NotNull
    private final PxSweepResult sweepResult;
    @NotNull
    private final PxVec3 bufPxGravity;
    @NotNull
    private final MutableVec3f bufGravity;
    private int mutActiveActors;
    @NotNull
    private final Map<PxActor, RigidActor> pxActors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicsWorldImpl(@Nullable Scene scene, boolean isContinuousCollisionDetection) {
        block7: {
            this.isContinuousCollisionDetection = isContinuousCollisionDetection;
            this.raycastResult = new PxRaycastResult();
            this.sweepResult = new PxSweepResult();
            this.bufPxGravity = PhysXExtensionsKt.toPxVec3(new Vec3f(0.0f, -9.81f, 0.0f), new PxVec3());
            this.bufGravity = new MutableVec3f();
            this.pxActors = new LinkedHashMap();
            PhysicsImpl.INSTANCE.checkIsLoaded();
            AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                MemoryStack mem = (MemoryStack)autoCloseable;
                boolean bl = false;
                PxSceneDesc sceneDesc = PxSceneDesc.createAt((Object)mem, MemoryStack::nmalloc, (PxTolerancesScale)PhysicsImpl.INSTANCE.getPhysics().getTolerancesScale());
                sceneDesc.setGravity(this.bufPxGravity);
                sceneDesc.setCpuDispatcher((PxCpuDispatcher)PhysicsImpl.INSTANCE.getDefaultCpuDispatcher());
                sceneDesc.setFilterShader(PxTopLevelFunctions.DefaultFilterShader());
                sceneDesc.setSimulationEventCallback((PxSimulationEventCallback)new SimEventCallback());
                sceneDesc.getFlags().raise(PxSceneFlagEnum.eENABLE_ACTIVE_ACTORS);
                if (this.isContinuousCollisionDetection) {
                    sceneDesc.getFlags().raise(PxSceneFlagEnum.eENABLE_CCD);
                }
                PxScene pxScene = PhysicsImpl.INSTANCE.getPhysics().createScene(sceneDesc);
                Intrinsics.checkNotNullExpressionValue((Object)pxScene, (String)"createScene(...)");
                this.pxScene = pxScene;
                mem = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Scene scene2 = scene;
            if (scene2 == null) break block7;
            Scene it = scene2;
            boolean bl = false;
            this.registerHandlers(it);
        }
    }

    public final boolean isContinuousCollisionDetection() {
        return this.isContinuousCollisionDetection;
    }

    @NotNull
    public final PxScene getPxScene() {
        return this.pxScene;
    }

    @Override
    @NotNull
    public Vec3f getGravity() {
        PxVec3 pxVec3 = this.pxScene.getGravity();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"getGravity(...)");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufGravity);
    }

    @Override
    public void setGravity(@NotNull Vec3f value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.pxScene.setGravity(PhysXExtensionsKt.toPxVec3(value, this.bufPxGravity));
    }

    @Override
    public int getActiveActors() {
        return this.mutActiveActors;
    }

    @Override
    public void singleStepAsync(float timeStep) {
        super.singleStepAsync(timeStep);
        this.pxScene.simulate(timeStep);
    }

    @Override
    public void fetchAsyncStepResults() {
        this.pxScene.fetchResults(true);
        int n = ((Collection)this.getActors()).size();
        for (int i = 0; i < n; ++i) {
            this.getActors().get(i).setActive(false);
        }
        PxArray_PxActorPtr activeActors = SupportFunctions.PxScene_getActiveActors((PxScene)this.pxScene);
        this.mutActiveActors = activeActors.size();
        int n2 = this.mutActiveActors;
        for (int i = 0; i < n2; ++i) {
            RigidActor rigidActor = this.pxActors.get(activeActors.get(i));
            if (rigidActor == null) continue;
            rigidActor.setActive(true);
        }
        super.fetchAsyncStepResults();
    }

    public final void registerActorReference$kool_physics(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        this.pxActors.put((PxActor)actor.getHolder(), actor);
    }

    public final void deleteActorReference$kool_physics(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        this.pxActors.remove(actor.getHolder());
    }

    @Nullable
    public final RigidActor getActor(@NotNull PxActor pxActor) {
        Intrinsics.checkNotNullParameter((Object)pxActor, (String)"pxActor");
        return this.pxActors.get(pxActor);
    }

    @Override
    public void addActor(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        super.addActor(actor);
        this.pxScene.addActor((PxActor)actor.getHolder());
        this.registerActorReference$kool_physics(actor);
        PxRigidActor pxActor = actor.getHolder();
        if (this.isContinuousCollisionDetection && pxActor instanceof PxRigidBody) {
            if (actor instanceof RigidDynamic && !((RigidDynamic)actor).isKinematic()) {
                ((PxRigidBody)pxActor).setRigidBodyFlag(PxRigidBodyFlagEnum.eENABLE_CCD, true);
            }
            actor.setSimulationFilterData(FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)arg_0 -> PhysicsWorldImpl.addActor$lambda$2(actor, arg_0))));
        }
    }

    @Override
    public void removeActor(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        super.removeActor(actor);
        this.pxScene.removeActor((PxActor)actor.getHolder());
        this.deleteActorReference$kool_physics(actor);
    }

    @Override
    public void addArticulation(@NotNull Articulation articulation) {
        Intrinsics.checkNotNullParameter((Object)((Object)articulation), (String)"articulation");
        super.addArticulation(articulation);
        Iterable $this$forEach$iv = articulation.getLinks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArticulationLink it = (ArticulationLink)element$iv;
            boolean bl = false;
            this.pxActors.put((PxActor)it.getHolder(), it);
        }
        this.pxScene.addArticulation(((ArticulationImpl)articulation).getPxArticulation$kool_physics());
    }

    @Override
    public void removeArticulation(@NotNull Articulation articulation) {
        Intrinsics.checkNotNullParameter((Object)((Object)articulation), (String)"articulation");
        super.removeArticulation(articulation);
        Iterable $this$forEach$iv = articulation.getLinks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArticulationLink it = (ArticulationLink)element$iv;
            boolean bl = false;
            this.pxActors.remove(it.getHolder());
        }
        this.pxScene.removeArticulation(((ArticulationImpl)articulation).getPxArticulation$kool_physics());
    }

    @Override
    public void release() {
        super.release();
        this.pxScene.release();
        this.bufPxGravity.destroy();
        this.raycastResult.destroy();
        this.sweepResult.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean raycast(@NotNull RayF ray, float maxDistance, @NotNull HitResult result) {
        Intrinsics.checkNotNullParameter((Object)ray, (String)"ray");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.clear();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            PxRaycastResult pxRaycastResult = this.raycastResult;
            synchronized (pxRaycastResult) {
                boolean bl2 = false;
                Vec3f vec3f = (Vec3f)ray.getOrigin();
                Intrinsics.checkNotNull((Object)mem);
                PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
                Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"createPxVec3(...)");
                PxVec3 ori = PhysXExtensionsKt.toPxVec3(vec3f, pxVec3);
                Vec3f vec3f2 = (Vec3f)ray.getDirection();
                PxVec3 pxVec32 = PhysXExtensionsKt.createPxVec3(mem);
                Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"createPxVec3(...)");
                PxVec3 dir = PhysXExtensionsKt.toPxVec3(vec3f2, pxVec32);
                if (this.pxScene.raycast(ori, dir, maxDistance, (PxRaycastCallback)this.raycastResult)) {
                    float minDist = maxDistance;
                    PxRaycastHit nearestHit = null;
                    RigidActor nearestActor = null;
                    int n = this.raycastResult.getNbAnyHits();
                    for (int i = 0; i < n; ++i) {
                        PxRaycastHit hit = this.raycastResult.getAnyHit(i);
                        RigidActor actor = this.pxActors.get(hit.getActor());
                        if (actor == null || !(hit.getDistance() < minDist)) continue;
                        ((Collection)result.getHitActors()).add(actor);
                        minDist = hit.getDistance();
                        nearestHit = hit;
                        nearestActor = actor;
                    }
                    if (nearestHit != null) {
                        result.setNearestActor(nearestActor);
                        result.setHitDistance(minDist);
                        PxVec3 pxVec33 = nearestHit.getPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)pxVec33, (String)"getPosition(...)");
                        PhysXExtensionsKt.toVec3f(pxVec33, result.getHitPosition());
                        PxVec3 pxVec34 = nearestHit.getNormal();
                        Intrinsics.checkNotNullExpressionValue((Object)pxVec34, (String)"getNormal(...)");
                        PhysXExtensionsKt.toVec3f(pxVec34, result.getHitNormal());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result.isHit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sweepTest(@NotNull CollisionGeometry testGeometry, @NotNull Mat4f geometryPose, @NotNull Vec3f testDirection, float distance, @NotNull HitResult result) {
        Intrinsics.checkNotNullParameter((Object)testGeometry, (String)"testGeometry");
        Intrinsics.checkNotNullParameter((Object)geometryPose, (String)"geometryPose");
        Intrinsics.checkNotNullParameter((Object)testDirection, (String)"testDirection");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.clear();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            PxTransform sweepPose = PhysXExtensionsKt.toPxTransform(geometryPose, pxTransform);
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"createPxVec3(...)");
            PxVec3 sweepDir = PhysXExtensionsKt.toPxVec3(testDirection, pxVec3);
            if (this.pxScene.sweep(testGeometry.getHolder(), sweepPose, sweepDir, distance, (PxSweepCallback)this.sweepResult)) {
                float minDist = distance;
                PxSweepHit nearestHit = null;
                RigidActor nearestActor = null;
                int n = this.sweepResult.getNbAnyHits();
                for (int i = 0; i < n; ++i) {
                    PxSweepHit hit = this.sweepResult.getAnyHit(i);
                    RigidActor actor = this.pxActors.get(hit.getActor());
                    if (actor == null || !(hit.getDistance() < minDist)) continue;
                    ((Collection)result.getHitActors()).add(actor);
                    minDist = hit.getDistance();
                    nearestHit = hit;
                    nearestActor = actor;
                }
                if (nearestHit != null) {
                    result.setNearestActor(nearestActor);
                    result.setHitDistance(minDist);
                    PxVec3 pxVec32 = nearestHit.getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"getPosition(...)");
                    PhysXExtensionsKt.toVec3f(pxVec32, result.getHitPosition());
                    PxVec3 pxVec33 = nearestHit.getNormal();
                    Intrinsics.checkNotNullExpressionValue((Object)pxVec33, (String)"getNormal(...)");
                    PhysXExtensionsKt.toVec3f(pxVec33, result.getHitNormal());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result.isHit();
    }

    private static final Unit addActor$lambda$2(RigidActor $actor, FilterDataBuilder $this$FilterData) {
        Intrinsics.checkNotNullParameter((Object)$this$FilterData, (String)"$this$FilterData");
        $this$FilterData.set($actor.getSimulationFilterData());
        $this$FilterData.setWord2(PxPairFlagEnum.eDETECT_CCD_CONTACT.value);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lde/fabmax/kool/physics/PhysicsWorldImpl$SimEventCallback;", "Lphysx/physics/PxSimulationEventCallbackImpl;", "<init>", "(Lde/fabmax/kool/physics/PhysicsWorldImpl;)V", "contacts", "Lphysx/support/PxArray_PxContactPairPoint;", "getContacts", "()Lphysx/support/PxArray_PxContactPairPoint;", "onTrigger", "", "pairs", "Lphysx/physics/PxTriggerPair;", "count", "", "onContact", "pairHeader", "Lphysx/physics/PxContactPairHeader;", "Lphysx/physics/PxContactPair;", "nbPairs", "kool-physics"})
    @SourceDebugExtension(value={"SMAP\nPhysicsWorld.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsWorld.desktop.kt\nde/fabmax/kool/physics/PhysicsWorldImpl$SimEventCallback\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Log.kt\nde/fabmax/kool/util/LogKt\n+ 5 Log.kt\nde/fabmax/kool/util/Log\n*L\n1#1,268:1\n384#2,7:269\n1869#3,2:276\n1869#3,2:278\n41#4,7:280\n40#4,7:291\n18#5,4:287\n18#5,4:298\n*S KotlinDebug\n*F\n+ 1 PhysicsWorld.desktop.kt\nde/fabmax/kool/physics/PhysicsWorldImpl$SimEventCallback\n*L\n215#1:269,7\n219#1:276,2\n224#1:278,2\n230#1:280,7\n240#1:291,7\n230#1:287,4\n240#1:298,4\n*E\n"})
    private final class SimEventCallback
    extends PxSimulationEventCallbackImpl {
        @NotNull
        private final PxArray_PxContactPairPoint contacts = new PxArray_PxContactPairPoint(64);

        @NotNull
        public final PxArray_PxContactPairPoint getContacts() {
            return this.contacts;
        }

        /*
         * WARNING - void declaration
         */
        public void onTrigger(@NotNull PxTriggerPair pairs, int count) {
            Intrinsics.checkNotNullParameter((Object)pairs, (String)"pairs");
            for (int i = 0; i < count; ++i) {
                void this_$iv$iv$iv;
                Object $this$forEach$iv;
                PxTriggerPair pair = PxTriggerPair.arrayGet((long)pairs.getAddress(), (int)i);
                boolean isEnter = pair.getStatus() == PxPairFlagEnum.eNOTIFY_TOUCH_FOUND;
                RigidActor trigger = (RigidActor)PhysicsWorldImpl.this.pxActors.get(pair.getTriggerActor());
                RigidActor actor = (RigidActor)PhysicsWorldImpl.this.pxActors.get(pair.getOtherActor());
                if (trigger != null && actor != null) {
                    TriggerListener it;
                    boolean $i$f$forEach2;
                    Integer n;
                    PhysicsWorld.TriggerListenerContext triggerListenerContext;
                    if (PhysicsWorldImpl.this.getTriggerListeners().get(trigger) == null) continue;
                    PhysicsWorld.TriggerListenerContext $this$onTrigger_u24lambda_u243 = triggerListenerContext;
                    boolean bl = false;
                    Map<RigidActor, Integer> $this$getOrPut$iv = $this$onTrigger_u24lambda_u243.getActorEnterCounts();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(actor);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        Integer answer$iv = 0;
                        $this$getOrPut$iv.put(actor, answer$iv);
                        n = answer$iv;
                    } else {
                        n = value$iv;
                    }
                    int cnt = ((Number)n).intValue();
                    if (isEnter) {
                        if (++cnt == 1) {
                            $this$forEach$iv = $this$onTrigger_u24lambda_u243.getListeners();
                            $i$f$forEach2 = false;
                            value$iv = $this$forEach$iv.iterator();
                            while (value$iv.hasNext()) {
                                Object element$iv = value$iv.next();
                                it = (TriggerListener)element$iv;
                                boolean bl3 = false;
                                it.onActorEntered(trigger, actor);
                            }
                        }
                    } else if (--cnt == 0) {
                        $this$forEach$iv = $this$onTrigger_u24lambda_u243.getListeners();
                        $i$f$forEach2 = false;
                        value$iv = $this$forEach$iv.iterator();
                        while (value$iv.hasNext()) {
                            Object element$iv = value$iv.next();
                            it = (TriggerListener)element$iv;
                            boolean bl4 = false;
                            it.onActorExited(trigger, actor);
                        }
                    }
                    Integer $i$f$forEach2 = cnt;
                    $this$onTrigger_u24lambda_u243.getActorEnterCounts().put(actor, $i$f$forEach2);
                    continue;
                }
                SimEventCallback $this$logE$iv = this;
                boolean $i$f$logE = false;
                String tag$iv$iv = Reflection.getOrCreateKotlinClass(((Object)((Object)$this$logE$iv)).getClass()).getSimpleName();
                boolean $i$f$logE2 = false;
                $this$forEach$iv = Log.INSTANCE;
                Log.Level level$iv$iv$iv = Log.Level.ERROR;
                boolean $i$f$log = false;
                if (level$iv$iv$iv.getLevel() < this_$iv$iv$iv.getLevel().getLevel()) continue;
                String string = tag$iv$iv;
                Log.Level level = level$iv$iv$iv;
                LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string2 = "actor reference not found";
                logPrinter.print(level, string, string2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void onContact(@NotNull PxContactPairHeader pairHeader, @NotNull PxContactPair pairs, int nbPairs) {
            Intrinsics.checkNotNullParameter((Object)pairHeader, (String)"pairHeader");
            Intrinsics.checkNotNullParameter((Object)pairs, (String)"pairs");
            RigidActor actorA = (RigidActor)PhysicsWorldImpl.this.pxActors.get(pairHeader.getActors(0));
            RigidActor actorB = (RigidActor)PhysicsWorldImpl.this.pxActors.get(pairHeader.getActors(1));
            if (actorA == null || actorB == null) {
                void this_$iv$iv$iv;
                SimEventCallback $this$logW$iv = this;
                boolean $i$f$logW = false;
                String tag$iv$iv = Reflection.getOrCreateKotlinClass(((Object)((Object)$this$logW$iv)).getClass()).getSimpleName();
                boolean $i$f$logW2 = false;
                Log log = Log.INSTANCE;
                Log.Level level$iv$iv$iv = Log.Level.WARN;
                boolean $i$f$log = false;
                if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                    String string = tag$iv$iv;
                    Log.Level level = level$iv$iv$iv;
                    LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                    boolean bl = false;
                    String string2 = "onContact: actor reference not found";
                    logPrinter.print(level, string, string2);
                }
                return;
            }
            for (int i = 0; i < nbPairs; ++i) {
                PxContactPair pair = PxContactPair.arrayGet((long)pairs.getAddress(), (int)i);
                PxPairFlags evts = pair.getEvents();
                if (evts.isSet(PxPairFlagEnum.eNOTIFY_TOUCH_FOUND)) {
                    List contactPoints = null;
                    int pxContactPoints = pair.extractContacts(this.contacts.begin(), 64);
                    if (pxContactPoints > 0) {
                        contactPoints = new ArrayList();
                        for (int iPt = 0; iPt < pxContactPoints; ++iPt) {
                            PxContactPairPoint contact = this.contacts.get(iPt);
                            Collection collection = contactPoints;
                            PxVec3 pxVec3 = contact.getPosition();
                            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"getPosition(...)");
                            Vec3f vec3f = (Vec3f)PhysXExtensionsKt.toVec3f$default(pxVec3, null, 1, null);
                            PxVec3 pxVec32 = contact.getNormal();
                            Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"getNormal(...)");
                            Vec3f vec3f2 = (Vec3f)PhysXExtensionsKt.toVec3f$default(pxVec32, null, 1, null);
                            PxVec3 pxVec33 = contact.getImpulse();
                            Intrinsics.checkNotNullExpressionValue((Object)pxVec33, (String)"getImpulse(...)");
                            collection.add(new ContactPoint(vec3f, vec3f2, (Vec3f)PhysXExtensionsKt.toVec3f$default(pxVec33, null, 1, null), contact.getSeparation()));
                        }
                    } else {
                        contactPoints = null;
                    }
                    PhysicsWorldImpl.this.fireOnTouchFound(actorA, actorB, contactPoints);
                    continue;
                }
                if (!evts.isSet(PxPairFlagEnum.eNOTIFY_TOUCH_LOST)) continue;
                PhysicsWorldImpl.this.fireOnTouchLost(actorA, actorB);
            }
        }
    }
}

