/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.math.AngleKt;
import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.PoseF;
import de.fabmax.kool.math.QuatF;
import de.fabmax.kool.math.RayF;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.ConstantPhysicsStepperSync;
import de.fabmax.kool.physics.ContactListener;
import de.fabmax.kool.physics.ContactPoint;
import de.fabmax.kool.physics.HitResult;
import de.fabmax.kool.physics.Material_desktopKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.PhysicsStepListener;
import de.fabmax.kool.physics.PhysicsStepper;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.RigidDynamic;
import de.fabmax.kool.physics.RigidStatic;
import de.fabmax.kool.physics.RigidStatic_desktopKt;
import de.fabmax.kool.physics.Shape;
import de.fabmax.kool.physics.TriggerListener;
import de.fabmax.kool.physics.articulations.Articulation;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.physics.geometry.CollisionGeometry_desktopKt;
import de.fabmax.kool.scene.Scene;
import de.fabmax.kool.util.BaseReleasable;
import de.fabmax.kool.util.BufferedList;
import de.fabmax.kool.util.Log;
import de.fabmax.kool.util.LogPrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001yB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010I\u001a\u00020>2\u0006\u0010J\u001a\u00020:H\u0016J\b\u0010K\u001a\u00020>H\u0016J\u0016\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020&2\u0006\u0010N\u001a\u00020OJ\u000e\u0010P\u001a\u00020>2\u0006\u0010N\u001a\u00020OJ\u000e\u0010Q\u001a\u00020>2\u0006\u0010N\u001a\u000207J\u000e\u0010R\u001a\u00020>2\u0006\u0010N\u001a\u000207J(\u0010S\u001a\u00020>2\u0006\u0010T\u001a\u00020&2\u0006\u0010U\u001a\u00020&2\u000e\u0010V\u001a\n\u0012\u0004\u0012\u00020W\u0018\u00010*H\u0004J\u0018\u0010X\u001a\u00020>2\u0006\u0010T\u001a\u00020&2\u0006\u0010U\u001a\u00020&H\u0004J\b\u0010Y\u001a\u00020>H\u0016J\u0010\u0010Z\u001a\u00020>2\u0006\u0010[\u001a\u00020&H\u0016J\u0010\u0010\\\u001a\u00020>2\u0006\u0010[\u001a\u00020&H\u0016J\u0010\u0010]\u001a\u00020>2\u0006\u0010^\u001a\u00020-H\u0016J\u0010\u0010_\u001a\u00020>2\u0006\u0010^\u001a\u00020-H\u0016J \u0010`\u001a\u00020\u00112\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\u00182\u0006\u0010d\u001a\u00020eH&J0\u0010f\u001a\u00020\u00112\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020@2\u0006\u0010l\u001a\u00020\u00182\u0006\u0010d\u001a\u00020eH&J\u0006\u0010m\u001a\u00020>J\u0010\u0010n\u001a\u00020>2\b\b\u0002\u0010o\u001a\u00020\u0011J \u0010p\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010q\u001a\u00020\u00052\u0006\u0010r\u001a\u00020\u0018H\u0002J\u000e\u0010s\u001a\u00020>2\u0006\u0010t\u001a\u00020\u0018J\u0010\u0010u\u001a\u00020>2\u0006\u0010t\u001a\u00020\u0018H\u0016J\b\u0010v\u001a\u00020>H\u0016J\u0010\u0010\u001d\u001a\u00020>2\u0006\u0010t\u001a\u00020\u0018H\u0014J\u0010\u0010\"\u001a\u00020>2\u0006\u0010t\u001a\u00020\u0018H\u0014J\u0006\u0010w\u001a\u00020xR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020&0*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010(R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010(R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020-0*8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010(R \u00101\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020302X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001a\u00106\u001a\b\u0012\u0004\u0012\u0002070%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010(R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020>0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010?\u001a\u00020@X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0012\u0010E\u001a\u00020FX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\u00a8\u0006z"}, d2={"Lde/fabmax/kool/physics/PhysicsWorld;", "Lde/fabmax/kool/util/BaseReleasable;", "<init>", "()V", "physicsTime", "", "getPhysicsTime", "()D", "setPhysicsTime", "(D)V", "simStepper", "Lde/fabmax/kool/physics/PhysicsStepper;", "getSimStepper", "()Lde/fabmax/kool/physics/PhysicsStepper;", "setSimStepper", "(Lde/fabmax/kool/physics/PhysicsStepper;)V", "isPauseSimulation", "", "()Z", "setPauseSimulation", "(Z)V", "isStepInProgress", "setStepInProgress", "prevStepTime", "", "getPrevStepTime", "()F", "setPrevStepTime", "(F)V", "onAdvancePhysics", "Lde/fabmax/kool/util/BufferedList;", "Lde/fabmax/kool/physics/PhysicsStepListener;", "getOnAdvancePhysics", "()Lde/fabmax/kool/util/BufferedList;", "onPhysicsUpdate", "getOnPhysicsUpdate", "mutActors", "", "Lde/fabmax/kool/physics/RigidActor;", "getMutActors", "()Ljava/util/List;", "actors", "", "getActors", "mutArticulations", "Lde/fabmax/kool/physics/articulations/Articulation;", "getMutArticulations", "articulations", "getArticulations", "triggerListeners", "", "Lde/fabmax/kool/physics/PhysicsWorld$TriggerListenerContext;", "getTriggerListeners", "()Ljava/util/Map;", "contactListeners", "Lde/fabmax/kool/physics/ContactListener;", "getContactListeners", "registeredAtScene", "Lde/fabmax/kool/scene/Scene;", "onRenderSceneHook", "Lkotlin/Function1;", "Lde/fabmax/kool/KoolContext;", "", "gravity", "Lde/fabmax/kool/math/Vec3f;", "getGravity", "()Lde/fabmax/kool/math/Vec3f;", "setGravity", "(Lde/fabmax/kool/math/Vec3f;)V", "activeActors", "", "getActiveActors", "()I", "registerHandlers", "scene", "unregisterHandlers", "registerTriggerListener", "trigger", "listener", "Lde/fabmax/kool/physics/TriggerListener;", "unregisterTriggerListener", "registerContactListener", "unregisterContactListener", "fireOnTouchFound", "a", "b", "contactPoints", "Lde/fabmax/kool/physics/ContactPoint;", "fireOnTouchLost", "release", "addActor", "actor", "removeActor", "addArticulation", "articulation", "removeArticulation", "raycast", "ray", "Lde/fabmax/kool/math/RayF;", "maxDistance", "result", "Lde/fabmax/kool/physics/HitResult;", "sweepTest", "testGeometry", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "geometryPose", "Lde/fabmax/kool/math/Mat4f;", "testDirection", "distance", "wakeUpAll", "clear", "releaseActors", "isContinueStep", "physicsTimeDesired", "step", "singleStepSync", "timeStep", "singleStepAsync", "fetchAsyncStepResults", "addDefaultGroundPlane", "Lde/fabmax/kool/physics/RigidStatic;", "TriggerListenerContext", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nPhysicsWorld.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsWorld.kt\nde/fabmax/kool/physics/PhysicsWorld\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Log.kt\nde/fabmax/kool/util/LogKt\n+ 4 Log.kt\nde/fabmax/kool/util/Log\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1#2:210\n40#3,7:211\n18#4,4:218\n384#5,7:222\n1869#6,2:229\n1869#6,2:231\n1869#6,2:233\n*S KotlinDebug\n*F\n+ 1 PhysicsWorld.kt\nde/fabmax/kool/physics/PhysicsWorld\n*L\n62#1:211,7\n62#1:218,4\n64#1:222,7\n68#1:229,2\n121#1:231,2\n126#1:233,2\n*E\n"})
public abstract class PhysicsWorld
extends BaseReleasable {
    private double physicsTime;
    @NotNull
    private PhysicsStepper simStepper;
    private boolean isPauseSimulation;
    private boolean isStepInProgress;
    private float prevStepTime;
    @NotNull
    private final BufferedList<PhysicsStepListener> onAdvancePhysics;
    @NotNull
    private final BufferedList<PhysicsStepListener> onPhysicsUpdate;
    @NotNull
    private final List<RigidActor> mutActors;
    @NotNull
    private final List<Articulation> mutArticulations;
    @NotNull
    private final Map<RigidActor, TriggerListenerContext> triggerListeners;
    @NotNull
    private final List<ContactListener> contactListeners;
    @Nullable
    private Scene registeredAtScene;
    @NotNull
    private final Function1<KoolContext, Unit> onRenderSceneHook;

    public PhysicsWorld() {
        Physics.INSTANCE.checkIsLoaded();
        this.simStepper = new ConstantPhysicsStepperSync(0.0f, 1, null);
        this.onAdvancePhysics = new BufferedList();
        this.onPhysicsUpdate = new BufferedList();
        this.mutActors = new ArrayList();
        this.mutArticulations = new ArrayList();
        this.triggerListeners = new LinkedHashMap();
        this.contactListeners = new ArrayList();
        this.onRenderSceneHook = arg_0 -> PhysicsWorld.onRenderSceneHook$lambda$0(this, arg_0);
    }

    public final double getPhysicsTime() {
        return this.physicsTime;
    }

    public final void setPhysicsTime(double d) {
        this.physicsTime = d;
    }

    @NotNull
    public final PhysicsStepper getSimStepper() {
        return this.simStepper;
    }

    public final void setSimStepper(@NotNull PhysicsStepper physicsStepper) {
        Intrinsics.checkNotNullParameter((Object)physicsStepper, (String)"<set-?>");
        this.simStepper = physicsStepper;
    }

    public final boolean isPauseSimulation() {
        return this.isPauseSimulation;
    }

    public final void setPauseSimulation(boolean bl) {
        this.isPauseSimulation = bl;
    }

    public final boolean isStepInProgress() {
        return this.isStepInProgress;
    }

    public final void setStepInProgress(boolean bl) {
        this.isStepInProgress = bl;
    }

    public final float getPrevStepTime() {
        return this.prevStepTime;
    }

    public final void setPrevStepTime(float f) {
        this.prevStepTime = f;
    }

    @NotNull
    public final BufferedList<PhysicsStepListener> getOnAdvancePhysics() {
        return this.onAdvancePhysics;
    }

    @NotNull
    public final BufferedList<PhysicsStepListener> getOnPhysicsUpdate() {
        return this.onPhysicsUpdate;
    }

    @NotNull
    protected final List<RigidActor> getMutActors() {
        return this.mutActors;
    }

    @NotNull
    public final List<RigidActor> getActors() {
        return this.mutActors;
    }

    @NotNull
    protected final List<Articulation> getMutArticulations() {
        return this.mutArticulations;
    }

    @NotNull
    public final List<Articulation> getArticulations() {
        return this.mutArticulations;
    }

    @NotNull
    protected final Map<RigidActor, TriggerListenerContext> getTriggerListeners() {
        return this.triggerListeners;
    }

    @NotNull
    protected final List<ContactListener> getContactListeners() {
        return this.contactListeners;
    }

    @NotNull
    public abstract Vec3f getGravity();

    public abstract void setGravity(@NotNull Vec3f var1);

    public abstract int getActiveActors();

    public void registerHandlers(@NotNull Scene scene) {
        Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
        this.unregisterHandlers();
        this.registeredAtScene = scene;
        scene.getOnRenderScene().plusAssign(this.onRenderSceneHook);
    }

    public void unregisterHandlers() {
        block0: {
            Scene scene = this.registeredAtScene;
            if (scene == null) break block0;
            Scene it = scene;
            boolean bl = false;
            it.getOnRenderScene().minusAssign(this.onRenderSceneHook);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void registerTriggerListener(@NotNull RigidActor trigger, @NotNull TriggerListener listener) {
        TriggerListenerContext triggerListenerContext;
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!trigger.isTrigger()) {
            void this_$iv$iv$iv;
            PhysicsWorld $this$logW$iv = this;
            boolean $i$f$logW = false;
            String tag$iv$iv = Reflection.getOrCreateKotlinClass(((Object)((Object)$this$logW$iv)).getClass()).getSimpleName();
            boolean $i$f$logW2 = false;
            Log log = Log.INSTANCE;
            Log.Level level$iv$iv$iv = Log.Level.WARN;
            boolean $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                String string = tag$iv$iv;
                Log.Level level = level$iv$iv$iv;
                LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string2 = "Given trigger actor is not a trigger (isTrigger == false)";
                logPrinter.print(level, string, string2);
            }
        }
        Map<RigidActor, TriggerListenerContext> $this$getOrPut$iv = this.triggerListeners;
        boolean $i$f$getOrPut = false;
        TriggerListenerContext value$iv = $this$getOrPut$iv.get(trigger);
        if (value$iv == null) {
            boolean bl = false;
            TriggerListenerContext answer$iv = new TriggerListenerContext();
            $this$getOrPut$iv.put(trigger, answer$iv);
            triggerListenerContext = answer$iv;
        } else {
            triggerListenerContext = value$iv;
        }
        ((Collection)triggerListenerContext.getListeners()).add(listener);
    }

    public final void unregisterTriggerListener(@NotNull TriggerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Iterable $this$forEach$iv = this.triggerListeners.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TriggerListenerContext it = (TriggerListenerContext)element$iv;
            boolean bl = false;
            ((Collection)it.getListeners()).remove(listener);
        }
        CollectionsKt.removeAll((Iterable)this.triggerListeners.keySet(), arg_0 -> PhysicsWorld.unregisterTriggerListener$lambda$5(this, arg_0));
    }

    public final void registerContactListener(@NotNull ContactListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.contactListeners).add(listener);
    }

    public final void unregisterContactListener(@NotNull ContactListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.contactListeners).remove(listener);
    }

    protected final void fireOnTouchFound(@NotNull RigidActor a, @NotNull RigidActor b, @Nullable List<ContactPoint> contactPoints) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = ((Collection)this.contactListeners).size();
        for (int i = 0; i < n; ++i) {
            this.contactListeners.get(i).onTouchFound(a, b, contactPoints);
        }
    }

    protected final void fireOnTouchLost(@NotNull RigidActor a, @NotNull RigidActor b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = ((Collection)this.contactListeners).size();
        for (int i = 0; i < n; ++i) {
            this.contactListeners.get(i).onTouchLost(a, b);
        }
    }

    public void release() {
        if (this.isStepInProgress) {
            this.fetchAsyncStepResults();
        }
        this.unregisterHandlers();
        this.clear(true);
        super.release();
    }

    public void addActor(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        ((Collection)this.mutActors).add(actor);
    }

    public void removeActor(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        ((Collection)this.mutActors).remove(actor);
    }

    public void addArticulation(@NotNull Articulation articulation) {
        Intrinsics.checkNotNullParameter((Object)((Object)articulation), (String)"articulation");
        ((Collection)this.mutArticulations).add(articulation);
    }

    public void removeArticulation(@NotNull Articulation articulation) {
        Intrinsics.checkNotNullParameter((Object)((Object)articulation), (String)"articulation");
        ((Collection)this.mutArticulations).remove((Object)articulation);
    }

    public abstract boolean raycast(@NotNull RayF var1, float var2, @NotNull HitResult var3);

    public abstract boolean sweepTest(@NotNull CollisionGeometry var1, @NotNull Mat4f var2, @NotNull Vec3f var3, float var4, @NotNull HitResult var5);

    public final void wakeUpAll() {
        Object it;
        Iterable $this$forEach$iv = this.getActors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (RigidActor)element$iv;
            boolean bl = false;
            if (!(it instanceof RigidDynamic)) continue;
            ((RigidDynamic)it).wakeUp();
        }
        $this$forEach$iv = this.getArticulations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Articulation)((Object)element$iv);
            boolean bl = false;
            ((Articulation)((Object)it)).wakeUp();
        }
    }

    public final void clear(boolean releaseActors) {
        List list;
        List $this$clear_u24lambda_u248 = list = (List)new ArrayList();
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$clear_u24lambda_u248, (Iterable)this.getActors());
        List removeActors = list;
        for (int i = CollectionsKt.getLastIndex((List)removeActors); -1 < i; --i) {
            this.removeActor((RigidActor)removeActors.get(i));
            if (!releaseActors) continue;
            ((RigidActor)removeActors.get(i)).release();
        }
        List $this$clear_u24lambda_u249 = $this$clear_u24lambda_u248 = (List)new ArrayList();
        boolean bl2 = false;
        CollectionsKt.addAll((Collection)$this$clear_u24lambda_u249, (Iterable)this.getArticulations());
        List removeArticulations = $this$clear_u24lambda_u248;
        for (int i = CollectionsKt.getLastIndex((List)removeArticulations); -1 < i; --i) {
            this.removeArticulation((Articulation)((Object)removeArticulations.get(i)));
            if (!releaseActors) continue;
            ((Articulation)((Object)removeArticulations.get(i))).release();
        }
        this.triggerListeners.clear();
    }

    public static /* synthetic */ void clear$default(PhysicsWorld physicsWorld, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: clear");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        physicsWorld.clear(bl);
    }

    private final boolean isContinueStep(double physicsTime, double physicsTimeDesired, float step) {
        return physicsTimeDesired - physicsTime > (double)step * 0.5;
    }

    public final void singleStepSync(float timeStep) {
        this.singleStepAsync(timeStep);
        this.fetchAsyncStepResults();
    }

    public void singleStepAsync(float timeStep) {
        if (this.isStepInProgress) {
            throw new IllegalStateException("Previous simulation step not yet finished");
        }
        this.onAdvancePhysics(timeStep);
        this.isStepInProgress = true;
        this.prevStepTime = timeStep;
    }

    public void fetchAsyncStepResults() {
        this.isStepInProgress = false;
        this.onPhysicsUpdate(this.prevStepTime);
    }

    protected void onAdvancePhysics(float timeStep) {
        this.onAdvancePhysics.update();
        int n = ((Collection)this.onAdvancePhysics).size();
        for (int i = 0; i < n; ++i) {
            ((PhysicsStepListener)this.onAdvancePhysics.get(i)).onPhysicsStep(timeStep);
        }
    }

    protected void onPhysicsUpdate(float timeStep) {
        int i;
        int n = ((Collection)this.mutActors).size();
        for (i = 0; i < n; ++i) {
            this.mutActors.get(i).onPhysicsUpdate(timeStep);
        }
        n = ((Collection)this.mutArticulations).size();
        for (i = 0; i < n; ++i) {
            this.mutArticulations.get(i).onPhysicsUpdate(timeStep);
        }
        this.onPhysicsUpdate.update();
        n = ((Collection)this.onPhysicsUpdate).size();
        for (i = 0; i < n; ++i) {
            ((PhysicsStepListener)this.onPhysicsUpdate.get(i)).onPhysicsStep(timeStep);
        }
    }

    @NotNull
    public final RigidStatic addDefaultGroundPlane() {
        RigidStatic groundPlane = RigidStatic_desktopKt.RigidStatic$default(null, 1, null);
        Shape shape = new Shape(CollisionGeometry_desktopKt.PlaneGeometry(), Material_desktopKt.Material(0.5f, 0.5f, 0.2f), null, null, null, 28, null);
        groundPlane.attachShape(shape);
        groundPlane.setPose(new PoseF(null, QuatF.Companion.rotation-YB8I3VQ(AngleKt.getDeg((float)90.0f), Vec3f.Companion.getZ_AXIS()), 1, null));
        this.addActor(groundPlane);
        return groundPlane;
    }

    private static final Unit onRenderSceneHook$lambda$0(PhysicsWorld this$0, KoolContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!this$0.isPauseSimulation) {
            this$0.physicsTime += (double)this$0.simStepper.stepSimulation(this$0, ctx);
        }
        return Unit.INSTANCE;
    }

    private static final boolean unregisterTriggerListener$lambda$5(PhysicsWorld this$0, RigidActor k) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        Object object = this$0.triggerListeners.get(k);
        return object != null && (object = ((TriggerListenerContext)object).getListeners()) != null ? object.isEmpty() : false;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lde/fabmax/kool/physics/PhysicsWorld$TriggerListenerContext;", "", "<init>", "()V", "listeners", "", "Lde/fabmax/kool/physics/TriggerListener;", "getListeners", "()Ljava/util/List;", "actorEnterCounts", "", "Lde/fabmax/kool/physics/RigidActor;", "", "getActorEnterCounts", "()Ljava/util/Map;", "kool-physics"})
    protected static final class TriggerListenerContext {
        @NotNull
        private final List<TriggerListener> listeners = new ArrayList();
        @NotNull
        private final Map<RigidActor, Integer> actorEnterCounts = new LinkedHashMap();

        @NotNull
        public final List<TriggerListener> getListeners() {
            return this.listeners;
        }

        @NotNull
        public final Map<RigidActor, Integer> getActorEnterCounts() {
            return this.actorEnterCounts;
        }
    }
}

