/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.physics.PhysicsStepper;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.util.Time;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J \u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/fabmax/kool/physics/ConstantPhysicsStepperAsync;", "Lde/fabmax/kool/physics/PhysicsStepper;", "constantTimeStep", "", "<init>", "(F)V", "getConstantTimeStep", "()F", "isStepInProgress", "", "internalSimTime", "", "desiredSimTime", "maxSubSteps", "", "getMaxSubSteps", "()I", "setMaxSubSteps", "(I)V", "subStepLimit", "doSimSteps", "world", "Lde/fabmax/kool/physics/PhysicsWorld;", "ctx", "Lde/fabmax/kool/KoolContext;", "shouldAdvance", "currentTime", "desiredTime", "isFirst", "kool-physics"})
public final class ConstantPhysicsStepperAsync
extends PhysicsStepper {
    private final float constantTimeStep;
    private boolean isStepInProgress;
    private double internalSimTime;
    private double desiredSimTime;
    private int maxSubSteps;
    private int subStepLimit;

    public ConstantPhysicsStepperAsync(float constantTimeStep) {
        this.constantTimeStep = constantTimeStep;
        this.subStepLimit = this.maxSubSteps = 5;
    }

    public /* synthetic */ ConstantPhysicsStepperAsync(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.016666668f;
        }
        this(f);
    }

    public final float getConstantTimeStep() {
        return this.constantTimeStep;
    }

    public final int getMaxSubSteps() {
        return this.maxSubSteps;
    }

    public final void setMaxSubSteps(int n) {
        this.maxSubSteps = n;
    }

    @Override
    protected float doSimSteps(@NotNull PhysicsWorld world, @NotNull KoolContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)world), (String)"world");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        float timeAdvance = 0.0f;
        this.desiredSimTime += (double)Math.min(this.getMaxTimeStepPerFrame(), Time.INSTANCE.getDeltaT() * this.getSimTimeFactor());
        if (this.isStepInProgress) {
            world.fetchAsyncStepResults();
            this.isStepInProgress = false;
            this.internalSimTime += (double)this.constantTimeStep;
            timeAdvance += this.constantTimeStep;
        }
        int subSteps = this.subStepLimit;
        while (this.shouldAdvance(this.internalSimTime, this.desiredSimTime, false) && subSteps-- > 0) {
            world.singleStepSync(this.constantTimeStep);
            this.internalSimTime += (double)this.constantTimeStep;
            timeAdvance += this.constantTimeStep;
        }
        if (subSteps == 0 && this.subStepLimit > 1) {
            int n = this.subStepLimit;
            this.subStepLimit = n + -1;
        } else if (this.subStepLimit < this.maxSubSteps) {
            int n = this.subStepLimit;
            this.subStepLimit = n + 1;
        }
        if (this.shouldAdvance(this.internalSimTime, this.desiredSimTime + (double)this.constantTimeStep, true)) {
            world.singleStepAsync(this.constantTimeStep);
            this.isStepInProgress = true;
        }
        return timeAdvance;
    }

    private final boolean shouldAdvance(double currentTime, double desiredTime, boolean isFirst) {
        return isFirst ? currentTime + (double)this.constantTimeStep < desiredTime : currentTime + (double)(this.constantTimeStep * 1.5f) < desiredTime;
    }

    public ConstantPhysicsStepperAsync() {
        this(0.0f, 1, null);
    }
}

