/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.util;

import de.fabmax.kool.input.CursorMode;
import de.fabmax.kool.input.Pointer;
import de.fabmax.kool.input.PointerInput;
import de.fabmax.kool.math.AngleF;
import de.fabmax.kool.math.AngleKt;
import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MathKt;
import de.fabmax.kool.math.MutableMat4f;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.HitResult;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.geometry.BoxGeometry;
import de.fabmax.kool.physics.geometry.CollisionGeometry_desktopKt;
import de.fabmax.kool.pipeline.RenderPass;
import de.fabmax.kool.scene.MatrixTransformF;
import de.fabmax.kool.scene.Node;
import de.fabmax.kool.scene.Transform;
import de.fabmax.kool.scene.TrsTransformF;
import de.fabmax.kool.util.Time;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AJ\u0006\u0010B\u001a\u00020?J\b\u0010C\u001a\u00020?H\u0002J\u0010\u0010D\u001a\u00020?2\u0006\u0010E\u001a\u00020\u000bH\u0002R$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\b\"\u0004\b\u001a\u0010\u0005R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u001c\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010,\u001a\u0004\b*\u0010\r\"\u0004\b+\u0010\u000fR&\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u00106\u001a\u0002078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b8\u00109R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lde/fabmax/kool/physics/util/CharacterTrackingCamRig;", "Lde/fabmax/kool/scene/Node;", "enableCursorLock", "", "<init>", "(Z)V", "value", "isCursorLocked", "()Z", "setCursorLocked", "sensitivity", "", "getSensitivity", "()F", "setSensitivity", "(F)V", "zoom", "getZoom", "setZoom", "minZoom", "getMinZoom", "setMinZoom", "maxZoom", "getMaxZoom", "setMaxZoom", "isZoomEnabled", "setZoomEnabled", "actualZoom", "trackedPose", "Lde/fabmax/kool/scene/Transform;", "getTrackedPose", "()Lde/fabmax/kool/scene/Transform;", "setTrackedPose", "(Lde/fabmax/kool/scene/Transform;)V", "pivotPoint", "Lde/fabmax/kool/math/MutableVec3f;", "getPivotPoint", "()Lde/fabmax/kool/math/MutableVec3f;", "lookDirection", "getLookDirection", "frontAngle", "Lde/fabmax/kool/math/AngleF;", "getFrontAngle-H2B9tyM", "setFrontAngle-7PBAxM4", "F", "zoomModifier", "Lkotlin/Function1;", "getZoomModifier", "()Lkotlin/jvm/functions/Function1;", "setZoomModifier", "(Lkotlin/jvm/functions/Function1;)V", "poseOrigin", "lookPhi", "lookTheta", "hitSweepGeometry", "Lde/fabmax/kool/physics/geometry/BoxGeometry;", "getHitSweepGeometry", "()Lde/fabmax/kool/physics/geometry/BoxGeometry;", "hitSweepGeometry$delegate", "Lkotlin/Lazy;", "hitSweepGeometryPose", "Lde/fabmax/kool/math/MutableMat4f;", "setupCollisionAwareCamZoom", "", "world", "Lde/fabmax/kool/physics/PhysicsWorld;", "applyLookDirection", "handlePointerInput", "updateTracking", "deltaT", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nCharacterTrackingCamRig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterTrackingCamRig.kt\nde/fabmax/kool/physics/util/CharacterTrackingCamRig\n+ 2 Math.kt\nde/fabmax/kool/math/MathKt\n*L\n1#1,116:1\n43#2,5:117\n43#2,5:122\n26#2:127\n26#2:128\n*S KotlinDebug\n*F\n+ 1 CharacterTrackingCamRig.kt\nde/fabmax/kool/physics/util/CharacterTrackingCamRig\n*L\n92#1:117,5\n100#1:122,5\n109#1:127\n111#1:128\n*E\n"})
public final class CharacterTrackingCamRig
extends Node {
    private float sensitivity;
    private float zoom;
    private float minZoom;
    private float maxZoom;
    private boolean isZoomEnabled;
    private float actualZoom;
    @NotNull
    private Transform trackedPose;
    @NotNull
    private final MutableVec3f pivotPoint;
    @NotNull
    private final MutableVec3f lookDirection;
    private float frontAngle;
    @NotNull
    private Function1<? super Float, Float> zoomModifier;
    @NotNull
    private final MutableVec3f poseOrigin;
    private float lookPhi;
    private float lookTheta;
    @NotNull
    private final Lazy hitSweepGeometry$delegate;
    @NotNull
    private final MutableMat4f hitSweepGeometryPose;

    public CharacterTrackingCamRig(boolean enableCursorLock) {
        super("PointerLockCamRig");
        this.sensitivity = 1.0f;
        this.zoom = 4.0f;
        this.minZoom = 0.5f;
        this.maxZoom = 25.0f;
        this.isZoomEnabled = true;
        this.actualZoom = this.zoom;
        this.trackedPose = (Transform)new TrsTransformF();
        this.pivotPoint = new MutableVec3f();
        this.lookDirection = new MutableVec3f(Vec3f.Companion.getNEG_Z_AXIS());
        this.frontAngle = AngleKt.getDeg((float)0.0f);
        this.zoomModifier = CharacterTrackingCamRig::zoomModifier$lambda$0;
        this.poseOrigin = new MutableVec3f();
        this.lookTheta = 1.5707964f;
        this.hitSweepGeometry$delegate = LazyKt.lazy(CharacterTrackingCamRig::hitSweepGeometry_delegate$lambda$1);
        this.hitSweepGeometryPose = new MutableMat4f();
        this.setCursorLocked(enableCursorLock);
        this.setTransform((Transform)new MatrixTransformF());
        this.onUpdate(arg_0 -> CharacterTrackingCamRig._init_$lambda$2(this, arg_0));
    }

    public /* synthetic */ CharacterTrackingCamRig(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean isCursorLocked() {
        return PointerInput.INSTANCE.getCursorMode() == CursorMode.LOCKED;
    }

    public final void setCursorLocked(boolean value) {
        if (value) {
            PointerInput.INSTANCE.setCursorMode(CursorMode.LOCKED);
        } else {
            PointerInput.INSTANCE.setCursorMode(CursorMode.NORMAL);
        }
    }

    public final float getSensitivity() {
        return this.sensitivity;
    }

    public final void setSensitivity(float f) {
        this.sensitivity = f;
    }

    public final float getZoom() {
        return this.zoom;
    }

    public final void setZoom(float f) {
        this.zoom = f;
    }

    public final float getMinZoom() {
        return this.minZoom;
    }

    public final void setMinZoom(float f) {
        this.minZoom = f;
    }

    public final float getMaxZoom() {
        return this.maxZoom;
    }

    public final void setMaxZoom(float f) {
        this.maxZoom = f;
    }

    public final boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public final void setZoomEnabled(boolean bl) {
        this.isZoomEnabled = bl;
    }

    @NotNull
    public final Transform getTrackedPose() {
        return this.trackedPose;
    }

    public final void setTrackedPose(@NotNull Transform transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"<set-?>");
        this.trackedPose = transform;
    }

    @NotNull
    public final MutableVec3f getPivotPoint() {
        return this.pivotPoint;
    }

    @NotNull
    public final MutableVec3f getLookDirection() {
        return this.lookDirection;
    }

    public final float getFrontAngle-H2B9tyM() {
        return this.frontAngle;
    }

    public final void setFrontAngle-7PBAxM4(float f) {
        this.frontAngle = f;
    }

    @NotNull
    public final Function1<Float, Float> getZoomModifier() {
        return this.zoomModifier;
    }

    public final void setZoomModifier(@NotNull Function1<? super Float, Float> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.zoomModifier = function1;
    }

    private final BoxGeometry getHitSweepGeometry() {
        Lazy lazy = this.hitSweepGeometry$delegate;
        return (BoxGeometry)lazy.getValue();
    }

    public final void setupCollisionAwareCamZoom(@NotNull PhysicsWorld world) {
        Intrinsics.checkNotNullParameter((Object)((Object)world), (String)"world");
        MutableVec3f testDir = new MutableVec3f();
        HitResult hitResult = new HitResult();
        this.zoomModifier = arg_0 -> CharacterTrackingCamRig.setupCollisionAwareCamZoom$lambda$3(this, testDir, world, hitResult, arg_0);
    }

    public final void applyLookDirection() {
        this.lookPhi = (float)Math.atan2(this.lookDirection.getZ(), this.lookDirection.getX());
        this.lookTheta = (float)Math.acos(this.lookDirection.getY());
        this.frontAngle = AngleF.plus-jnMgTEE((float)AngleKt.getRad((float)this.lookPhi), (float)AngleKt.getDeg((float)90.0f));
    }

    private final void handlePointerInput() {
        float min$iv;
        float $this$clamp$iv;
        this.applyLookDirection();
        float div = 1000.0f / this.sensitivity;
        Pointer ptr = PointerInput.INSTANCE.getPrimaryPointer();
        this.lookPhi -= (float)ptr.getDeltaX() / div;
        float f = this.lookTheta - (float)ptr.getDeltaY() / div;
        float f2 = 1.0E-4f;
        float max$iv = 3.1414928f;
        boolean $i$f$clamp = false;
        this.lookTheta = $this$clamp$iv < min$iv ? min$iv : ($this$clamp$iv > max$iv ? max$iv : $this$clamp$iv);
        this.lookDirection.setX((float)Math.sin(this.lookTheta) * (float)Math.cos(this.lookPhi));
        this.lookDirection.setZ((float)Math.sin(this.lookTheta) * (float)Math.sin(this.lookPhi));
        this.lookDirection.setY((float)Math.cos(this.lookTheta));
        if (this.isZoomEnabled && !ptr.isConsumed(64)) {
            this.zoom *= 1.0f - (float)PointerInput.INSTANCE.getPrimaryPointer().getDeltaScroll() / 10.0f;
            $this$clamp$iv = this.zoom;
            min$iv = this.minZoom;
            max$iv = this.maxZoom;
            $i$f$clamp = false;
            this.zoom = $this$clamp$iv < min$iv ? min$iv : ($this$clamp$iv > max$iv ? max$iv : $this$clamp$iv);
        }
    }

    private final void updateTracking(float deltaT) {
        Transform.DefaultImpls.transform$default((Transform)this.trackedPose, (MutableVec3f)this.poseOrigin.set(Vec3f.Companion.getZERO()), (float)0.0f, (int)2, null);
        this.getTransform().setIdentity();
        this.getTransform().translate((Vec3f)this.poseOrigin);
        float $this$toDeg$iv = this.lookPhi;
        boolean $i$f$toDeg = false;
        this.getTransform().rotate-YB8I3VQ(AngleKt.getDeg((float)($this$toDeg$iv * 57.29578f + 90.0f)), Vec3f.Companion.getY_AXIS());
        this.getTransform().translate((Vec3f)this.pivotPoint);
        $this$toDeg$iv = this.lookTheta;
        $i$f$toDeg = false;
        this.getTransform().rotate-YB8I3VQ(AngleKt.getDeg((float)($this$toDeg$iv * 57.29578f - 90.0f)), Vec3f.Companion.getX_AXIS());
        this.actualZoom = MathKt.expDecay((float)this.actualZoom, (float)((Number)this.zoomModifier.invoke((Object)Float.valueOf(this.zoom))).floatValue(), (float)16.0f, (float)deltaT);
        this.getTransform().scale(this.actualZoom);
    }

    private static final float zoomModifier$lambda$0(float it) {
        return it;
    }

    private static final BoxGeometry hitSweepGeometry_delegate$lambda$1() {
        return CollisionGeometry_desktopKt.BoxGeometry(new Vec3f(1.0f, 1.0f, 0.1f));
    }

    private static final Unit _init_$lambda$2(CharacterTrackingCamRig this$0, RenderPass.UpdateEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.isCursorLocked()) {
            this$0.handlePointerInput();
        }
        this$0.updateTracking(Time.INSTANCE.getDeltaT());
        return Unit.INSTANCE;
    }

    private static final float setupCollisionAwareCamZoom$lambda$3(CharacterTrackingCamRig this$0, MutableVec3f $testDir, PhysicsWorld $world, HitResult $hitResult, float desiredZoom) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$testDir, (String)"$testDir");
        Intrinsics.checkNotNullParameter((Object)((Object)$world), (String)"$world");
        Intrinsics.checkNotNullParameter((Object)$hitResult, (String)"$hitResult");
        float zoom = desiredZoom;
        this$0.getTransform().transform($testDir.set(0.0f, 0.0f, 1.0f).norm(), 0.0f);
        this$0.hitSweepGeometryPose.set(this$0.getTransform().getMatrixF()).translate((Vec3f)this$0.pivotPoint).translate(0.0f, 0.0f, 1.0f);
        if ($world.sweepTest(this$0.getHitSweepGeometry(), (Mat4f)this$0.hitSweepGeometryPose, (Vec3f)$testDir, desiredZoom, $hitResult)) {
            zoom = Math.max(this$0.minZoom, $hitResult.getHitDistance() - 1.0f);
        }
        return zoom;
    }

    public CharacterTrackingCamRig() {
        this(false, 1, null);
    }
}

