/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsImpl;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.joints.JointImpl;
import de.fabmax.kool.physics.joints.RevoluteJoint;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxTransform;
import physx.extensions.PxRevoluteJoint;
import physx.extensions.PxRevoluteJointFlagEnum;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB9\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\u0010J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lde/fabmax/kool/physics/joints/RevoluteJointImpl;", "Lde/fabmax/kool/physics/joints/JointImpl;", "Lde/fabmax/kool/physics/joints/RevoluteJoint;", "bodyA", "Lde/fabmax/kool/physics/RigidActor;", "bodyB", "frameA", "Lde/fabmax/kool/math/Mat4f;", "frameB", "<init>", "(Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/math/Mat4f;Lde/fabmax/kool/math/Mat4f;)V", "pivotA", "Lde/fabmax/kool/math/Vec3f;", "pivotB", "axisA", "axisB", "(Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/math/Vec3f;Lde/fabmax/kool/math/Vec3f;Lde/fabmax/kool/math/Vec3f;Lde/fabmax/kool/math/Vec3f;)V", "getBodyA", "()Lde/fabmax/kool/physics/RigidActor;", "getBodyB", "joint", "Lphysx/extensions/PxRevoluteJoint;", "getJoint", "()Lphysx/extensions/PxRevoluteJoint;", "disableAngularMotor", "", "enableAngularMotor", "angularVelocity", "", "forceLimit", "kool-physics"})
public final class RevoluteJointImpl
extends JointImpl
implements RevoluteJoint {
    @NotNull
    private final RigidActor bodyA;
    @NotNull
    private final RigidActor bodyB;
    @NotNull
    private final PxRevoluteJoint joint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevoluteJointImpl(@NotNull RigidActor bodyA, @NotNull RigidActor bodyB, @NotNull Mat4f frameA, @NotNull Mat4f frameB) {
        Intrinsics.checkNotNullParameter((Object)bodyA, (String)"bodyA");
        Intrinsics.checkNotNullParameter((Object)bodyB, (String)"bodyB");
        Intrinsics.checkNotNullParameter((Object)frameA, (String)"frameA");
        Intrinsics.checkNotNullParameter((Object)frameB, (String)"frameB");
        super(frameA, frameB);
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            PxTransform frmA = PhysXExtensionsKt.toPxTransform(frameA, pxTransform);
            PxTransform pxTransform2 = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform2, (String)"createPxTransform(...)");
            PxTransform frmB = PhysXExtensionsKt.toPxTransform(frameB, pxTransform2);
            this.joint = PxTopLevelFunctions.RevoluteJointCreate((PxPhysics)PhysicsImpl.INSTANCE.getPhysics(), (PxRigidActor)this.getBodyA().getHolder(), (PxTransform)frmA, (PxRigidActor)this.getBodyB().getHolder(), (PxTransform)frmB);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public RigidActor getBodyA() {
        return this.bodyA;
    }

    @Override
    @NotNull
    public RigidActor getBodyB() {
        return this.bodyB;
    }

    public RevoluteJointImpl(@NotNull RigidActor bodyA, @NotNull RigidActor bodyB, @NotNull Vec3f pivotA, @NotNull Vec3f pivotB, @NotNull Vec3f axisA, @NotNull Vec3f axisB) {
        Intrinsics.checkNotNullParameter((Object)bodyA, (String)"bodyA");
        Intrinsics.checkNotNullParameter((Object)bodyB, (String)"bodyB");
        Intrinsics.checkNotNullParameter((Object)pivotA, (String)"pivotA");
        Intrinsics.checkNotNullParameter((Object)pivotB, (String)"pivotB");
        Intrinsics.checkNotNullParameter((Object)axisA, (String)"axisA");
        Intrinsics.checkNotNullParameter((Object)axisB, (String)"axisB");
        this(bodyA, bodyB, RevoluteJoint.Companion.computeFrame(pivotA, axisA), RevoluteJoint.Companion.computeFrame(pivotB, axisB));
    }

    @NotNull
    public PxRevoluteJoint getJoint() {
        return this.joint;
    }

    @Override
    public void disableAngularMotor() {
        this.getJoint().setDriveVelocity(0.0f);
        this.getJoint().setDriveForceLimit(0.0f);
        this.getJoint().setRevoluteJointFlag(PxRevoluteJointFlagEnum.eDRIVE_ENABLED, false);
    }

    @Override
    public void enableAngularMotor(float angularVelocity, float forceLimit) {
        this.getJoint().setDriveVelocity(angularVelocity);
        this.getJoint().setDriveForceLimit(forceLimit);
        this.getJoint().setRevoluteJointFlag(PxRevoluteJointFlagEnum.eDRIVE_ENABLED, true);
    }
}

