/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.physics.joints.Joint;
import de.fabmax.kool.util.BaseReleasable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import physx.physics.PxConstraintFlagEnum;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR$\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lde/fabmax/kool/physics/joints/JointImpl;", "Lde/fabmax/kool/util/BaseReleasable;", "Lde/fabmax/kool/physics/joints/Joint;", "frameA", "Lde/fabmax/kool/math/Mat4f;", "frameB", "<init>", "(Lde/fabmax/kool/math/Mat4f;Lde/fabmax/kool/math/Mat4f;)V", "getFrameA", "()Lde/fabmax/kool/math/Mat4f;", "getFrameB", "isBroken", "", "()Z", "value", "debugVisualize", "getDebugVisualize", "setDebugVisualize", "(Z)V", "setBreakForce", "", "force", "", "torque", "release", "kool-physics"})
public abstract class JointImpl
extends BaseReleasable
implements Joint {
    @NotNull
    private final Mat4f frameA;
    @NotNull
    private final Mat4f frameB;
    private boolean debugVisualize;

    public JointImpl(@NotNull Mat4f frameA, @NotNull Mat4f frameB) {
        Intrinsics.checkNotNullParameter((Object)frameA, (String)"frameA");
        Intrinsics.checkNotNullParameter((Object)frameB, (String)"frameB");
        this.frameA = new Mat4f(frameA);
        this.frameB = new Mat4f(frameB);
    }

    @Override
    @NotNull
    public Mat4f getFrameA() {
        return this.frameA;
    }

    @Override
    @NotNull
    public Mat4f getFrameB() {
        return this.frameB;
    }

    @Override
    public boolean isBroken() {
        return this.getJoint().getConstraintFlags().isSet(PxConstraintFlagEnum.eBROKEN);
    }

    @Override
    public boolean getDebugVisualize() {
        return this.debugVisualize;
    }

    @Override
    public void setDebugVisualize(boolean value) {
        if (value) {
            this.getJoint().getConstraintFlags().raise(PxConstraintFlagEnum.eVISUALIZATION);
        } else {
            this.getJoint().getConstraintFlags().clear(PxConstraintFlagEnum.eVISUALIZATION);
        }
    }

    @Override
    public void setBreakForce(float force, float torque) {
        this.getJoint().setBreakForce(force, torque);
    }

    public void release() {
        super.release();
        this.getJoint().release();
    }
}

