/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsImpl;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.joints.DistanceJoint;
import de.fabmax.kool.physics.joints.JointImpl;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxTransform;
import physx.extensions.PxDistanceJoint;
import physx.extensions.PxDistanceJointFlagEnum;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lde/fabmax/kool/physics/joints/DistanceJointImpl;", "Lde/fabmax/kool/physics/joints/JointImpl;", "Lde/fabmax/kool/physics/joints/DistanceJoint;", "bodyA", "Lde/fabmax/kool/physics/RigidActor;", "bodyB", "frameA", "Lde/fabmax/kool/math/Mat4f;", "frameB", "<init>", "(Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/math/Mat4f;Lde/fabmax/kool/math/Mat4f;)V", "getBodyA", "()Lde/fabmax/kool/physics/RigidActor;", "getBodyB", "joint", "Lphysx/extensions/PxDistanceJoint;", "getJoint", "()Lphysx/extensions/PxDistanceJoint;", "setMaxDistance", "", "maxDistance", "", "setMinDistance", "minDistance", "removeMaxDistance", "removeMinDistance", "kool-physics"})
public final class DistanceJointImpl
extends JointImpl
implements DistanceJoint {
    @NotNull
    private final RigidActor bodyA;
    @NotNull
    private final RigidActor bodyB;
    @NotNull
    private final PxDistanceJoint joint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistanceJointImpl(@NotNull RigidActor bodyA, @NotNull RigidActor bodyB, @NotNull Mat4f frameA, @NotNull Mat4f frameB) {
        Intrinsics.checkNotNullParameter((Object)bodyA, (String)"bodyA");
        Intrinsics.checkNotNullParameter((Object)bodyB, (String)"bodyB");
        Intrinsics.checkNotNullParameter((Object)frameA, (String)"frameA");
        Intrinsics.checkNotNullParameter((Object)frameB, (String)"frameB");
        super(frameA, frameB);
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            PxTransform frmA = PhysXExtensionsKt.toPxTransform(frameA, pxTransform);
            PxTransform pxTransform2 = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform2, (String)"createPxTransform(...)");
            PxTransform frmB = PhysXExtensionsKt.toPxTransform(frameB, pxTransform2);
            this.joint = PxTopLevelFunctions.DistanceJointCreate((PxPhysics)PhysicsImpl.INSTANCE.getPhysics(), (PxRigidActor)this.getBodyA().getHolder(), (PxTransform)frmA, (PxRigidActor)this.getBodyB().getHolder(), (PxTransform)frmB);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public RigidActor getBodyA() {
        return this.bodyA;
    }

    @Override
    @NotNull
    public RigidActor getBodyB() {
        return this.bodyB;
    }

    @NotNull
    public PxDistanceJoint getJoint() {
        return this.joint;
    }

    @Override
    public void setMaxDistance(float maxDistance) {
        this.getJoint().setMaxDistance(maxDistance);
        this.getJoint().setDistanceJointFlag(PxDistanceJointFlagEnum.eMAX_DISTANCE_ENABLED, true);
    }

    @Override
    public void setMinDistance(float minDistance) {
        this.getJoint().setMinDistance(minDistance);
        this.getJoint().setDistanceJointFlag(PxDistanceJointFlagEnum.eMIN_DISTANCE_ENABLED, true);
    }

    @Override
    public void removeMaxDistance() {
        this.getJoint().setDistanceJointFlag(PxDistanceJointFlagEnum.eMAX_DISTANCE_ENABLED, false);
    }

    @Override
    public void removeMinDistance() {
        this.getJoint().setDistanceJointFlag(PxDistanceJointFlagEnum.eMIN_DISTANCE_ENABLED, false);
    }
}

