/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsImpl;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.joints.D6Joint;
import de.fabmax.kool.physics.joints.D6JointMotion;
import de.fabmax.kool.physics.joints.JointImpl;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxTransform;
import physx.extensions.PxD6AxisEnum;
import physx.extensions.PxD6Joint;
import physx.extensions.PxD6MotionEnum;
import physx.extensions.PxJointLinearLimit;
import physx.extensions.PxJointLinearLimitPair;
import physx.extensions.PxSpring;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0016J(\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0016J(\u0010(\u001a\u00020 2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0016J(\u0010)\u001a\u00020 2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R$\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018\u00a8\u0006+"}, d2={"Lde/fabmax/kool/physics/joints/D6JointImpl;", "Lde/fabmax/kool/physics/joints/JointImpl;", "Lde/fabmax/kool/physics/joints/D6Joint;", "bodyA", "Lde/fabmax/kool/physics/RigidActor;", "bodyB", "frameA", "Lde/fabmax/kool/math/Mat4f;", "frameB", "<init>", "(Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/math/Mat4f;Lde/fabmax/kool/math/Mat4f;)V", "getBodyA", "()Lde/fabmax/kool/physics/RigidActor;", "getBodyB", "joint", "Lphysx/extensions/PxD6Joint;", "getJoint", "()Lphysx/extensions/PxD6Joint;", "value", "Lde/fabmax/kool/physics/joints/D6JointMotion;", "motionX", "getMotionX", "()Lde/fabmax/kool/physics/joints/D6JointMotion;", "setMotionX", "(Lde/fabmax/kool/physics/joints/D6JointMotion;)V", "motionY", "getMotionY", "setMotionY", "motionZ", "getMotionZ", "setMotionZ", "setDistanceLimit", "", "extend", "", "stiffness", "damping", "setXLinearLimit", "lowerLimit", "upperLimit", "setYLinearLimit", "setZLinearLimit", "Companion", "kool-physics"})
public final class D6JointImpl
extends JointImpl
implements D6Joint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RigidActor bodyA;
    @NotNull
    private final RigidActor bodyB;
    @NotNull
    private final PxD6Joint joint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D6JointImpl(@NotNull RigidActor bodyA, @NotNull RigidActor bodyB, @NotNull Mat4f frameA, @NotNull Mat4f frameB) {
        Intrinsics.checkNotNullParameter((Object)bodyA, (String)"bodyA");
        Intrinsics.checkNotNullParameter((Object)bodyB, (String)"bodyB");
        Intrinsics.checkNotNullParameter((Object)frameA, (String)"frameA");
        Intrinsics.checkNotNullParameter((Object)frameB, (String)"frameB");
        super(frameA, frameB);
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            PxTransform frmA = PhysXExtensionsKt.toPxTransform(frameA, pxTransform);
            PxTransform pxTransform2 = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform2, (String)"createPxTransform(...)");
            PxTransform frmB = PhysXExtensionsKt.toPxTransform(frameB, pxTransform2);
            this.joint = PxTopLevelFunctions.D6JointCreate((PxPhysics)PhysicsImpl.INSTANCE.getPhysics(), (PxRigidActor)this.getBodyA().getHolder(), (PxTransform)frmA, (PxRigidActor)this.getBodyB().getHolder(), (PxTransform)frmB);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public RigidActor getBodyA() {
        return this.bodyA;
    }

    @Override
    @NotNull
    public RigidActor getBodyB() {
        return this.bodyB;
    }

    @NotNull
    public PxD6Joint getJoint() {
        return this.joint;
    }

    @Override
    @NotNull
    public D6JointMotion getMotionX() {
        PxD6MotionEnum pxD6MotionEnum = this.getJoint().getMotion(PxD6AxisEnum.eX);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"getMotion(...)");
        return D6JointImpl.Companion.toD6JointMotion(pxD6MotionEnum);
    }

    @Override
    public void setMotionX(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getJoint().setMotion(PxD6AxisEnum.eX, D6JointImpl.Companion.toPxD6MotionEnum(value));
    }

    @Override
    @NotNull
    public D6JointMotion getMotionY() {
        PxD6MotionEnum pxD6MotionEnum = this.getJoint().getMotion(PxD6AxisEnum.eY);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"getMotion(...)");
        return D6JointImpl.Companion.toD6JointMotion(pxD6MotionEnum);
    }

    @Override
    public void setMotionY(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getJoint().setMotion(PxD6AxisEnum.eY, D6JointImpl.Companion.toPxD6MotionEnum(value));
    }

    @Override
    @NotNull
    public D6JointMotion getMotionZ() {
        PxD6MotionEnum pxD6MotionEnum = this.getJoint().getMotion(PxD6AxisEnum.eZ);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"getMotion(...)");
        return D6JointImpl.Companion.toD6JointMotion(pxD6MotionEnum);
    }

    @Override
    public void setMotionZ(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getJoint().setMotion(PxD6AxisEnum.eZ, D6JointImpl.Companion.toPxD6MotionEnum(value));
    }

    @Override
    public void setDistanceLimit(float extend, float stiffness, float damping) {
        this.getJoint().setDistanceLimit(new PxJointLinearLimit(extend, new PxSpring(stiffness, damping)));
    }

    @Override
    public void setXLinearLimit(float lowerLimit, float upperLimit, float stiffness, float damping) {
        this.getJoint().setLinearLimit(PxD6AxisEnum.eX, new PxJointLinearLimitPair(lowerLimit, upperLimit, new PxSpring(stiffness, damping)));
        this.setMotionX(D6JointMotion.Limited);
    }

    @Override
    public void setYLinearLimit(float lowerLimit, float upperLimit, float stiffness, float damping) {
        this.getJoint().setLinearLimit(PxD6AxisEnum.eY, new PxJointLinearLimitPair(lowerLimit, upperLimit, new PxSpring(stiffness, damping)));
        this.setMotionY(D6JointMotion.Limited);
    }

    @Override
    public void setZLinearLimit(float lowerLimit, float upperLimit, float stiffness, float damping) {
        this.getJoint().setLinearLimit(PxD6AxisEnum.eZ, new PxJointLinearLimitPair(lowerLimit, upperLimit, new PxSpring(stiffness, damping)));
        this.setMotionZ(D6JointMotion.Limited);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u0007\u001a\u00020\u0006*\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lde/fabmax/kool/physics/joints/D6JointImpl$Companion;", "", "<init>", "()V", "toD6JointMotion", "Lde/fabmax/kool/physics/joints/D6JointMotion;", "Lphysx/extensions/PxD6MotionEnum;", "toPxD6MotionEnum", "kool-physics"})
    public static final class Companion {
        private Companion() {
        }

        private final D6JointMotion toD6JointMotion(PxD6MotionEnum $this$toD6JointMotion) {
            D6JointMotion d6JointMotion;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toD6JointMotion.ordinal()]) {
                case 1: {
                    d6JointMotion = D6JointMotion.Free;
                    break;
                }
                case 2: {
                    d6JointMotion = D6JointMotion.Limited;
                    break;
                }
                case 3: {
                    d6JointMotion = D6JointMotion.Locked;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return d6JointMotion;
        }

        private final PxD6MotionEnum toPxD6MotionEnum(D6JointMotion $this$toPxD6MotionEnum) {
            PxD6MotionEnum pxD6MotionEnum;
            switch (WhenMappings.$EnumSwitchMapping$1[$this$toPxD6MotionEnum.ordinal()]) {
                case 1: {
                    pxD6MotionEnum = PxD6MotionEnum.eFREE;
                    break;
                }
                case 2: {
                    pxD6MotionEnum = PxD6MotionEnum.eLIMITED;
                    break;
                }
                case 3: {
                    pxD6MotionEnum = PxD6MotionEnum.eLOCKED;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pxD6MotionEnum;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[PxD6MotionEnum.values().length];
                try {
                    nArray[PxD6MotionEnum.eFREE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PxD6MotionEnum.eLIMITED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PxD6MotionEnum.eLOCKED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[D6JointMotion.values().length];
                try {
                    nArray[D6JointMotion.Free.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[D6JointMotion.Limited.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[D6JointMotion.Locked.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

