/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsImpl;
import de.fabmax.kool.physics.geometry.HeightField;
import de.fabmax.kool.util.Heightmap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.NativeObject;
import physx.PxTopLevelFunctions;
import physx.geometry.PxHeightField;
import physx.geometry.PxHeightFieldDesc;
import physx.geometry.PxHeightFieldFormatEnum;
import physx.geometry.PxHeightFieldSample;
import physx.support.PxArray_PxHeightFieldSample;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Lde/fabmax/kool/physics/geometry/HeightFieldImpl;", "Lde/fabmax/kool/physics/geometry/HeightField;", "heightMap", "Lde/fabmax/kool/util/Heightmap;", "rowScale", "", "columnScale", "<init>", "(Lde/fabmax/kool/util/Heightmap;FF)V", "getHeightMap", "()Lde/fabmax/kool/util/Heightmap;", "getRowScale", "()F", "getColumnScale", "pxHeightField", "Lphysx/geometry/PxHeightField;", "getPxHeightField", "()Lphysx/geometry/PxHeightField;", "heightScale", "getHeightScale", "releaseWithGeometry", "", "getReleaseWithGeometry", "()Z", "setReleaseWithGeometry", "(Z)V", "refCnt", "", "getRefCnt$kool_physics", "()I", "setRefCnt$kool_physics", "(I)V", "release", "", "kool-physics"})
public final class HeightFieldImpl
extends HeightField {
    @NotNull
    private final Heightmap heightMap;
    private final float rowScale;
    private final float columnScale;
    @NotNull
    private final PxHeightField pxHeightField;
    private final float heightScale;
    private boolean releaseWithGeometry;
    private int refCnt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeightFieldImpl(@NotNull Heightmap heightMap, float rowScale, float columnScale) {
        Intrinsics.checkNotNullParameter((Object)heightMap, (String)"heightMap");
        this.heightMap = heightMap;
        this.rowScale = rowScale;
        this.columnScale = columnScale;
        this.releaseWithGeometry = true;
        float maxAbsHeight = Math.max(-this.getHeightMap().getMinHeight(), this.getHeightMap().getMaxHeight());
        this.heightScale = maxAbsHeight / 32767.0f;
        float revHeightToI16 = this.getHeightScale() > 0.0f ? 1.0f / this.getHeightScale() : 0.0f;
        PhysicsImpl.INSTANCE.checkIsLoaded();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            int rows = this.getHeightMap().getColumns();
            int cols = this.getHeightMap().getRows();
            Intrinsics.checkNotNull((Object)mem);
            PxHeightFieldSample sample = PhysXExtensionsKt.createPxHeightFieldSample(mem);
            PxArray_PxHeightFieldSample samples = new PxArray_PxHeightFieldSample();
            int row = 0;
            if (row <= rows) {
                while (true) {
                    for (int col = cols - 1; -1 < col; --col) {
                        sample.setHeight((short)MathKt.roundToInt((float)(this.getHeightMap().getHeight(row, col) * revHeightToI16)));
                        if (row % 2 != col % 2) {
                            sample.clearTessFlag();
                        } else {
                            sample.setTessFlag();
                        }
                        samples.pushBack(sample);
                    }
                    if (row == rows) break;
                    ++row;
                }
            }
            PxHeightFieldDesc desc = PhysXExtensionsKt.createPxHeightFieldDesc(mem);
            desc.setFormat(PxHeightFieldFormatEnum.eS16_TM);
            desc.setNbRows(rows);
            desc.setNbColumns(cols);
            desc.getSamples().setData((NativeObject)samples.begin());
            desc.getSamples().setStride(PxHeightFieldSample.SIZEOF);
            this.pxHeightField = PxTopLevelFunctions.CreateHeightField((PxHeightFieldDesc)desc);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public Heightmap getHeightMap() {
        return this.heightMap;
    }

    @Override
    public float getRowScale() {
        return this.rowScale;
    }

    @Override
    public float getColumnScale() {
        return this.columnScale;
    }

    @NotNull
    public final PxHeightField getPxHeightField() {
        return this.pxHeightField;
    }

    @Override
    public float getHeightScale() {
        return this.heightScale;
    }

    @Override
    public boolean getReleaseWithGeometry() {
        return this.releaseWithGeometry;
    }

    @Override
    public void setReleaseWithGeometry(boolean bl) {
        this.releaseWithGeometry = bl;
    }

    public final int getRefCnt$kool_physics() {
        return this.refCnt;
    }

    public final void setRefCnt$kool_physics(int n) {
        this.refCnt = n;
    }

    public void release() {
        super.release();
        this.pxHeightField.release();
    }
}

