/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.math.AngleF;
import de.fabmax.kool.math.AngleKt;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec2f;
import de.fabmax.kool.math.spatial.BoundingBoxF;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.scene.geometry.MeshBuilder;
import de.fabmax.kool.scene.geometry.Profile;
import de.fabmax.kool.scene.geometry.ShapeContainer;
import de.fabmax.kool.scene.geometry.SimpleShape;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0010H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lde/fabmax/kool/physics/geometry/CapsuleGeometry;", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "height", "", "getHeight", "()F", "radius", "getRadius", "generateMesh", "", "target", "Lde/fabmax/kool/scene/geometry/MeshBuilder;", "getBounds", "Lde/fabmax/kool/math/spatial/BoundingBoxF;", "result", "estimateInertiaForMass", "Lde/fabmax/kool/math/MutableVec3f;", "mass", "kool-physics"})
public interface CapsuleGeometry
extends CollisionGeometry {
    public float getHeight();

    public float getRadius();

    @Override
    public void generateMesh(@NotNull MeshBuilder var1);

    @Override
    @NotNull
    public BoundingBoxF getBounds(@NotNull BoundingBoxF var1);

    @Override
    @NotNull
    public MutableVec3f estimateInertiaForMass(float var1, @NotNull MutableVec3f var2);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nCapsuleGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapsuleGeometry.kt\nde/fabmax/kool/physics/geometry/CapsuleGeometry$DefaultImpls\n+ 2 MeshBuilder.kt\nde/fabmax/kool/scene/geometry/MeshBuilder\n+ 3 Profile.kt\nde/fabmax/kool/scene/geometry/ProfileKt\n*L\n1#1,44:1\n132#2,2:45\n134#2:51\n19#3,4:47\n*S KotlinDebug\n*F\n+ 1 CapsuleGeometry.kt\nde/fabmax/kool/physics/geometry/CapsuleGeometry$DefaultImpls\n*L\n18#1:45,2\n18#1:51\n20#1:47,4\n*E\n"})
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        public static void generateMesh(@NotNull CapsuleGeometry $this, @NotNull MeshBuilder target) {
            void $this$simpleShape$iv;
            Profile profile$iv;
            MeshBuilder meshBuilder;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            MeshBuilder $this$generateMesh_u24lambda_u242 = meshBuilder = target;
            boolean bl = false;
            MeshBuilder this_$iv = $this$generateMesh_u24lambda_u242;
            boolean $i$f$profile = false;
            Profile $this$generateMesh_u24lambda_u242_u24lambda_u241 = profile$iv = new Profile();
            boolean bl2 = false;
            float halfHeight = $this.getHeight() / 2.0f;
            ShapeContainer shapeContainer = (ShapeContainer)$this$generateMesh_u24lambda_u242_u24lambda_u241;
            boolean isClosed$iv = false;
            boolean $i$f$simpleShape = false;
            SimpleShape shape$iv = new SimpleShape(isClosed$iv);
            ((Collection)$this$simpleShape$iv.getShapes()).add(shape$iv);
            SimpleShape $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240 = shape$iv;
            boolean bl3 = false;
            $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.xyArc-I-4Qy0Y(new Vec2f(halfHeight + $this.getRadius(), 0.0f), new Vec2f(halfHeight, 0.0f), AngleKt.getDeg((float)90.0f), 10, true);
            $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.xyArc-I-4Qy0Y(new Vec2f(-halfHeight, $this.getRadius()), new Vec2f(-halfHeight, 0.0f), AngleKt.getDeg((float)90.0f), 10, true);
            for (int i = 0; i < 21; ++i) {
                MeshBuilder.sample$default((MeshBuilder)$this$generateMesh_u24lambda_u242, (Profile)$this$generateMesh_u24lambda_u242_u24lambda_u241, (boolean)false, (boolean)false, (int)3, null);
                $this$generateMesh_u24lambda_u242.rotate-tS0NhXc(AngleF.div-CpbldAs((float)AngleKt.getDeg((float)360.0f), (int)20), AngleKt.getDeg((float)0.0f), AngleKt.getDeg((float)0.0f));
            }
        }

        @NotNull
        public static BoundingBoxF getBounds(@NotNull CapsuleGeometry $this, @NotNull BoundingBoxF result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return result.set(-$this.getRadius() - $this.getHeight() / 2.0f, -$this.getRadius(), -$this.getRadius(), $this.getRadius() + $this.getHeight() / 2.0f, $this.getRadius(), $this.getRadius());
        }

        @NotNull
        public static MutableVec3f estimateInertiaForMass(@NotNull CapsuleGeometry $this, float mass, @NotNull MutableVec3f result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            float h = $this.getHeight() - $this.getRadius();
            float iy = 0.5f * mass * $this.getRadius() * $this.getRadius();
            float ixz = 0.083333336f * mass * ((float)3 * $this.getRadius() * $this.getRadius() + h * h);
            return result.set(ixz, iy, ixz);
        }
    }
}

