/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.articulations;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.articulations.ArticulationDriveType;
import de.fabmax.kool.physics.articulations.ArticulationJoint;
import de.fabmax.kool.physics.articulations.ArticulationJointAxis;
import de.fabmax.kool.physics.articulations.ArticulationJointType;
import de.fabmax.kool.physics.articulations.ArticulationMotionMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.common.PxTransform;
import physx.physics.PxArticulationAxisEnum;
import physx.physics.PxArticulationDrive;
import physx.physics.PxArticulationDriveTypeEnum;
import physx.physics.PxArticulationJointReducedCoordinate;
import physx.physics.PxArticulationJointTypeEnum;
import physx.physics.PxArticulationLimit;
import physx.physics.PxArticulationMotionEnum;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J(\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0016J8\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0016J0\u0010)\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001bH\u0016J\u0018\u0010/\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u001bH\u0016J\u0018\u00101\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00064"}, d2={"Lde/fabmax/kool/physics/articulations/ArticulationJointImpl;", "Lde/fabmax/kool/physics/articulations/ArticulationJoint;", "pxJoint", "Lphysx/physics/PxArticulationJointReducedCoordinate;", "<init>", "(Lphysx/physics/PxArticulationJointReducedCoordinate;)V", "getPxJoint", "()Lphysx/physics/PxArticulationJointReducedCoordinate;", "value", "Lde/fabmax/kool/physics/articulations/ArticulationJointType;", "jointType", "getJointType", "()Lde/fabmax/kool/physics/articulations/ArticulationJointType;", "setJointType", "(Lde/fabmax/kool/physics/articulations/ArticulationJointType;)V", "setParentPose", "", "pose", "Lde/fabmax/kool/math/Mat4f;", "setChildPose", "setAxisMotion", "axis", "Lde/fabmax/kool/physics/articulations/ArticulationJointAxis;", "motionType", "Lde/fabmax/kool/physics/articulations/ArticulationMotionMode;", "setAxisLimits", "low", "", "high", "setupSphericalSymmetrical", "twistLimitDeg", "swingLimitDeg", "setupSpherical", "twistMinDeg", "twistMaxDeg", "swingMinDeg", "swingMaxDeg", "swing1MinDeg", "swing1MaxDeg", "swing2MinDeg", "swing2MaxDeg", "setDriveParams", "driveType", "Lde/fabmax/kool/physics/articulations/ArticulationDriveType;", "damping", "stiffness", "maxForce", "setDriveTarget", "target", "setJointPosition", "jointPos", "Companion", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nArticulationJoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticulationJoint.kt\nde/fabmax/kool/physics/articulations/ArticulationJointImpl\n+ 2 Math.kt\nde/fabmax/kool/math/MathKt\n*L\n1#1,153:1\n27#2:154\n27#2:155\n27#2:156\n27#2:157\n27#2:158\n*S KotlinDebug\n*F\n+ 1 ArticulationJoint.kt\nde/fabmax/kool/physics/articulations/ArticulationJointImpl\n*L\n50#1:154\n62#1:155\n83#1:156\n87#1:157\n88#1:158\n*E\n"})
public final class ArticulationJointImpl
implements ArticulationJoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PxArticulationJointReducedCoordinate pxJoint;

    public ArticulationJointImpl(@NotNull PxArticulationJointReducedCoordinate pxJoint) {
        Intrinsics.checkNotNullParameter((Object)pxJoint, (String)"pxJoint");
        this.pxJoint = pxJoint;
        this.pxJoint.setJointType(PxArticulationJointTypeEnum.eFIX);
    }

    @NotNull
    public final PxArticulationJointReducedCoordinate getPxJoint() {
        return this.pxJoint;
    }

    @Override
    @NotNull
    public ArticulationJointType getJointType() {
        PxArticulationJointTypeEnum pxArticulationJointTypeEnum = this.pxJoint.getJointType();
        Intrinsics.checkNotNullExpressionValue((Object)pxArticulationJointTypeEnum, (String)"getJointType(...)");
        return ArticulationJointImpl.Companion.toArticulationJointType(pxArticulationJointTypeEnum);
    }

    @Override
    public void setJointType(@NotNull ArticulationJointType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.pxJoint.setJointType(ArticulationJointImpl.Companion.getPxVal(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParentPose(@NotNull Mat4f pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            this.pxJoint.setParentPose(PhysXExtensionsKt.toPxTransform(pose, pxTransform));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChildPose(@NotNull Mat4f pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            this.pxJoint.setChildPose(PhysXExtensionsKt.toPxTransform(pose, pxTransform));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void setAxisMotion(@NotNull ArticulationJointAxis axis, @NotNull ArticulationMotionMode motionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        Intrinsics.checkNotNullParameter((Object)((Object)motionType), (String)"motionType");
        this.pxJoint.setMotion(ArticulationJointImpl.Companion.getPxVal(axis), ArticulationJointImpl.Companion.getPxVal(motionType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAxisLimits(@NotNull ArticulationJointAxis axis, float low, float high) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxArticulationLimit limit = PhysXExtensionsKt.createPxArticulationLimit(mem, low, high);
            this.pxJoint.setLimitParams(ArticulationJointImpl.Companion.getPxVal(axis), limit);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void setupSphericalSymmetrical(float twistLimitDeg, float swingLimitDeg) {
        float limit;
        boolean $i$f$toRad;
        float $this$toRad$iv;
        this.setJointType(ArticulationJointType.SPHERICAL);
        if (twistLimitDeg > 0.0f) {
            if (twistLimitDeg < 360.0f) {
                this.setAxisMotion(ArticulationJointAxis.ROT_TWIST, ArticulationMotionMode.LIMITED);
                $this$toRad$iv = twistLimitDeg;
                $i$f$toRad = false;
                limit = $this$toRad$iv * ((float)Math.PI / 180);
                this.setAxisLimits(ArticulationJointAxis.ROT_TWIST, -limit, limit);
            } else {
                this.setAxisMotion(ArticulationJointAxis.ROT_TWIST, ArticulationMotionMode.FREE);
            }
        } else {
            this.setAxisMotion(ArticulationJointAxis.ROT_TWIST, ArticulationMotionMode.LOCKED);
        }
        if (swingLimitDeg > 0.0f) {
            if (swingLimitDeg < 360.0f) {
                this.setAxisMotion(ArticulationJointAxis.ROT_SWING1, ArticulationMotionMode.LIMITED);
                this.setAxisMotion(ArticulationJointAxis.ROT_SWING2, ArticulationMotionMode.LIMITED);
                $this$toRad$iv = swingLimitDeg;
                $i$f$toRad = false;
                limit = $this$toRad$iv * ((float)Math.PI / 180);
                this.setAxisLimits(ArticulationJointAxis.ROT_SWING1, -limit, limit);
                this.setAxisLimits(ArticulationJointAxis.ROT_SWING2, -limit, limit);
            } else {
                this.setAxisMotion(ArticulationJointAxis.ROT_SWING1, ArticulationMotionMode.FREE);
                this.setAxisMotion(ArticulationJointAxis.ROT_SWING2, ArticulationMotionMode.FREE);
            }
        }
    }

    @Override
    public void setupSpherical(float twistMinDeg, float twistMaxDeg, float swingMinDeg, float swingMaxDeg) {
        this.setupSpherical(twistMinDeg, twistMaxDeg, swingMinDeg, swingMaxDeg, swingMinDeg, swingMaxDeg);
    }

    @Override
    public void setupSpherical(float twistMinDeg, float twistMaxDeg, float swing1MinDeg, float swing1MaxDeg, float swing2MinDeg, float swing2MaxDeg) {
        this.setJointType(ArticulationJointType.SPHERICAL);
        this.setAxisMotion(ArticulationJointAxis.ROT_TWIST, ArticulationMotionMode.LIMITED);
        float $this$toRad$iv = twistMinDeg;
        boolean $i$f$toRad = false;
        float f = $this$toRad$iv * ((float)Math.PI / 180);
        $this$toRad$iv = twistMaxDeg;
        $i$f$toRad = false;
        this.setAxisLimits(ArticulationJointAxis.ROT_TWIST, f, $this$toRad$iv * ((float)Math.PI / 180));
        this.setAxisMotion(ArticulationJointAxis.ROT_SWING1, ArticulationMotionMode.LIMITED);
        this.setAxisMotion(ArticulationJointAxis.ROT_SWING2, ArticulationMotionMode.LIMITED);
        $this$toRad$iv = swing1MinDeg;
        $i$f$toRad = false;
        float f2 = $this$toRad$iv * ((float)Math.PI / 180);
        $this$toRad$iv = swing1MaxDeg;
        $i$f$toRad = false;
        this.setAxisLimits(ArticulationJointAxis.ROT_SWING1, f2, $this$toRad$iv * ((float)Math.PI / 180));
        $this$toRad$iv = swing2MinDeg;
        $i$f$toRad = false;
        float f3 = $this$toRad$iv * ((float)Math.PI / 180);
        $this$toRad$iv = swing2MaxDeg;
        $i$f$toRad = false;
        this.setAxisLimits(ArticulationJointAxis.ROT_SWING2, f3, $this$toRad$iv * ((float)Math.PI / 180));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDriveParams(@NotNull ArticulationJointAxis axis, @NotNull ArticulationDriveType driveType, float damping, float stiffness, float maxForce) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        Intrinsics.checkNotNullParameter((Object)((Object)driveType), (String)"driveType");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxArticulationDrive drive = PhysXExtensionsKt.createPxArticulationDrive(mem);
            drive.setDriveType(ArticulationJointImpl.Companion.getPxVal(driveType));
            drive.setStiffness(stiffness);
            drive.setDamping(damping);
            drive.setMaxForce(maxForce);
            this.pxJoint.setDriveParams(ArticulationJointImpl.Companion.getPxVal(axis), drive);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void setDriveTarget(@NotNull ArticulationJointAxis axis, float target) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        this.pxJoint.setDriveTarget(ArticulationJointImpl.Companion.getPxVal(axis), target);
    }

    @Override
    public void setJointPosition(@NotNull ArticulationJointAxis axis, float jointPos) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        this.pxJoint.setJointPosition(ArticulationJointImpl.Companion.getPxVal(axis), jointPos);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002R\u0018\u0010\u0007\u001a\u00020\u0006*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0007\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\fR\u0018\u0010\u0007\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000fR\u0018\u0010\u0007\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lde/fabmax/kool/physics/articulations/ArticulationJointImpl$Companion;", "", "<init>", "()V", "toArticulationJointType", "Lde/fabmax/kool/physics/articulations/ArticulationJointType;", "Lphysx/physics/PxArticulationJointTypeEnum;", "pxVal", "getPxVal", "(Lde/fabmax/kool/physics/articulations/ArticulationJointType;)Lphysx/physics/PxArticulationJointTypeEnum;", "Lphysx/physics/PxArticulationAxisEnum;", "Lde/fabmax/kool/physics/articulations/ArticulationJointAxis;", "(Lde/fabmax/kool/physics/articulations/ArticulationJointAxis;)Lphysx/physics/PxArticulationAxisEnum;", "Lphysx/physics/PxArticulationMotionEnum;", "Lde/fabmax/kool/physics/articulations/ArticulationMotionMode;", "(Lde/fabmax/kool/physics/articulations/ArticulationMotionMode;)Lphysx/physics/PxArticulationMotionEnum;", "Lphysx/physics/PxArticulationDriveTypeEnum;", "Lde/fabmax/kool/physics/articulations/ArticulationDriveType;", "(Lde/fabmax/kool/physics/articulations/ArticulationDriveType;)Lphysx/physics/PxArticulationDriveTypeEnum;", "kool-physics"})
    public static final class Companion {
        private Companion() {
        }

        private final ArticulationJointType toArticulationJointType(PxArticulationJointTypeEnum $this$toArticulationJointType) {
            ArticulationJointType articulationJointType;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toArticulationJointType.ordinal()]) {
                case 1: {
                    articulationJointType = ArticulationJointType.FIX;
                    break;
                }
                case 2: {
                    articulationJointType = ArticulationJointType.PRISMATIC;
                    break;
                }
                case 3: {
                    articulationJointType = ArticulationJointType.REVOLUTE;
                    break;
                }
                case 4: {
                    articulationJointType = ArticulationJointType.SPHERICAL;
                    break;
                }
                case 5: {
                    throw new IllegalStateException("Invalid joint type: " + $this$toArticulationJointType);
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return articulationJointType;
        }

        private final PxArticulationJointTypeEnum getPxVal(ArticulationJointType $this$pxVal) {
            PxArticulationJointTypeEnum pxArticulationJointTypeEnum;
            switch (WhenMappings.$EnumSwitchMapping$1[$this$pxVal.ordinal()]) {
                case 1: {
                    pxArticulationJointTypeEnum = PxArticulationJointTypeEnum.eFIX;
                    break;
                }
                case 2: {
                    pxArticulationJointTypeEnum = PxArticulationJointTypeEnum.ePRISMATIC;
                    break;
                }
                case 3: {
                    pxArticulationJointTypeEnum = PxArticulationJointTypeEnum.eREVOLUTE;
                    break;
                }
                case 4: {
                    pxArticulationJointTypeEnum = PxArticulationJointTypeEnum.eSPHERICAL;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pxArticulationJointTypeEnum;
        }

        private final PxArticulationAxisEnum getPxVal(ArticulationJointAxis $this$pxVal) {
            PxArticulationAxisEnum pxArticulationAxisEnum;
            switch (WhenMappings.$EnumSwitchMapping$2[$this$pxVal.ordinal()]) {
                case 1: {
                    pxArticulationAxisEnum = PxArticulationAxisEnum.eTWIST;
                    break;
                }
                case 2: {
                    pxArticulationAxisEnum = PxArticulationAxisEnum.eSWING1;
                    break;
                }
                case 3: {
                    pxArticulationAxisEnum = PxArticulationAxisEnum.eSWING2;
                    break;
                }
                case 4: {
                    pxArticulationAxisEnum = PxArticulationAxisEnum.eX;
                    break;
                }
                case 5: {
                    pxArticulationAxisEnum = PxArticulationAxisEnum.eY;
                    break;
                }
                case 6: {
                    pxArticulationAxisEnum = PxArticulationAxisEnum.eZ;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pxArticulationAxisEnum;
        }

        private final PxArticulationMotionEnum getPxVal(ArticulationMotionMode $this$pxVal) {
            PxArticulationMotionEnum pxArticulationMotionEnum;
            switch (WhenMappings.$EnumSwitchMapping$3[$this$pxVal.ordinal()]) {
                case 1: {
                    pxArticulationMotionEnum = PxArticulationMotionEnum.eFREE;
                    break;
                }
                case 2: {
                    pxArticulationMotionEnum = PxArticulationMotionEnum.eLIMITED;
                    break;
                }
                case 3: {
                    pxArticulationMotionEnum = PxArticulationMotionEnum.eLOCKED;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pxArticulationMotionEnum;
        }

        private final PxArticulationDriveTypeEnum getPxVal(ArticulationDriveType $this$pxVal) {
            PxArticulationDriveTypeEnum pxArticulationDriveTypeEnum;
            switch (WhenMappings.$EnumSwitchMapping$4[$this$pxVal.ordinal()]) {
                case 1: {
                    pxArticulationDriveTypeEnum = PxArticulationDriveTypeEnum.eACCELERATION;
                    break;
                }
                case 2: {
                    pxArticulationDriveTypeEnum = PxArticulationDriveTypeEnum.eFORCE;
                    break;
                }
                case 3: {
                    pxArticulationDriveTypeEnum = PxArticulationDriveTypeEnum.eNONE;
                    break;
                }
                case 4: {
                    pxArticulationDriveTypeEnum = PxArticulationDriveTypeEnum.eTARGET;
                    break;
                }
                case 5: {
                    pxArticulationDriveTypeEnum = PxArticulationDriveTypeEnum.eVELOCITY;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pxArticulationDriveTypeEnum;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;
            public static final /* synthetic */ int[] $EnumSwitchMapping$4;

            static {
                int[] nArray = new int[PxArticulationJointTypeEnum.values().length];
                try {
                    nArray[PxArticulationJointTypeEnum.eFIX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PxArticulationJointTypeEnum.ePRISMATIC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PxArticulationJointTypeEnum.eREVOLUTE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PxArticulationJointTypeEnum.eSPHERICAL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PxArticulationJointTypeEnum.eUNDEFINED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[ArticulationJointType.values().length];
                try {
                    nArray[ArticulationJointType.FIX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationJointType.PRISMATIC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationJointType.REVOLUTE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationJointType.SPHERICAL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[ArticulationJointAxis.values().length];
                try {
                    nArray[ArticulationJointAxis.ROT_TWIST.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationJointAxis.ROT_SWING1.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationJointAxis.ROT_SWING2.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationJointAxis.LINEAR_X.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationJointAxis.LINEAR_Y.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationJointAxis.LINEAR_Z.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[ArticulationMotionMode.values().length];
                try {
                    nArray[ArticulationMotionMode.FREE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationMotionMode.LIMITED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationMotionMode.LOCKED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$3 = nArray;
                nArray = new int[ArticulationDriveType.values().length];
                try {
                    nArray[ArticulationDriveType.ACCELERATION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationDriveType.FORCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationDriveType.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationDriveType.TARGET.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArticulationDriveType.VELOCITY.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$4 = nArray;
            }
        }
    }
}

