/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.physics.PhysicsStepper;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.util.Time;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lde/fabmax/kool/physics/SimplePhysicsStepper;", "Lde/fabmax/kool/physics/PhysicsStepper;", "<init>", "()V", "maxSingleStepTime", "", "getMaxSingleStepTime", "()F", "setMaxSingleStepTime", "(F)V", "doSimSteps", "world", "Lde/fabmax/kool/physics/PhysicsWorld;", "ctx", "Lde/fabmax/kool/KoolContext;", "kool-physics"})
public final class SimplePhysicsStepper
extends PhysicsStepper {
    private float maxSingleStepTime = 0.02f;

    public final float getMaxSingleStepTime() {
        return this.maxSingleStepTime;
    }

    public final void setMaxSingleStepTime(float f) {
        this.maxSingleStepTime = f;
    }

    @Override
    protected float doSimSteps(@NotNull PhysicsWorld world, @NotNull KoolContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)world), (String)"world");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        float remainingStepTime = Math.min(this.getMaxTimeStepPerFrame(), Time.INSTANCE.getDeltaT() * this.getSimTimeFactor());
        float timeAdvance = 0.0f;
        while (remainingStepTime > 0.001f) {
            float singleStep = Math.min(remainingStepTime, this.maxSingleStepTime);
            world.singleStepSync(singleStep);
            remainingStepTime -= singleStep;
            timeAdvance += singleStep;
        }
        return timeAdvance;
    }
}

