/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.QuatF;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsImpl;
import de.fabmax.kool.physics.RigidBodyImpl;
import de.fabmax.kool.physics.RigidDynamic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidDynamic;
import physx.physics.PxRigidDynamicLockFlagEnum;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0016J \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lde/fabmax/kool/physics/RigidDynamicImpl;", "Lde/fabmax/kool/physics/RigidBodyImpl;", "Lde/fabmax/kool/physics/RigidDynamic;", "mass", "", "pose", "Lde/fabmax/kool/math/Mat4f;", "isKinematic", "", "pxActor", "Lphysx/physics/PxRigidDynamic;", "<init>", "(FLde/fabmax/kool/math/Mat4f;ZLphysx/physics/PxRigidDynamic;)V", "(FLde/fabmax/kool/math/Mat4f;Z)V", "()Z", "holder", "getHolder", "()Lphysx/physics/PxRigidDynamic;", "wakeUp", "", "putToSleep", "setKinematicTarget", "position", "Lde/fabmax/kool/math/Vec3f;", "rotation", "Lde/fabmax/kool/math/QuatF;", "setLinearLockFlags", "lockLinearX", "lockLinearY", "lockLinearZ", "setAngularLockFlags", "lockAngularX", "lockAngularY", "lockAngularZ", "kool-physics"})
public final class RigidDynamicImpl
extends RigidBodyImpl
implements RigidDynamic {
    private final boolean isKinematic;
    @NotNull
    private final PxRigidDynamic holder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RigidDynamicImpl(float mass, @NotNull Mat4f pose, boolean isKinematic, @Nullable PxRigidDynamic pxActor) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        this.isKinematic = isKinematic;
        if (pxActor == null) {
            AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                MemoryStack mem = (MemoryStack)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)mem);
                PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
                Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
                PxTransform pxPose = PhysXExtensionsKt.toPxTransform(pose, pxTransform);
                this.holder = PhysicsImpl.INSTANCE.getPhysics().createRigidDynamic(pxPose);
                this.setMass(mass);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        } else {
            this.holder = pxActor;
        }
        if (this.isKinematic()) {
            this.getHolder().setRigidBodyFlag(PxRigidBodyFlagEnum.eKINEMATIC, true);
        }
        this.getTransform().setMatrix(pose);
    }

    @Override
    public boolean isKinematic() {
        return this.isKinematic;
    }

    public RigidDynamicImpl(float mass, @NotNull Mat4f pose, boolean isKinematic) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        this(mass, pose, isKinematic, null);
    }

    @NotNull
    public PxRigidDynamic getHolder() {
        return this.holder;
    }

    @Override
    public void wakeUp() {
        this.getHolder().wakeUp();
    }

    @Override
    public void putToSleep() {
        this.getHolder().putToSleep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKinematicTarget(@NotNull Mat4f pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            PxTransform pxPose = PhysXExtensionsKt.toPxTransform(pose, pxTransform);
            this.getHolder().setKinematicTarget(pxPose);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKinematicTarget(@Nullable Vec3f position, @Nullable QuatF rotation) {
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            QuatF quatF;
            PxTransform pxPose;
            block13: {
                block12: {
                    Vec3f vec3f;
                    MemoryStack mem;
                    block11: {
                        block10: {
                            mem = (MemoryStack)autoCloseable;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)mem);
                            pxPose = PhysXExtensionsKt.createPxTransform(mem);
                            vec3f = position;
                            if (vec3f == null) break block10;
                            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
                            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"createPxVec3(...)");
                            if ((vec3f = PhysXExtensionsKt.toPxVec3(vec3f, pxVec3)) != null) break block11;
                        }
                        vec3f = this.getHolder().getGlobalPose().getP();
                    }
                    pxPose.setP((PxVec3)vec3f);
                    quatF = rotation;
                    if (quatF == null) break block12;
                    PxQuat pxQuat = PhysXExtensionsKt.createPxQuat(mem);
                    Intrinsics.checkNotNullExpressionValue((Object)pxQuat, (String)"createPxQuat(...)");
                    if ((quatF = PhysXExtensionsKt.toPxQuat(quatF, pxQuat)) != null) break block13;
                }
                quatF = this.getHolder().getGlobalPose().getQ();
            }
            pxPose.setQ((PxQuat)quatF);
            this.getHolder().setKinematicTarget(pxPose);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void setLinearLockFlags(boolean lockLinearX, boolean lockLinearY, boolean lockLinearZ) {
        this.getHolder().setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum.eLOCK_LINEAR_X, lockLinearX);
        this.getHolder().setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum.eLOCK_LINEAR_Y, lockLinearY);
        this.getHolder().setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum.eLOCK_LINEAR_Z, lockLinearZ);
    }

    @Override
    public void setAngularLockFlags(boolean lockAngularX, boolean lockAngularY, boolean lockAngularZ) {
        this.getHolder().setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum.eLOCK_ANGULAR_X, lockAngularX);
        this.getHolder().setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum.eLOCK_ANGULAR_Y, lockAngularY);
        this.getHolder().setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum.eLOCK_ANGULAR_Z, lockAngularZ);
    }
}

