/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.RigidActorImpl;
import de.fabmax.kool.physics.RigidBody;
import de.fabmax.kool.physics.Shape;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.common.PxVec3;
import physx.extensions.PxRigidBodyExt;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000202H\u0016J\b\u00106\u001a\u000202H\u0016J(\u00107\u001a\u0002022\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u0011H\u0016J(\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u0011H\u0016J\u0018\u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R$\u0010\u001b\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R$\u0010\u001e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\r\"\u0004\b \u0010\u000fR$\u0010!\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\r\"\u0004\b#\u0010\u000fR$\u0010$\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\r\"\u0004\b&\u0010\u000fR$\u0010'\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010\r\"\u0004\b)\u0010\u000fR\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lde/fabmax/kool/physics/RigidBodyImpl;", "Lde/fabmax/kool/physics/RigidActorImpl;", "Lde/fabmax/kool/physics/RigidBody;", "<init>", "()V", "pxRigidBody", "Lphysx/physics/PxRigidBody;", "getPxRigidBody", "()Lphysx/physics/PxRigidBody;", "value", "", "mass", "getMass", "()F", "setMass", "(F)V", "isInertiaSet", "", "Lde/fabmax/kool/math/Vec3f;", "inertia", "getInertia", "()Lde/fabmax/kool/math/Vec3f;", "setInertia", "(Lde/fabmax/kool/math/Vec3f;)V", "linearVelocity", "getLinearVelocity", "setLinearVelocity", "angularVelocity", "getAngularVelocity", "setAngularVelocity", "maxLinearVelocity", "getMaxLinearVelocity", "setMaxLinearVelocity", "maxAngularVelocity", "getMaxAngularVelocity", "setMaxAngularVelocity", "linearDamping", "getLinearDamping", "setLinearDamping", "angularDamping", "getAngularDamping", "setAngularDamping", "bufInertia", "Lde/fabmax/kool/math/MutableVec3f;", "bufLinVelocity", "bufAngVelocity", "tmpVec", "pxTmpVec", "Lphysx/common/PxVec3;", "attachShape", "", "shape", "Lde/fabmax/kool/physics/Shape;", "release", "updateInertiaFromShapesAndMass", "addForceAtPos", "force", "pos", "isLocalForce", "isLocalPos", "addImpulseAtPos", "impulse", "isLocalImpulse", "addTorque", "torque", "isLocalTorque", "kool-physics"})
public abstract class RigidBodyImpl
extends RigidActorImpl
implements RigidBody {
    private boolean isInertiaSet;
    @NotNull
    private final MutableVec3f bufInertia = new MutableVec3f();
    @NotNull
    private final MutableVec3f bufLinVelocity = new MutableVec3f();
    @NotNull
    private final MutableVec3f bufAngVelocity = new MutableVec3f();
    @NotNull
    private final MutableVec3f tmpVec = new MutableVec3f();
    @NotNull
    private final PxVec3 pxTmpVec = new PxVec3();

    private final PxRigidBody getPxRigidBody() {
        PxRigidActor pxRigidActor = this.getHolder();
        Intrinsics.checkNotNull((Object)pxRigidActor, (String)"null cannot be cast to non-null type physx.physics.PxRigidBody");
        return (PxRigidBody)pxRigidActor;
    }

    @Override
    public float getMass() {
        return this.getPxRigidBody().getMass();
    }

    @Override
    public void setMass(float value) {
        this.getPxRigidBody().setMass(value);
    }

    @Override
    @NotNull
    public Vec3f getInertia() {
        PxVec3 pxVec3 = this.getPxRigidBody().getMassSpaceInertiaTensor();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"getMassSpaceInertiaTensor(...)");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufInertia);
    }

    @Override
    public void setInertia(@NotNull Vec3f value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getPxRigidBody().setMassSpaceInertiaTensor(PhysXExtensionsKt.toPxVec3(value, this.pxTmpVec));
        this.isInertiaSet = true;
    }

    @Override
    @NotNull
    public Vec3f getLinearVelocity() {
        PxVec3 pxVec3 = this.getPxRigidBody().getLinearVelocity();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"getLinearVelocity(...)");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufLinVelocity);
    }

    @Override
    public void setLinearVelocity(@NotNull Vec3f value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            PxRigidBody pxRigidBody = this.getPxRigidBody();
            PxRigidDynamic pxRigidDynamic = pxRigidBody instanceof PxRigidDynamic ? (PxRigidDynamic)pxRigidBody : null;
            if (pxRigidDynamic == null) break block0;
            PxRigidDynamic it = pxRigidDynamic;
            boolean bl = false;
            it.setLinearVelocity(PhysXExtensionsKt.toPxVec3(value, this.pxTmpVec));
        }
    }

    @Override
    @NotNull
    public Vec3f getAngularVelocity() {
        PxVec3 pxVec3 = this.getPxRigidBody().getAngularVelocity();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"getAngularVelocity(...)");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufAngVelocity);
    }

    @Override
    public void setAngularVelocity(@NotNull Vec3f value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            PxRigidBody pxRigidBody = this.getPxRigidBody();
            PxRigidDynamic pxRigidDynamic = pxRigidBody instanceof PxRigidDynamic ? (PxRigidDynamic)pxRigidBody : null;
            if (pxRigidDynamic == null) break block0;
            PxRigidDynamic it = pxRigidDynamic;
            boolean bl = false;
            it.setAngularVelocity(PhysXExtensionsKt.toPxVec3(value, this.pxTmpVec));
        }
    }

    @Override
    public float getMaxLinearVelocity() {
        return this.getPxRigidBody().getMaxLinearVelocity();
    }

    @Override
    public void setMaxLinearVelocity(float value) {
        this.getPxRigidBody().setMaxLinearVelocity(value);
    }

    @Override
    public float getMaxAngularVelocity() {
        return this.getPxRigidBody().getMaxAngularVelocity();
    }

    @Override
    public void setMaxAngularVelocity(float value) {
        this.getPxRigidBody().setMaxAngularVelocity(value);
    }

    @Override
    public float getLinearDamping() {
        return this.getPxRigidBody().getLinearDamping();
    }

    @Override
    public void setLinearDamping(float value) {
        this.getPxRigidBody().setLinearDamping(value);
    }

    @Override
    public float getAngularDamping() {
        return this.getPxRigidBody().getAngularDamping();
    }

    @Override
    public void setAngularDamping(float value) {
        this.getPxRigidBody().setAngularDamping(value);
    }

    @Override
    public void attachShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        super.attachShape(shape);
        if (!this.isInertiaSet) {
            this.setInertia((Vec3f)CollisionGeometry.DefaultImpls.estimateInertiaForMass$default(shape.getGeometry(), this.getMass(), null, 2, null));
        }
    }

    @Override
    public void release() {
        super.release();
        this.pxTmpVec.destroy();
    }

    @Override
    public void updateInertiaFromShapesAndMass() {
        PxRigidBodyExt.setMassAndUpdateInertia((PxRigidBody)this.getPxRigidBody(), (float)this.getMass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addForceAtPos(@NotNull Vec3f force, @NotNull Vec3f pos, boolean isLocalForce, boolean isLocalPos) {
        Intrinsics.checkNotNullParameter((Object)force, (String)"force");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"createPxVec3(...)");
            PxVec3 pxForce = PhysXExtensionsKt.toPxVec3(force, pxVec3);
            PxVec3 pxVec32 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"createPxVec3(...)");
            PxVec3 pxPos = PhysXExtensionsKt.toPxVec3(pos, pxVec32);
            if (isLocalForce && isLocalPos) {
                PxRigidBodyExt.addLocalForceAtLocalPos((PxRigidBody)this.getPxRigidBody(), (PxVec3)pxForce, (PxVec3)pxPos);
            } else if (isLocalForce && !isLocalPos) {
                PxRigidBodyExt.addLocalForceAtPos((PxRigidBody)this.getPxRigidBody(), (PxVec3)pxForce, (PxVec3)pxPos);
            } else if (!isLocalForce && isLocalPos) {
                PxRigidBodyExt.addForceAtLocalPos((PxRigidBody)this.getPxRigidBody(), (PxVec3)pxForce, (PxVec3)pxPos);
            } else {
                PxRigidBodyExt.addForceAtPos((PxRigidBody)this.getPxRigidBody(), (PxVec3)pxForce, (PxVec3)pxPos);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addImpulseAtPos(@NotNull Vec3f impulse, @NotNull Vec3f pos, boolean isLocalImpulse, boolean isLocalPos) {
        Intrinsics.checkNotNullParameter((Object)impulse, (String)"impulse");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"createPxVec3(...)");
            PxVec3 pxImpulse = PhysXExtensionsKt.toPxVec3(impulse, pxVec3);
            PxVec3 pxVec32 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"createPxVec3(...)");
            PxVec3 pxPos = PhysXExtensionsKt.toPxVec3(pos, pxVec32);
            if (isLocalImpulse && isLocalPos) {
                PxRigidBodyExt.addLocalForceAtLocalPos((PxRigidBody)this.getPxRigidBody(), (PxVec3)pxImpulse, (PxVec3)pxPos, (PxForceModeEnum)PxForceModeEnum.eIMPULSE);
            } else if (isLocalImpulse && !isLocalPos) {
                PxRigidBodyExt.addLocalForceAtPos((PxRigidBody)this.getPxRigidBody(), (PxVec3)pxImpulse, (PxVec3)pxPos, (PxForceModeEnum)PxForceModeEnum.eIMPULSE);
            } else if (!isLocalImpulse && isLocalPos) {
                PxRigidBodyExt.addForceAtLocalPos((PxRigidBody)this.getPxRigidBody(), (PxVec3)pxImpulse, (PxVec3)pxPos, (PxForceModeEnum)PxForceModeEnum.eIMPULSE);
            } else {
                PxRigidBodyExt.addForceAtPos((PxRigidBody)this.getPxRigidBody(), (PxVec3)pxImpulse, (PxVec3)pxPos, (PxForceModeEnum)PxForceModeEnum.eIMPULSE);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void addTorque(@NotNull Vec3f torque, boolean isLocalTorque) {
        Intrinsics.checkNotNullParameter((Object)torque, (String)"torque");
        this.tmpVec.set(torque);
        if (isLocalTorque) {
            this.getTransform().transform(this.tmpVec, 0.0f);
        }
        this.getPxRigidBody().addTorque(PhysXExtensionsKt.toPxVec3((Vec3f)this.tmpVec, this.pxTmpVec));
    }
}

