/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.math.Mat3f;
import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MutableQuatF;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.QuatF;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.math.spatial.BoundingBoxF;
import de.fabmax.kool.modules.ksl.KslPbrShader;
import de.fabmax.kool.physics.FilterData;
import de.fabmax.kool.physics.FilterDataBuilder;
import de.fabmax.kool.physics.FilterDataKt;
import de.fabmax.kool.physics.Material_desktopKt;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsImpl;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.Shape;
import de.fabmax.kool.physics.character.HitActorBehavior;
import de.fabmax.kool.scene.Node;
import de.fabmax.kool.scene.Tags;
import de.fabmax.kool.scene.TrsTransformF;
import de.fabmax.kool.util.BaseReleasable;
import de.fabmax.kool.util.Color;
import de.fabmax.kool.util.Releasable;
import de.fabmax.kool.util.ReleasableKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.common.PxBounds3;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxRigidActorExt;
import physx.geometry.PxGeometry;
import physx.physics.PxFilterData;
import physx.physics.PxMaterial;
import physx.physics.PxRigidActor;
import physx.physics.PxShape;
import physx.physics.PxShapeFlagEnum;
import physx.physics.PxShapeFlags;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010E\u001a\u000209H\u0002J\u0010\u0010F\u001a\u0002092\u0006\u0010G\u001a\u00020=H\u0016J\u0010\u0010H\u001a\u0002092\u0006\u0010G\u001a\u00020=H\u0016J\b\u0010I\u001a\u000209H\u0016J\u0010\u00105\u001a\u0002092\u0006\u0010J\u001a\u000208H\u0016J\u0010\u0010K\u001a\u0002092\u0006\u0010L\u001a\u00020*H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R$\u0010+\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020*@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020*X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010,\"\u0004\b0\u0010.R\u0014\u00101\u001a\u000202X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R&\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u0002090706X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020=06X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020=0?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010;R\u0014\u0010A\u001a\u00020BX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010D\u00a8\u0006N"}, d2={"Lde/fabmax/kool/physics/RigidActorImpl;", "Lde/fabmax/kool/util/BaseReleasable;", "Lde/fabmax/kool/physics/RigidActor;", "<init>", "()V", "value", "Lde/fabmax/kool/physics/FilterData;", "simulationFilterData", "getSimulationFilterData", "()Lde/fabmax/kool/physics/FilterData;", "setSimulationFilterData", "(Lde/fabmax/kool/physics/FilterData;)V", "queryFilterData", "getQueryFilterData", "setQueryFilterData", "characterControllerHitBehavior", "Lde/fabmax/kool/physics/character/HitActorBehavior;", "getCharacterControllerHitBehavior", "()Lde/fabmax/kool/physics/character/HitActorBehavior;", "setCharacterControllerHitBehavior", "(Lde/fabmax/kool/physics/character/HitActorBehavior;)V", "bufBounds", "Lde/fabmax/kool/math/spatial/BoundingBoxF;", "bufPosition", "Lde/fabmax/kool/math/MutableVec3f;", "bufRotation", "Lde/fabmax/kool/math/MutableQuatF;", "Lde/fabmax/kool/math/Vec3f;", "position", "getPosition", "()Lde/fabmax/kool/math/Vec3f;", "setPosition", "(Lde/fabmax/kool/math/Vec3f;)V", "Lde/fabmax/kool/math/QuatF;", "rotation", "getRotation", "()Lde/fabmax/kool/math/QuatF;", "setRotation", "(Lde/fabmax/kool/math/QuatF;)V", "worldBounds", "getWorldBounds", "()Lde/fabmax/kool/math/spatial/BoundingBoxF;", "", "isTrigger", "()Z", "setTrigger", "(Z)V", "isActive", "setActive", "transform", "Lde/fabmax/kool/scene/TrsTransformF;", "getTransform", "()Lde/fabmax/kool/scene/TrsTransformF;", "onPhysicsUpdate", "", "Lkotlin/Function1;", "", "", "getOnPhysicsUpdate", "()Ljava/util/List;", "_shapes", "Lde/fabmax/kool/physics/Shape;", "shapes", "", "getShapes", "tags", "Lde/fabmax/kool/scene/Tags;", "getTags", "()Lde/fabmax/kool/scene/Tags;", "updateFilterData", "attachShape", "shape", "detachShape", "release", "timeStep", "updateTransform", "force", "Companion", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nRigidActor.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RigidActor.desktop.kt\nde/fabmax/kool/physics/RigidActorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LwjglExtensions.kt\nde/fabmax/kool/util/LwjglExtensionsKt\n*L\n1#1,144:1\n1863#2,2:145\n1863#2,2:149\n19#3,2:147\n*S KotlinDebug\n*F\n+ 1 RigidActor.desktop.kt\nde/fabmax/kool/physics/RigidActorImpl\n*L\n70#1:145,2\n90#1:149,2\n87#1:147,2\n*E\n"})
public abstract class RigidActorImpl
extends BaseReleasable
implements RigidActor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private FilterData simulationFilterData;
    @NotNull
    private FilterData queryFilterData;
    @NotNull
    private HitActorBehavior characterControllerHitBehavior;
    @NotNull
    private final BoundingBoxF bufBounds;
    @NotNull
    private final MutableVec3f bufPosition;
    @NotNull
    private final MutableQuatF bufRotation;
    private boolean isTrigger;
    private boolean isActive;
    @NotNull
    private final TrsTransformF transform;
    @NotNull
    private final List<Function1<Float, Unit>> onPhysicsUpdate;
    @NotNull
    private final List<Shape> _shapes;
    @NotNull
    private final Tags tags;
    private static final int SIM_SHAPE_FLAGS = PxShapeFlagEnum.eSIMULATION_SHAPE.value | PxShapeFlagEnum.eSCENE_QUERY_SHAPE.value;
    private static final int TRIGGER_SHAPE_FLAGS = PxShapeFlagEnum.eTRIGGER_SHAPE.value;

    public RigidActorImpl() {
        PhysicsImpl.INSTANCE.checkIsLoaded();
        this.simulationFilterData = FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)RigidActorImpl::simulationFilterData$lambda$0));
        this.queryFilterData = new FilterData(0, 0, 0, 0, 15, null);
        this.characterControllerHitBehavior = HitActorBehavior.SLIDE;
        this.bufBounds = new BoundingBoxF();
        this.bufPosition = new MutableVec3f();
        this.bufRotation = new MutableQuatF();
        this.isActive = true;
        this.transform = new TrsTransformF();
        this.onPhysicsUpdate = new ArrayList();
        this._shapes = new ArrayList();
        this.tags = new Tags(null, 1, null);
    }

    @Override
    @NotNull
    public FilterData getSimulationFilterData() {
        return this.simulationFilterData;
    }

    @Override
    public void setSimulationFilterData(@NotNull FilterData value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.simulationFilterData = value;
        this.updateFilterData();
    }

    @Override
    @NotNull
    public FilterData getQueryFilterData() {
        return this.queryFilterData;
    }

    @Override
    public void setQueryFilterData(@NotNull FilterData value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.queryFilterData = value;
        this.updateFilterData();
    }

    @Override
    @NotNull
    public HitActorBehavior getCharacterControllerHitBehavior() {
        return this.characterControllerHitBehavior;
    }

    @Override
    public void setCharacterControllerHitBehavior(@NotNull HitActorBehavior hitActorBehavior) {
        Intrinsics.checkNotNullParameter((Object)((Object)hitActorBehavior), (String)"<set-?>");
        this.characterControllerHitBehavior = hitActorBehavior;
    }

    @Override
    @NotNull
    public Vec3f getPosition() {
        PxVec3 pxVec3 = this.getHolder().getGlobalPose().getP();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"getP(...)");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufPosition);
    }

    @Override
    public void setPosition(@NotNull Vec3f value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PxTransform pose = this.getHolder().getGlobalPose();
        PxVec3 pxVec3 = pose.getP();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"getP(...)");
        PhysXExtensionsKt.toPxVec3(value, pxVec3);
        this.getHolder().setGlobalPose(pose);
        this.updateTransform(true);
    }

    @Override
    @NotNull
    public QuatF getRotation() {
        PxQuat pxQuat = this.getHolder().getGlobalPose().getQ();
        Intrinsics.checkNotNullExpressionValue((Object)pxQuat, (String)"getQ(...)");
        return (QuatF)PhysXExtensionsKt.toQuatF(pxQuat, this.bufRotation);
    }

    @Override
    public void setRotation(@NotNull QuatF value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PxTransform pose = this.getHolder().getGlobalPose();
        PxQuat pxQuat = pose.getQ();
        Intrinsics.checkNotNullExpressionValue((Object)pxQuat, (String)"getQ(...)");
        PhysXExtensionsKt.toPxQuat(value, pxQuat);
        this.getHolder().setGlobalPose(pose);
        this.updateTransform(true);
    }

    @Override
    @NotNull
    public BoundingBoxF getWorldBounds() {
        PxBounds3 pxBounds3 = this.getHolder().getWorldBounds();
        Intrinsics.checkNotNullExpressionValue((Object)pxBounds3, (String)"getWorldBounds(...)");
        return PhysXExtensionsKt.toBoundingBox(pxBounds3, this.bufBounds);
    }

    @Override
    public boolean isTrigger() {
        return this.isTrigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrigger(boolean value) {
        this.isTrigger = value;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            int flags = this.isTrigger() ? TRIGGER_SHAPE_FLAGS : SIM_SHAPE_FLAGS;
            Intrinsics.checkNotNull((Object)mem);
            PxShapeFlags shapeFlags = PhysXExtensionsKt.createPxShapeFlags(mem, flags);
            Iterable $this$forEach$iv = this.getShapes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Shape it = (Shape)element$iv;
                boolean bl2 = false;
                PxShape pxShape = it.getHolder$kool_physics();
                if (pxShape == null) continue;
                pxShape.setFlags(shapeFlags);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    @Override
    @NotNull
    public TrsTransformF getTransform() {
        return this.transform;
    }

    @Override
    @NotNull
    public List<Function1<Float, Unit>> getOnPhysicsUpdate() {
        return this.onPhysicsUpdate;
    }

    @Override
    @NotNull
    public List<Shape> getShapes() {
        return this._shapes;
    }

    @Override
    @NotNull
    public Tags getTags() {
        return this.tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFilterData() {
        boolean $i$f$memStack = false;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack$iv = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stack$iv);
            MemoryStack $this$updateFilterData_u24lambda_u245 = stack$iv;
            boolean bl2 = false;
            FilterData filterData = this.getSimulationFilterData();
            PxFilterData pxFilterData = PhysXExtensionsKt.createPxFilterData($this$updateFilterData_u24lambda_u245);
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData, (String)"createPxFilterData(...)");
            PxFilterData sfd = PhysXExtensionsKt.toPxFilterData(filterData, pxFilterData);
            FilterData filterData2 = this.getQueryFilterData();
            PxFilterData pxFilterData2 = PhysXExtensionsKt.createPxFilterData($this$updateFilterData_u24lambda_u245);
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData2, (String)"createPxFilterData(...)");
            PxFilterData qfd = PhysXExtensionsKt.toPxFilterData(filterData2, pxFilterData2);
            Iterable $this$forEach$iv = this.getShapes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PxShape it;
                Shape shape = (Shape)element$iv;
                boolean bl3 = false;
                if (shape.getHolder$kool_physics() == null) continue;
                boolean bl4 = false;
                it.setSimulationFilterData(sfd);
                it.setQueryFilterData(qfd);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        ((Collection)this._shapes).add(shape);
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            int flags = this.isTrigger() ? TRIGGER_SHAPE_FLAGS : SIM_SHAPE_FLAGS;
            Intrinsics.checkNotNull((Object)mem);
            PxShapeFlags shapeFlags = PhysXExtensionsKt.createPxShapeFlags(mem, flags);
            PxShape pxShape = PxRigidActorExt.createExclusiveShape((PxRigidActor)this.getHolder(), (PxGeometry)shape.getGeometry().getHolder(), (PxMaterial)Material_desktopKt.getPxMaterial(shape.getMaterial()), (PxShapeFlags)shapeFlags);
            Mat4f mat4f = shape.getLocalPose();
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            pxShape.setLocalPose(PhysXExtensionsKt.toPxTransform(mat4f, pxTransform));
            FilterData filterData = shape.getSimFilterData();
            if (filterData == null) {
                filterData = this.getSimulationFilterData();
            }
            FilterData simFd = filterData;
            PxFilterData pxFilterData = PhysXExtensionsKt.createPxFilterData(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData, (String)"createPxFilterData(...)");
            pxShape.setSimulationFilterData(PhysXExtensionsKt.toPxFilterData(simFd, pxFilterData));
            FilterData filterData2 = shape.getQueryFilterData();
            if (filterData2 == null) {
                filterData2 = this.getQueryFilterData();
            }
            FilterData qryFd = filterData2;
            PxFilterData pxFilterData2 = PhysXExtensionsKt.createPxFilterData(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData2, (String)"createPxFilterData(...)");
            pxShape.setQueryFilterData(PhysXExtensionsKt.toPxFilterData(qryFd, pxFilterData2));
            shape.setHolder$kool_physics(pxShape);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void detachShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        ((Collection)this._shapes).remove(shape);
        PxShape pxShape = shape.getHolder$kool_physics();
        if (pxShape != null) {
            pxShape.release();
        }
        shape.setHolder$kool_physics(null);
    }

    public void release() {
        super.release();
        this.getHolder().release();
        this._shapes.clear();
    }

    @Override
    public void onPhysicsUpdate(float timeStep) {
        ReleasableKt.checkIsNotReleased((Releasable)this);
        this.updateTransform(false);
        RigidActor.DefaultImpls.onPhysicsUpdate(this, timeStep);
    }

    private final void updateTransform(boolean force) {
        if (this.isActive() || force) {
            PxTransform pxTransform = this.getHolder().getGlobalPose();
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"getGlobalPose(...)");
            PhysXExtensionsKt.toTrsTransform(pxTransform, this.getTransform());
        }
    }

    @Override
    public void setRotation-tS0NhXc(float eulerX, float eulerY, float eulerZ) {
        RigidActor.DefaultImpls.setRotation-tS0NhXc(this, eulerX, eulerY, eulerZ);
    }

    @Override
    public void setRotation(@NotNull Mat3f rotation) {
        RigidActor.DefaultImpls.setRotation(this, rotation);
    }

    @Override
    public void setTransform(@NotNull Mat4f transform) {
        RigidActor.DefaultImpls.setTransform(this, transform);
    }

    @Override
    @NotNull
    public MutableVec3f toGlobal(@NotNull MutableVec3f vec, float w) {
        return RigidActor.DefaultImpls.toGlobal(this, vec, w);
    }

    @Override
    @NotNull
    public MutableVec3f toLocal(@NotNull MutableVec3f vec, float w) {
        return RigidActor.DefaultImpls.toLocal(this, vec, w);
    }

    @Override
    @NotNull
    public Node toMesh(@NotNull Color meshColor, @NotNull Function1<? super KslPbrShader.Config.Builder, Unit> materialCfg) {
        return RigidActor.DefaultImpls.toMesh(this, meshColor, materialCfg);
    }

    private static final Unit simulationFilterData$lambda$0(FilterDataBuilder $this$FilterData) {
        Intrinsics.checkNotNullParameter((Object)$this$FilterData, (String)"$this$FilterData");
        $this$FilterData.setCollisionGroup(0);
        $this$FilterData.setCollidesWithEverything();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lde/fabmax/kool/physics/RigidActorImpl$Companion;", "", "<init>", "()V", "SIM_SHAPE_FLAGS", "", "getSIM_SHAPE_FLAGS", "()I", "TRIGGER_SHAPE_FLAGS", "getTRIGGER_SHAPE_FLAGS", "kool-physics"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSIM_SHAPE_FLAGS() {
            return SIM_SHAPE_FLAGS;
        }

        public final int getTRIGGER_SHAPE_FLAGS() {
            return TRIGGER_SHAPE_FLAGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

