/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.editor.components;

import de.fabmax.kool.editor.api.AppMode;
import de.fabmax.kool.editor.api.AppState;
import de.fabmax.kool.editor.api.GameEntity;
import de.fabmax.kool.editor.components.CharacterControllerComponent;
import de.fabmax.kool.editor.components.GameEntityComponentKt;
import de.fabmax.kool.editor.components.GameEntityDataComponent;
import de.fabmax.kool.editor.components.PhysicsActorComponent;
import de.fabmax.kool.editor.components.PhysicsMaterial;
import de.fabmax.kool.editor.components.PhysicsWorldComponent;
import de.fabmax.kool.editor.components.RigidActorComponent;
import de.fabmax.kool.editor.data.CharacterControllerComponentData;
import de.fabmax.kool.editor.data.ComponentInfo;
import de.fabmax.kool.editor.data.EntityId;
import de.fabmax.kool.editor.data.PhysicsMaterialData;
import de.fabmax.kool.editor.data.PhysicsWorldComponentData;
import de.fabmax.kool.editor.data.Vec3Data;
import de.fabmax.kool.math.AngleKt;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.math.spatial.BoundingBoxF;
import de.fabmax.kool.physics.Material;
import de.fabmax.kool.physics.Material_desktopKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.PhysicsStepListener;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.PhysicsWorld_desktopKt;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.character.CharacterController;
import de.fabmax.kool.physics.character.CharacterControllerManager;
import de.fabmax.kool.physics.character.CharacterControllerManager_desktopKt;
import de.fabmax.kool.physics.character.CharacterControllerProperties;
import de.fabmax.kool.pipeline.RenderPass;
import de.fabmax.kool.util.Log;
import de.fabmax.kool.util.LogPrinter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001LB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020)J\u000e\u00106\u001a\u0002042\u0006\u00105\u001a\u00020)J\u0010\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020#J\u000e\u0010:\u001a\u0002042\u0006\u00109\u001a\u00020#J\u0006\u0010;\u001a\u000204J\u0018\u0010<\u001a\u0002042\u0006\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020\u0002H\u0014J\u0010\u0010?\u001a\u0002042\u0006\u0010@\u001a\u00020\u0002H\u0002J\u0010\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020(H\u0002J\u0010\u0010C\u001a\u0002042\u0006\u0010@\u001a\u00020\u0002H\u0002J\u000e\u0010D\u001a\u000204H\u0096@\u00a2\u0006\u0002\u0010EJ\f\u0010F\u001a\u000204*\u00020\nH\u0002J\u0010\u0010G\u001a\u0002042\u0006\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u000204H\u0016J\b\u0010K\u001a\u000204H\u0016R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\"\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\t\u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010*\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u00101\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000+8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010-\u00a8\u0006M"}, d2={"Lde/fabmax/kool/editor/components/PhysicsWorldComponent;", "Lde/fabmax/kool/editor/components/GameEntityDataComponent;", "Lde/fabmax/kool/editor/data/PhysicsWorldComponentData;", "gameEntity", "Lde/fabmax/kool/editor/api/GameEntity;", "componentInfo", "Lde/fabmax/kool/editor/data/ComponentInfo;", "<init>", "(Lde/fabmax/kool/editor/api/GameEntity;Lde/fabmax/kool/editor/data/ComponentInfo;)V", "value", "Lde/fabmax/kool/physics/PhysicsWorld;", "physicsWorld", "getPhysicsWorld", "()Lde/fabmax/kool/physics/PhysicsWorld;", "Lde/fabmax/kool/math/Vec3f;", "gravity", "getGravity", "()Lde/fabmax/kool/math/Vec3f;", "setGravity", "(Lde/fabmax/kool/math/Vec3f;)V", "physicsBounds", "Lde/fabmax/kool/math/spatial/BoundingBoxF;", "getPhysicsBounds", "()Lde/fabmax/kool/math/spatial/BoundingBoxF;", "setPhysicsBounds", "(Lde/fabmax/kool/math/spatial/BoundingBoxF;)V", "isLimitedRange", "", "()Z", "Lde/fabmax/kool/physics/character/CharacterControllerManager;", "characterControllerManager", "getCharacterControllerManager", "()Lde/fabmax/kool/physics/character/CharacterControllerManager;", "charControllers", "", "Lde/fabmax/kool/editor/components/CharacterControllerComponent;", "actorStates", "Lde/fabmax/kool/editor/components/PhysicsWorldComponent$ActorState;", "_actors", "", "Lde/fabmax/kool/physics/RigidActor;", "Lde/fabmax/kool/editor/components/RigidActorComponent;", "actors", "", "getActors", "()Ljava/util/Map;", "_materials", "Lde/fabmax/kool/editor/data/EntityId;", "Lde/fabmax/kool/editor/components/PhysicsMaterial;", "materials", "getMaterials", "addActor", "", "rigidActorComponent", "removeActor", "addCharController", "Lde/fabmax/kool/physics/character/CharacterController;", "charController", "removeCharController", "updateReferenceFrame", "onDataChanged", "oldData", "newData", "updateBounds", "data", "isInBounds", "actor", "updateMaterials", "applyComponent", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyWorldBounds", "onUpdate", "ev", "Lde/fabmax/kool/pipeline/RenderPass$UpdateEvent;", "destroyComponent", "onStart", "ActorState", "kool-editor-model"})
@SourceDebugExtension(value={"SMAP\nPhysicsWorldComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsWorldComponent.kt\nde/fabmax/kool/editor/components/PhysicsWorldComponent\n+ 2 Log.kt\nde/fabmax/kool/util/LogKt\n+ 3 Log.kt\nde/fabmax/kool/util/Log\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,232:1\n41#2,7:233\n41#2,7:244\n41#2,7:256\n41#2,7:267\n40#2,7:280\n37#2,7:304\n37#2,7:315\n18#3,4:240\n18#3,4:251\n18#3,4:263\n18#3,4:274\n18#3,4:287\n18#3,4:311\n18#3,4:322\n1#4:255\n1869#5,2:278\n1563#5:291\n1634#5,3:292\n1869#5:295\n1870#5:303\n1869#5,2:326\n382#6,7:296\n*S KotlinDebug\n*F\n+ 1 PhysicsWorldComponent.kt\nde/fabmax/kool/editor/components/PhysicsWorldComponent\n*L\n56#1:233,7\n60#1:244,7\n89#1:256,7\n93#1:267,7\n126#1:280,7\n181#1:304,7\n185#1:315,7\n56#1:240,4\n60#1:251,4\n89#1:263,4\n93#1:274,4\n126#1:287,4\n181#1:311,4\n185#1:322,4\n117#1:278,2\n147#1:291\n147#1:292,3\n148#1:295\n148#1:303\n200#1:326,2\n149#1:296,7\n*E\n"})
public final class PhysicsWorldComponent
extends GameEntityDataComponent<PhysicsWorldComponentData> {
    @Nullable
    private PhysicsWorld physicsWorld;
    @Nullable
    private BoundingBoxF physicsBounds;
    @Nullable
    private CharacterControllerManager characterControllerManager;
    @NotNull
    private final List<CharacterControllerComponent> charControllers;
    @NotNull
    private final List<ActorState> actorStates;
    @NotNull
    private final Map<RigidActor, RigidActorComponent> _actors;
    @NotNull
    private final Map<EntityId, PhysicsMaterial> _materials;

    public PhysicsWorldComponent(@NotNull GameEntity gameEntity, @NotNull ComponentInfo<PhysicsWorldComponentData> componentInfo) {
        Intrinsics.checkNotNullParameter((Object)gameEntity, (String)"gameEntity");
        Intrinsics.checkNotNullParameter(componentInfo, (String)"componentInfo");
        super(gameEntity, componentInfo);
        this.charControllers = new ArrayList();
        this.actorStates = new ArrayList();
        this._actors = new LinkedHashMap();
        this._materials = new LinkedHashMap();
        this.updateMaterials((PhysicsWorldComponentData)this.getData());
        this.updateBounds((PhysicsWorldComponentData)this.getData());
    }

    public /* synthetic */ PhysicsWorldComponent(GameEntity gameEntity, ComponentInfo componentInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            componentInfo = new ComponentInfo(new PhysicsWorldComponentData(null, false, null, null, 15, null), 0, 2, null);
        }
        this(gameEntity, componentInfo);
    }

    @Nullable
    public final PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    @NotNull
    public final Vec3f getGravity() {
        return (Vec3f)Vec3Data.toVec3f$default(((PhysicsWorldComponentData)this.getData()).getGravity(), null, 1, null);
    }

    public final void setGravity(@NotNull Vec3f value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getDataState().set((Object)PhysicsWorldComponentData.copy$default((PhysicsWorldComponentData)this.getData(), new Vec3Data(value), false, null, null, 14, null));
    }

    @Nullable
    public final BoundingBoxF getPhysicsBounds() {
        return this.physicsBounds;
    }

    public final void setPhysicsBounds(@Nullable BoundingBoxF boundingBoxF) {
        this.physicsBounds = boundingBoxF;
    }

    public final boolean isLimitedRange() {
        return this.physicsBounds != null;
    }

    @Nullable
    public final CharacterControllerManager getCharacterControllerManager() {
        return this.characterControllerManager;
    }

    @NotNull
    public final Map<RigidActor, RigidActorComponent> getActors() {
        return this._actors;
    }

    @NotNull
    public final Map<EntityId, PhysicsMaterial> getMaterials() {
        return this._materials;
    }

    /*
     * WARNING - void declaration
     */
    public final void addActor(@NotNull RigidActorComponent rigidActorComponent) {
        Intrinsics.checkNotNullParameter((Object)rigidActorComponent, (String)"rigidActorComponent");
        PhysicsWorld world = this.physicsWorld;
        RigidActor actor = rigidActorComponent.getRigidActor();
        if (world == null) {
            void this_$iv$iv$iv;
            void level$iv$iv$iv;
            PhysicsWorldComponent $this$logE$iv = this;
            boolean $i$f$logE = false;
            String tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logE$iv.getClass()).getSimpleName();
            boolean $i$f$logE2 = false;
            Log log = Log.INSTANCE;
            Log.Level level = Log.Level.ERROR;
            String tag$iv$iv$iv = tag$iv$iv;
            boolean $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                String string = tag$iv$iv$iv;
                void var14_23 = level$iv$iv$iv;
                LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string2 = "Unable to add rigid actor: parent physics world was not yet created";
                logPrinter.print((Log.Level)var14_23, string, string2);
            }
            return;
        }
        if (actor == null) {
            PhysicsWorldComponent $this$logE$iv = this;
            boolean $i$f$logE = false;
            String tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logE$iv.getClass()).getSimpleName();
            boolean $i$f$logE3 = false;
            Log this_$iv$iv$iv = Log.INSTANCE;
            Log.Level level$iv$iv$iv = Log.Level.ERROR;
            String tag$iv$iv$iv = tag$iv$iv;
            boolean $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                String string = tag$iv$iv$iv;
                Log.Level level = level$iv$iv$iv;
                LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string3 = "Unable to add rigid actor: actor was not yet created";
                logPrinter.print(level, string, string3);
            }
            return;
        }
        this._actors.put(actor, rigidActorComponent);
        ActorState actorState = new ActorState(actor, rigidActorComponent);
        ((Collection)this.actorStates).add(actorState);
        actorState.setAttached(!this.isLimitedRange());
        if (actorState.isAttached()) {
            world.addActor(actor);
        }
    }

    public final void removeActor(@NotNull RigidActorComponent rigidActorComponent) {
        block5: {
            ActorState state;
            Object v1;
            RigidActor actor;
            block4: {
                Intrinsics.checkNotNullParameter((Object)rigidActorComponent, (String)"rigidActorComponent");
                RigidActor rigidActor = rigidActorComponent.getRigidActor();
                if (rigidActor == null) {
                    return;
                }
                actor = rigidActor;
                this._actors.remove(actor);
                Iterable iterable = this.actorStates;
                for (Object t : iterable) {
                    ActorState it = (ActorState)t;
                    boolean bl = false;
                    if (!(it.getComponent() == rigidActorComponent)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            ActorState actorState = state = (ActorState)v1;
            if (actorState == null) break block5;
            ActorState it = actorState;
            boolean bl = false;
            ((Collection)this.actorStates).remove(it);
            if (it.isAttached()) {
                PhysicsWorld physicsWorld = this.physicsWorld;
                if (physicsWorld != null) {
                    physicsWorld.removeActor(actor);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CharacterController addCharController(@NotNull CharacterControllerComponent charController) {
        Intrinsics.checkNotNullParameter((Object)charController, (String)"charController");
        PhysicsWorld world = this.physicsWorld;
        CharacterControllerManager charMgr = this.characterControllerManager;
        if (world == null) {
            void this_$iv$iv$iv;
            void level$iv$iv$iv;
            PhysicsWorldComponent $this$logE$iv = this;
            boolean $i$f$logE = false;
            String tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logE$iv.getClass()).getSimpleName();
            boolean $i$f$logE2 = false;
            Log log = Log.INSTANCE;
            Log.Level level = Log.Level.ERROR;
            String tag$iv$iv$iv = tag$iv$iv;
            boolean $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                String string = tag$iv$iv$iv;
                void var14_23 = level$iv$iv$iv;
                LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string2 = "Unable to add character controller: parent physics world was not yet created";
                logPrinter.print((Log.Level)var14_23, string, string2);
            }
            return null;
        }
        if (charMgr == null) {
            PhysicsWorldComponent $this$logE$iv = this;
            boolean $i$f$logE = false;
            String tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logE$iv.getClass()).getSimpleName();
            boolean $i$f$logE3 = false;
            Log this_$iv$iv$iv = Log.INSTANCE;
            Log.Level level$iv$iv$iv = Log.Level.ERROR;
            String tag$iv$iv$iv = tag$iv$iv;
            boolean $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                String string = tag$iv$iv$iv;
                Log.Level level = level$iv$iv$iv;
                LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string3 = "Unable to add character controller: controller manager was not yet created";
                logPrinter.print(level, string, string3);
            }
            return null;
        }
        ((Collection)this.charControllers).add(charController);
        charController.setAttachedToSimulation$kool_editor_model(true);
        CharacterControllerProperties props = new CharacterControllerProperties((float)((CharacterControllerComponentData)charController.getData()).getShape().getLength(), (float)((CharacterControllerComponentData)charController.getData()).getShape().getRadius() - 0.05f, AngleKt.getDeg((float)((CharacterControllerComponentData)charController.getData()).getSlopeLimit()), null, 0.05f, null, null, 104, null);
        CharacterController characterController = charController.getCharController();
        if (characterController == null) {
            characterController = charMgr.createController(props);
        }
        return characterController;
    }

    public final void removeCharController(@NotNull CharacterControllerComponent charController) {
        Intrinsics.checkNotNullParameter((Object)charController, (String)"charController");
        CharacterControllerManager characterControllerManager = this.characterControllerManager;
        if (characterControllerManager == null) {
            return;
        }
        CharacterControllerManager charMgr = characterControllerManager;
        CharacterController characterController = charController.getCharController();
        if (characterController == null) {
            return;
        }
        CharacterController ctrl = characterController;
        charMgr.removeController(ctrl);
        ((Collection)this.charControllers).remove(charController);
        charController.setAttachedToSimulation$kool_editor_model(false);
    }

    public final void updateReferenceFrame() {
        Iterable $this$forEach$iv = this.actorStates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ActorState state = (ActorState)element$iv;
            boolean bl = false;
            state.getComponent().setPhysicsTransformFromDrawNode();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onDataChanged(@NotNull PhysicsWorldComponentData oldData, @NotNull PhysicsWorldComponentData newData) {
        Intrinsics.checkNotNullParameter((Object)oldData, (String)"oldData");
        Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
        PhysicsWorld physicsWorld = this.physicsWorld;
        if (physicsWorld != null) {
            PhysicsWorld world = physicsWorld;
            boolean bl = false;
            world.setGravity((Vec3f)Vec3Data.toVec3f$default(newData.getGravity(), null, 1, null));
            if (oldData.isContinuousCollisionDetection() != newData.isContinuousCollisionDetection()) {
                void this_$iv$iv$iv;
                void level$iv$iv$iv;
                PhysicsWorldComponent $this$logW$iv = this;
                boolean $i$f$logW = false;
                String tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logW$iv.getClass()).getSimpleName();
                boolean $i$f$logW2 = false;
                Log log = Log.INSTANCE;
                Log.Level level = Log.Level.WARN;
                String tag$iv$iv$iv = tag$iv$iv;
                boolean $i$f$log = false;
                if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                    String string = tag$iv$iv$iv;
                    void var14_14 = level$iv$iv$iv;
                    LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                    boolean bl2 = false;
                    String string2 = "Continuous collision detection can not be changed after physics world was created";
                    logPrinter.print((Log.Level)var14_14, string, string2);
                }
            }
        }
        this.updateMaterials(newData);
        this.updateBounds(newData);
    }

    private final void updateBounds(PhysicsWorldComponentData data) {
        this.physicsBounds = data.getPhysicsRange().getX() > 1.0 ? new BoundingBoxF(new Vec3f(-((float)data.getPhysicsRange().getX())), new Vec3f((float)data.getPhysicsRange().getX())) : null;
    }

    private final boolean isInBounds(RigidActor actor) {
        BoundingBoxF boundingBoxF = this.physicsBounds;
        if (boundingBoxF == null) {
            return true;
        }
        BoundingBoxF bounds = boundingBoxF;
        return bounds.contains(actor.getPose().getPosition());
    }

    /*
     * WARNING - void declaration
     */
    private final void updateMaterials(PhysicsWorldComponentData data) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = data.getMaterials();
        Set<EntityId> set = this._materials.keySet();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PhysicsMaterialData physicsMaterialData = (PhysicsMaterialData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(EntityId.box-impl(it.getId-ocdbQmI()));
        }
        set.retainAll(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Iterable $this$forEach$iv = data.getMaterials();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            Object item$iv$iv;
            PhysicsMaterialData matData = (PhysicsMaterialData)element$iv;
            boolean bl = false;
            item$iv$iv = this._materials;
            EntityId key$iv = EntityId.box-impl(matData.getId-ocdbQmI());
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Material material = Material_desktopKt.Material((float)matData.getStaticFriction(), (float)matData.getDynamicFriction(), (float)matData.getRestitution());
                PhysicsMaterial answer$iv = new PhysicsMaterial(matData.getId-ocdbQmI(), matData.getName(), material, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            PhysicsMaterial mat = (PhysicsMaterial)object;
            mat.setName(matData.getName());
            mat.getMaterial().setStaticFriction(matData.getStaticFriction());
            mat.getMaterial().setDynamicFriction(matData.getDynamicFriction());
            mat.getMaterial().setRestitution(matData.getRestitution());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object applyComponent(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof applyComponent.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ PhysicsWorldComponent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.applyComponent((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = super.applyComponent((Continuation<? super Unit>)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                $continuation.label = 2;
                v1 = Physics.INSTANCE.loadAndAwaitPhysics((Continuation)$continuation);
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl28
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                var3_6 = var2_5 = PhysicsWorld_desktopKt.PhysicsWorld(null, (boolean)((PhysicsWorldComponentData)this.getData()).isContinuousCollisionDetection());
                var5_7 = this;
                $i$a$-also-PhysicsWorldComponent$applyComponent$2 = false;
                world.setGravity(this.getGravity());
                this.characterControllerManager = CharacterControllerManager_desktopKt.CharacterControllerManager((PhysicsWorld)world);
                world.getOnAdvancePhysics().plusAssign((Object)(PhysicsStepListener)LambdaMetafactory.metafactory(null, null, null, (F)V, applyComponent$lambda$0$0(de.fabmax.kool.editor.components.PhysicsWorldComponent de.fabmax.kool.physics.PhysicsWorld float ), (F)V)((PhysicsWorldComponent)this, (PhysicsWorld)world));
                var5_7.physicsWorld = var2_5;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void applyWorldBounds(PhysicsWorld $this$applyWorldBounds) {
        int n = ((Collection)this.actorStates).size();
        for (int i = 0; i < n; ++i) {
            String string;
            LogPrinter logPrinter;
            Log.Level level;
            String string2;
            Log this_$iv$iv$iv;
            Log.Level level$iv$iv$iv;
            boolean $i$f$log;
            String tag$iv$iv$iv;
            boolean $i$f$logT;
            String tag$iv$iv;
            boolean $i$f$logT2;
            PhysicsWorld $this$logT$iv;
            ActorState state = this.actorStates.get(i);
            if (state.isAttached() && !this.isInBounds(state.getActor())) {
                $this$logT$iv = $this$applyWorldBounds;
                $i$f$logT2 = false;
                tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logT$iv.getClass()).getSimpleName();
                $i$f$logT = false;
                Log log = Log.INSTANCE;
                Log.Level level2 = Log.Level.TRACE;
                tag$iv$iv$iv = tag$iv$iv;
                $i$f$log = false;
                if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                    string2 = tag$iv$iv$iv;
                    level = level$iv$iv$iv;
                    logPrinter = this_$iv$iv$iv.getPrinter();
                    boolean bl = false;
                    string = "Actor " + state.getComponent().getGameEntity().getName() + " left physics bounds";
                    logPrinter.print(level, string2, string);
                }
                $this$applyWorldBounds.removeActor(state.getActor());
                state.setAttached(false);
                continue;
            }
            if (state.isAttached() || !this.isInBounds(state.getActor())) continue;
            $this$logT$iv = $this$applyWorldBounds;
            $i$f$logT2 = false;
            tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logT$iv.getClass()).getSimpleName();
            $i$f$logT = false;
            this_$iv$iv$iv = Log.INSTANCE;
            level$iv$iv$iv = Log.Level.TRACE;
            tag$iv$iv$iv = tag$iv$iv;
            $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                string2 = tag$iv$iv$iv;
                level = level$iv$iv$iv;
                logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                string = "Actor " + state.getComponent().getGameEntity().getName() + " entered physics bounds";
                logPrinter.print(level, string2, string);
            }
            $this$applyWorldBounds.addActor(state.getActor());
            state.setAttached(true);
        }
    }

    @Override
    public void onUpdate(@NotNull RenderPass.UpdateEvent ev) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
            PhysicsWorld physicsWorld = this.physicsWorld;
            if (physicsWorld == null) break block0;
            PhysicsWorld world = physicsWorld;
            boolean bl = false;
            world.setPauseSimulation(AppState.INSTANCE.getAppMode() == AppMode.PAUSE);
        }
    }

    @Override
    public void destroyComponent() {
        CharacterControllerManager characterControllerManager = this.characterControllerManager;
        if (characterControllerManager != null) {
            CharacterControllerManager mgr = characterControllerManager;
            boolean bl = false;
            Iterable $this$forEach$iv = this.charControllers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CharacterControllerComponent it = (CharacterControllerComponent)element$iv;
                boolean bl2 = false;
                if (it.getCharController() != null) {
                    CharacterController ctrl;
                    boolean bl3 = false;
                    mgr.removeController(ctrl);
                    ctrl.release();
                }
                it.setCharController$kool_editor_model(null);
                it.setAttachedToSimulation$kool_editor_model(false);
            }
            mgr.release();
        }
        this.characterControllerManager = null;
        PhysicsWorld physicsWorld = this.physicsWorld;
        if (physicsWorld != null) {
            PhysicsWorld it = physicsWorld;
            boolean bl = false;
            it.unregisterHandlers();
            it.release();
        }
        this.physicsWorld = null;
        super.destroyComponent();
    }

    @Override
    public void onStart() {
        block0: {
            super.onStart();
            PhysicsWorld physicsWorld = this.physicsWorld;
            if (physicsWorld == null) break block0;
            physicsWorld.registerHandlers(GameEntityComponentKt.getSceneComponent(this).getSceneNode());
        }
    }

    private static final void applyComponent$lambda$0$0(PhysicsWorldComponent this$0, PhysicsWorld $world, float it) {
        if (this$0.isLimitedRange()) {
            this$0.applyWorldBounds($world);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR+\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u000e\u0010\u0011\"\u0004\b\u0012\u0010\u0013*\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lde/fabmax/kool/editor/components/PhysicsWorldComponent$ActorState;", "", "actor", "Lde/fabmax/kool/physics/RigidActor;", "component", "Lde/fabmax/kool/editor/components/PhysicsActorComponent;", "<init>", "(Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/editor/components/PhysicsActorComponent;)V", "getActor", "()Lde/fabmax/kool/physics/RigidActor;", "getComponent", "()Lde/fabmax/kool/editor/components/PhysicsActorComponent;", "<set-?>", "", "isAttached", "isAttached$delegate", "(Lde/fabmax/kool/editor/components/PhysicsWorldComponent$ActorState;)Ljava/lang/Object;", "()Z", "setAttached", "(Z)V", "kool-editor-model"})
    private static final class ActorState {
        @NotNull
        private final RigidActor actor;
        @NotNull
        private final PhysicsActorComponent<?> component;

        public ActorState(@NotNull RigidActor actor, @NotNull PhysicsActorComponent<?> component) {
            Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
            Intrinsics.checkNotNullParameter(component, (String)"component");
            this.actor = actor;
            this.component = component;
        }

        @NotNull
        public final RigidActor getActor() {
            return this.actor;
        }

        @NotNull
        public final PhysicsActorComponent<?> getComponent() {
            return this.component;
        }

        public final boolean isAttached() {
            return this.component.isAttachedToSimulation();
        }

        public final void setAttached(boolean bl) {
            this.component.setAttachedToSimulation$kool_editor_model(bl);
        }

        private static Object isAttached$delegate(ActorState actorState) {
            return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl(actorState.component, PhysicsActorComponent.class, "isAttachedToSimulation", "isAttachedToSimulation()Z", 0)));
        }
    }
}

