/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.editor.components;

import de.fabmax.kool.editor.api.AssetReference;
import de.fabmax.kool.editor.api.EntityLifecycle;
import de.fabmax.kool.editor.api.EntityLifecycleKt;
import de.fabmax.kool.editor.api.GameEntity;
import de.fabmax.kool.pipeline.RenderPass;
import de.fabmax.kool.util.Log;
import de.fabmax.kool.util.LogPrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 82\u00020\u0001:\u000278B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010%\u001a\u00020&H\u0004J\u000e\u0010'\u001a\u00020&H\u0096@\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020&H\u0016J\b\u0010*\u001a\u00020&H\u0016J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u000200H\u0016J\u001e\u00101\u001a\u00020&2\n\u0010\b\u001a\u0006\u0012\u0002\b\u0003022\b\b\u0002\u00103\u001a\u000204H\u0004J\u0014\u00105\u001a\u0002042\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u001f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00069"}, d2={"Lde/fabmax/kool/editor/components/GameEntityComponent;", "", "gameEntity", "Lde/fabmax/kool/editor/api/GameEntity;", "<init>", "(Lde/fabmax/kool/editor/api/GameEntity;)V", "getGameEntity", "()Lde/fabmax/kool/editor/api/GameEntity;", "componentType", "", "getComponentType", "()Ljava/lang/String;", "_dependencies", "", "Lde/fabmax/kool/editor/components/GameEntityComponent$ComponentDependency;", "dependencies", "", "getDependencies", "()Ljava/util/List;", "requiredAssets", "", "Lde/fabmax/kool/editor/api/AssetReference;", "getRequiredAssets", "()Ljava/util/Set;", "value", "Lde/fabmax/kool/editor/api/EntityLifecycle;", "lifecycle", "getLifecycle", "()Lde/fabmax/kool/editor/api/EntityLifecycle;", "setLifecycle", "(Lde/fabmax/kool/editor/api/EntityLifecycle;)V", "", "componentOrder", "getComponentOrder", "()I", "setComponentOrder", "(I)V", "checkDependencies", "", "applyComponent", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "destroyComponent", "onStart", "onUpdate", "ev", "Lde/fabmax/kool/pipeline/RenderPass$UpdateEvent;", "onPhysicsUpdate", "timeStep", "", "dependsOn", "Lkotlin/reflect/KClass;", "isOptional", "", "areDependenciesMetBy", "components", "ComponentDependency", "Companion", "kool-editor-model"})
@SourceDebugExtension(value={"SMAP\nGameEntityComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameEntityComponent.kt\nde/fabmax/kool/editor/components/GameEntityComponent\n+ 2 Log.kt\nde/fabmax/kool/util/LogKt\n+ 3 Log.kt\nde/fabmax/kool/util/Log\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n40#2,7:115\n18#3,4:122\n1740#4,2:126\n1761#4,3:128\n1742#4:131\n*S KotlinDebug\n*F\n+ 1 GameEntityComponent.kt\nde/fabmax/kool/editor/components/GameEntityComponent\n*L\n48#1:115,7\n48#1:122,4\n66#1:126,2\n66#1:128,3\n66#1:131\n*E\n"})
public abstract class GameEntityComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GameEntity gameEntity;
    @NotNull
    private final List<ComponentDependency> _dependencies;
    @NotNull
    private final Set<AssetReference> requiredAssets;
    @NotNull
    private EntityLifecycle lifecycle;
    private int componentOrder;
    public static final int COMPONENT_ORDER_EARLY = -100;
    public static final int COMPONENT_ORDER_DEFAULT = 0;
    public static final int COMPONENT_ORDER_LATE = 100;

    public GameEntityComponent(@NotNull GameEntity gameEntity) {
        Intrinsics.checkNotNullParameter((Object)gameEntity, (String)"gameEntity");
        this.gameEntity = gameEntity;
        this._dependencies = new ArrayList();
        this.requiredAssets = new LinkedHashSet();
        this.lifecycle = EntityLifecycle.CREATED;
    }

    @NotNull
    public final GameEntity getGameEntity() {
        return this.gameEntity;
    }

    @NotNull
    public String getComponentType() {
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final List<ComponentDependency> getDependencies() {
        return this._dependencies;
    }

    @NotNull
    public final Set<AssetReference> getRequiredAssets() {
        return this.requiredAssets;
    }

    @NotNull
    public final EntityLifecycle getLifecycle() {
        return this.lifecycle;
    }

    protected final void setLifecycle(@NotNull EntityLifecycle value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (!this.lifecycle.isAllowedAsNext(value)) {
            boolean bl = false;
            String string = "GameEntityComponent " + this.getComponentType() + " (entity: " + this.gameEntity.getName() + "): Transitioning from lifecycle state " + this.lifecycle + " to " + value + " is not allowed";
            throw new IllegalStateException(string.toString());
        }
        this.lifecycle = value;
    }

    public final int getComponentOrder() {
        return this.componentOrder;
    }

    protected final void setComponentOrder(int n) {
        this.componentOrder = n;
    }

    protected final void checkDependencies() {
        if (!this.areDependenciesMetBy(this.gameEntity.getComponents())) {
            boolean bl = false;
            String string = "Unable to create component " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " in node " + this.gameEntity.getName() + ": There are unmet component dependencies";
            throw new IllegalStateException(string.toString());
        }
    }

    @Nullable
    public Object applyComponent(@NotNull Continuation<? super Unit> $completion) {
        return GameEntityComponent.applyComponent$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object applyComponent$suspendImpl(GameEntityComponent $this, Continuation<? super Unit> $completion) {
        $this.checkDependencies();
        $this.setLifecycle(EntityLifecycle.PREPARED);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public void destroyComponent() {
        if (EntityLifecycleKt.isDestroyed(this)) {
            void this_$iv$iv$iv;
            void level$iv$iv$iv;
            GameEntityComponent $this$logW$iv = this;
            boolean $i$f$logW = false;
            String tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logW$iv.getClass()).getSimpleName();
            boolean $i$f$logW2 = false;
            Log log = Log.INSTANCE;
            Log.Level level = Log.Level.WARN;
            String tag$iv$iv$iv = tag$iv$iv;
            boolean $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                String string = tag$iv$iv$iv;
                void var11_10 = level$iv$iv$iv;
                LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string2 = "Component " + this.getComponentType() + " destroyed multiple times (entity: " + this.gameEntity.getName() + ")";
                logPrinter.print((Log.Level)var11_10, string, string2);
            }
        }
        this.setLifecycle(EntityLifecycle.DESTROYED);
    }

    public void onStart() {
        this.setLifecycle(EntityLifecycle.RUNNING);
    }

    public void onUpdate(@NotNull RenderPass.UpdateEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
    }

    public void onPhysicsUpdate(float timeStep) {
    }

    protected final void dependsOn(@NotNull KClass<?> componentType, boolean isOptional) {
        Intrinsics.checkNotNullParameter(componentType, (String)"componentType");
        ((Collection)this._dependencies).add(new ComponentDependency(componentType, isOptional));
    }

    public static /* synthetic */ void dependsOn$default(GameEntityComponent gameEntityComponent, KClass kClass, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dependsOn");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        gameEntityComponent.dependsOn(kClass, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean areDependenciesMetBy(@NotNull List<? extends GameEntityComponent> components) {
        boolean bl;
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Iterable $this$all$iv = this.getDependencies();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            ComponentDependency dep = (ComponentDependency)element$iv;
            boolean bl2 = false;
            if (!dep.isOptional()) {
                GameEntityComponent s;
                Iterable $this$any$iv = components;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object element$iv2 = iterator2.next();
                    s = (GameEntityComponent)element$iv2;
                    boolean bl3 = false;
                } while (!dep.getType().isInstance((Object)s));
                boolean bl4 = true;
                if (!bl4) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fabmax/kool/editor/components/GameEntityComponent$Companion;", "", "<init>", "()V", "COMPONENT_ORDER_EARLY", "", "COMPONENT_ORDER_DEFAULT", "COMPONENT_ORDER_LATE", "kool-editor-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lde/fabmax/kool/editor/components/GameEntityComponent$ComponentDependency;", "", "type", "Lkotlin/reflect/KClass;", "isOptional", "", "<init>", "(Lkotlin/reflect/KClass;Z)V", "getType", "()Lkotlin/reflect/KClass;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "kool-editor-model"})
    public static final class ComponentDependency {
        @NotNull
        private final KClass<?> type;
        private final boolean isOptional;

        public ComponentDependency(@NotNull KClass<?> type, boolean isOptional) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.type = type;
            this.isOptional = isOptional;
        }

        @NotNull
        public final KClass<?> getType() {
            return this.type;
        }

        public final boolean isOptional() {
            return this.isOptional;
        }

        @NotNull
        public final KClass<?> component1() {
            return this.type;
        }

        public final boolean component2() {
            return this.isOptional;
        }

        @NotNull
        public final ComponentDependency copy(@NotNull KClass<?> type, boolean isOptional) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            return new ComponentDependency(type, isOptional);
        }

        public static /* synthetic */ ComponentDependency copy$default(ComponentDependency componentDependency, KClass kClass, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                kClass = componentDependency.type;
            }
            if ((n & 2) != 0) {
                bl = componentDependency.isOptional;
            }
            return componentDependency.copy(kClass, bl);
        }

        @NotNull
        public String toString() {
            return "ComponentDependency(type=" + this.type + ", isOptional=" + this.isOptional + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Boolean.hashCode(this.isOptional);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentDependency)) {
                return false;
            }
            ComponentDependency componentDependency = (ComponentDependency)other;
            if (!Intrinsics.areEqual(this.type, componentDependency.type)) {
                return false;
            }
            return this.isOptional == componentDependency.isOptional;
        }
    }
}

