/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.editor.api;

import de.fabmax.kool.editor.api.CachedSceneComponents;
import de.fabmax.kool.editor.api.EditorScene;
import de.fabmax.kool.editor.api.EditorSceneKt;
import de.fabmax.kool.editor.api.GameEntity;
import de.fabmax.kool.editor.components.MeshComponent;
import de.fabmax.kool.editor.components.TransformComponentKt;
import de.fabmax.kool.input.Pointer;
import de.fabmax.kool.math.Mat4Kt;
import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MutableVec3d;
import de.fabmax.kool.math.RayD;
import de.fabmax.kool.math.RayF;
import de.fabmax.kool.math.RayKt;
import de.fabmax.kool.math.RayTest;
import de.fabmax.kool.math.Vec3Kt;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.scene.Mesh;
import de.fabmax.kool.scene.Node;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0012J\u0014\u0010\u001a\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/fabmax/kool/editor/api/SceneHitTest;", "", "scene", "Lde/fabmax/kool/editor/api/EditorScene;", "<init>", "(Lde/fabmax/kool/editor/api/EditorScene;)V", "getScene", "()Lde/fabmax/kool/editor/api/EditorScene;", "meshComponents", "", "Lde/fabmax/kool/editor/components/MeshComponent;", "getMeshComponents", "()Ljava/util/List;", "meshComponents$delegate", "Lde/fabmax/kool/editor/api/CachedSceneComponents;", "tmpHitVec", "Lde/fabmax/kool/math/MutableVec3d;", "localRayTest", "Lde/fabmax/kool/math/RayTest;", "computePickRay", "", "pointer", "Lde/fabmax/kool/input/Pointer;", "result", "Lde/fabmax/kool/math/RayF;", "Lde/fabmax/kool/math/RayD;", "hitTest", "Lde/fabmax/kool/editor/api/GameEntity;", "rayTest", "kool-editor-model"})
public final class SceneHitTest {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final EditorScene scene;
    @NotNull
    private final CachedSceneComponents meshComponents$delegate;
    @NotNull
    private final MutableVec3d tmpHitVec;
    @NotNull
    private final RayTest localRayTest;

    public SceneHitTest(@NotNull EditorScene scene) {
        Intrinsics.checkNotNullParameter((Object)((Object)scene), (String)"scene");
        this.scene = scene;
        this.meshComponents$delegate = new CachedSceneComponents(this.scene, Reflection.getOrCreateKotlinClass(MeshComponent.class));
        this.tmpHitVec = new MutableVec3d();
        this.localRayTest = new RayTest(false, 1, null);
    }

    @NotNull
    public final EditorScene getScene() {
        return this.scene;
    }

    private final List<MeshComponent> getMeshComponents() {
        return this.meshComponents$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final boolean computePickRay(@NotNull Pointer pointer, @NotNull RayF result) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return EditorSceneKt.getScene(this.scene).computePickRay(pointer, result);
    }

    public final boolean computePickRay(@NotNull Pointer pointer, @NotNull RayD result) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return EditorSceneKt.getScene(this.scene).computePickRay(pointer, result);
    }

    @Nullable
    public final GameEntity hitTest(@NotNull RayTest rayTest) {
        Intrinsics.checkNotNullParameter((Object)rayTest, (String)"rayTest");
        GameEntity hitEntity = null;
        List<MeshComponent> meshes = this.getMeshComponents();
        int n = ((Collection)meshes).size();
        for (int i = 0; i < n; ++i) {
            MeshComponent mesh = meshes.get(i);
            if (!mesh.getGameEntity().isVisible() || !this.hitTest(mesh, rayTest)) continue;
            hitEntity = mesh.getGameEntity();
        }
        return hitEntity;
    }

    private final boolean hitTest(MeshComponent $this$hitTest, RayTest rayTest) {
        double dGlobal;
        Node node = $this$hitTest.getSceneNode();
        if (node == null) {
            return false;
        }
        Node node2 = node;
        RayF localRay = rayTest.getRayTransformed(TransformComponentKt.getViewToLocalD($this$hitTest.getGameEntity()));
        float hitDistSqr = node2.getBounds().hitDistanceSqr(localRay);
        if (hitDistSqr < Float.POSITIVE_INFINITY && (dGlobal = TransformComponentKt.getLocalToGlobalD($this$hitTest.getGameEntity()).transform(Vec3Kt.set((MutableVec3d)this.tmpHitVec, (Vec3f)((Vec3f)localRay.getDirection())).mul(Math.sqrt(hitDistSqr)), 0.0).length()) < rayTest.getHitDistance()) {
            RayTest.clear$default((RayTest)this.localRayTest, (double)0.0, null, (int)3, null);
            RayKt.toRayD((RayF)localRay, (RayD)this.localRayTest.getRay());
            if (node2 instanceof Mesh) {
                ((Mesh)node2).rayTestLocal(this.localRayTest, localRay);
            } else {
                node2.rayTest(this.localRayTest);
            }
            if (this.localRayTest.isHit()) {
                double dist = Mat4Kt.transform((Mat4f)TransformComponentKt.getLocalToGlobalF($this$hitTest.getGameEntity()), (MutableVec3d)Vec3Kt.set((MutableVec3d)this.tmpHitVec, (Vec3f)((Vec3f)localRay.getDirection())).mul(this.localRayTest.getHitDistance()), (double)0.0).length();
                RayTest.setHit$default((RayTest)rayTest, (Node)node2, (double)dist, null, (int)4, null);
                return true;
            }
        }
        return false;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SceneHitTest.class, "meshComponents", "getMeshComponents()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

