/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.editor.api;

import de.fabmax.kool.editor.api.EditorProject;
import de.fabmax.kool.editor.api.EditorScene;
import de.fabmax.kool.editor.api.GameEntity;
import de.fabmax.kool.editor.components.GameEntityComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0086\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lde/fabmax/kool/editor/api/CachedProjectComponents;", "T", "", "project", "Lde/fabmax/kool/editor/api/EditorProject;", "componentClass", "Lkotlin/reflect/KClass;", "<init>", "(Lde/fabmax/kool/editor/api/EditorProject;Lkotlin/reflect/KClass;)V", "getProject", "()Lde/fabmax/kool/editor/api/EditorProject;", "getComponentClass", "()Lkotlin/reflect/KClass;", "sceneModCnt", "", "materialModCnt", "sceneModCnts", "", "cache", "", "isOutdated", "", "()Z", "getValue", "", "thisRef", "property", "Lkotlin/reflect/KProperty;", "getComponents", "kool-editor-model"})
@SourceDebugExtension(value={"SMAP\nCachedComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedComponents.kt\nde/fabmax/kool/editor/api/CachedProjectComponents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1878#2,3:132\n1869#2:135\n774#2:137\n865#2,2:138\n1869#2,2:140\n1870#2:142\n774#2:143\n865#2,2:144\n1869#2,2:146\n774#2:148\n865#2,2:149\n1#3:136\n*S KotlinDebug\n*F\n+ 1 CachedComponents.kt\nde/fabmax/kool/editor/api/CachedProjectComponents\n*L\n77#1:132,3\n92#1:135\n98#1:137\n98#1:138,2\n99#1:140,2\n92#1:142\n102#1:143\n102#1:144,2\n103#1:146,2\n94#1:148\n94#1:149,2\n*E\n"})
public final class CachedProjectComponents<T> {
    @NotNull
    private final EditorProject project;
    @NotNull
    private final KClass<T> componentClass;
    private int sceneModCnt;
    private int materialModCnt;
    @NotNull
    private int[] sceneModCnts;
    @NotNull
    private final List<T> cache;

    public CachedProjectComponents(@NotNull EditorProject project, @NotNull KClass<T> componentClass) {
        Intrinsics.checkNotNullParameter((Object)((Object)project), (String)"project");
        Intrinsics.checkNotNullParameter(componentClass, (String)"componentClass");
        this.project = project;
        this.componentClass = componentClass;
        this.sceneModCnt = -1;
        this.materialModCnt = -1;
        this.sceneModCnts = new int[0];
        this.cache = new ArrayList();
    }

    @NotNull
    public final EditorProject getProject() {
        return this.project;
    }

    @NotNull
    public final KClass<T> getComponentClass() {
        return this.componentClass;
    }

    public final boolean isOutdated() {
        boolean isDirty = false;
        int numScenes = this.project.getCreatedScenes().size();
        if (this.sceneModCnts.length != numScenes) {
            int n = 0;
            int[] nArray = new int[numScenes];
            CachedProjectComponents cachedProjectComponents = this;
            while (n < numScenes) {
                int n2 = n++;
                nArray[n2] = -1;
            }
            cachedProjectComponents.sceneModCnts = nArray;
            isDirty = true;
        }
        if (this.project.getSceneModCnt() != this.sceneModCnt) {
            isDirty = true;
        }
        if (this.materialModCnt != this.project.getMaterialScene().getComponentModCnt()) {
            isDirty = false;
            this.materialModCnt = this.project.getMaterialScene().getComponentModCnt();
        }
        List scenes = CollectionsKt.toList((Iterable)this.project.getCreatedScenes().values());
        Iterable $this$forEachIndexed$iv = this.project.getCreatedScenes().values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EditorScene editorScene = (EditorScene)((Object)item$iv);
            int i = n;
            boolean bl = false;
            if (this.sceneModCnts[i] != ((EditorScene)((Object)scenes.get(i))).getComponentModCnt()) {
                isDirty = true;
            }
            this.sceneModCnts[i] = ((EditorScene)((Object)scenes.get(i))).getComponentModCnt();
        }
        return isDirty;
    }

    @NotNull
    public final List<T> getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.getComponents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> getComponents() {
        if (this.isOutdated()) {
            void $this$filterTo$iv$iv;
            this.cache.clear();
            List allScenes = CollectionsKt.plus(this.project.getCreatedScenes().values(), (Object)((Object)this.project.getMaterialScene()));
            Iterable $this$forEach$iv = allScenes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                Iterator $this$filterTo$iv$iv2;
                Iterable $this$filter$iv;
                Object object;
                EditorScene scene = (EditorScene)((Object)element$iv);
                boolean bl = false;
                Sequence it = object = SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)scene.getOrderedEntities()), arg_0 -> CachedProjectComponents.getComponents$lambda$0$0(this, arg_0)), arg_0 -> CachedProjectComponents.getComponents$lambda$0$1(this, arg_0));
                boolean $i$a$-also-CachedProjectComponents$getComponents$1$42 = false;
                CollectionsKt.addAll((Collection)this.cache, (Sequence)it);
                object = scene.getListenerComponents();
                boolean $i$f$filter = false;
                void $i$a$-also-CachedProjectComponents$getComponents$1$42 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv;
                    Object c = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    if (!this.componentClass.isInstance(c)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                $this$filterTo$iv$iv2 = $this$forEach$iv2.iterator();
                while ($this$filterTo$iv$iv2.hasNext()) {
                    Object element$iv2;
                    Object it2 = element$iv2 = $this$filterTo$iv$iv2.next();
                    boolean bl3 = false;
                    this.cache.add(KClasses.cast(this.componentClass, it2));
                }
            }
            Iterable $this$filter$iv = this.project.getListenerComponents();
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator bl = $this$filterTo$iv$iv.iterator();
            while (bl.hasNext()) {
                Object element$iv$iv;
                Object c = element$iv$iv = bl.next();
                boolean bl4 = false;
                if (!this.componentClass.isInstance(c)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl5 = false;
                this.cache.add(KClasses.cast(this.componentClass, it));
            }
        }
        return this.cache;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getComponents$lambda$0$0(CachedProjectComponents this$0, GameEntity it) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$filter$iv = it.getComponents();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GameEntityComponent c = (GameEntityComponent)element$iv$iv;
            boolean bl = false;
            if (!this$0.componentClass.isInstance((Object)c)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Object getComponents$lambda$0$1(CachedProjectComponents this$0, GameEntityComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KClasses.cast(this$0.componentClass, (Object)it);
    }
}

