/*
 * Copyright (c) 2014. Escalon System-Entwicklung, Dietrich Schulten
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for
 * the specific language governing permissions and limitations under the License.
 */

package de.escalon.hypermedia.hydra.serialize;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

import java.io.IOException;

/**
 * Created by dschulten on 24.09.2014.
 */
public class EnumSerializer extends StdScalarSerializer<Enum<?>> {

    protected EnumSerializer() {
        super(Enum.class, true);
    }

    @Override
    public void serialize(Enum<?> value, JsonGenerator jgen,
                          SerializerProvider provider) throws IOException, JsonGenerationException {
        if (value != null) {
            jgen.writeString(value.name());
        }
    }
}
