/*
 * Decompiled with CFR 0.152.
 */
package de.escalon.hypermedia.hydra.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.BeanAsArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;
import de.escalon.hypermedia.AnnotationUtils;
import de.escalon.hypermedia.hydra.mapping.Expose;
import de.escalon.hypermedia.hydra.serialize.JacksonMixinSource;
import de.escalon.hypermedia.hydra.serialize.LdContext;
import de.escalon.hypermedia.hydra.serialize.LdContextFactory;
import de.escalon.hypermedia.hydra.serialize.ProxyUnwrapper;
import de.escalon.hypermedia.hydra.serialize.UnwrappingJacksonHydraSerializer;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

public class JacksonHydraSerializer
extends BeanSerializerBase {
    public static final String KEY_LD_CONTEXT = "de.escalon.hypermedia.ld-context";
    protected LdContextFactory ldContextFactory;
    private ProxyUnwrapper proxyUnwrapper;

    public JacksonHydraSerializer(BeanSerializerBase source) {
        this(source, (ProxyUnwrapper)null);
    }

    public JacksonHydraSerializer(BeanSerializerBase source, ProxyUnwrapper proxyUnwrapper) {
        super(source);
        this.proxyUnwrapper = proxyUnwrapper;
        this.ldContextFactory = new LdContextFactory();
        this.ldContextFactory.setProxyUnwrapper(proxyUnwrapper);
    }

    public JacksonHydraSerializer(BeanSerializerBase source, ObjectIdWriter objectIdWriter) {
        super(source, objectIdWriter);
    }

    public JacksonHydraSerializer(BeanSerializerBase source, String[] toIgnore) {
        super(source, toIgnore);
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new JacksonHydraSerializer((BeanSerializerBase)this, objectIdWriter);
    }

    protected BeanSerializerBase withIgnorals(String[] toIgnore) {
        return new JacksonHydraSerializer((BeanSerializerBase)this, toIgnore);
    }

    protected BeanSerializerBase asArraySerializer() {
        if (this._objectIdWriter == null && this._anyGetterWriter == null && this._propertyFilterId == null) {
            return new BeanAsArraySerializer((BeanSerializerBase)this);
        }
        return this;
    }

    protected BeanSerializerBase withFilterId(Object filterId) {
        JacksonHydraSerializer ret = new JacksonHydraSerializer(this);
        ret.withFilterId(filterId);
        return ret;
    }

    public void serialize(Object bean, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        Deque<LdContext> contextStack;
        if (!this.isUnwrappingSerializer()) {
            jgen.writeStartObject();
        }
        if ((contextStack = (ArrayDeque<LdContext>)serializerProvider.getAttribute((Object)KEY_LD_CONTEXT)) == null) {
            contextStack = new ArrayDeque<LdContext>();
            serializerProvider.setAttribute((Object)KEY_LD_CONTEXT, contextStack);
        }
        this.serializeContext(bean, jgen, serializerProvider, contextStack);
        this.serializeType(bean, jgen, serializerProvider);
        this.serializeFields(bean, jgen, serializerProvider);
        if (!this.isUnwrappingSerializer()) {
            jgen.writeEndObject();
        }
        if (!(contextStack = (Deque)serializerProvider.getAttribute((Object)KEY_LD_CONTEXT)).isEmpty()) {
            contextStack.pop();
        }
    }

    protected void serializeType(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (this.proxyUnwrapper != null) {
            bean = this.proxyUnwrapper.unwrapProxy(bean);
        }
        Expose classExpose = (Expose)AnnotationUtils.getAnnotation(bean.getClass(), Expose.class);
        Class mixin = provider.getConfig().findMixInClassFor(bean.getClass());
        Expose mixinExpose = (Expose)AnnotationUtils.getAnnotation((AnnotatedElement)mixin, Expose.class);
        String val = mixinExpose != null ? mixinExpose.value() : (classExpose != null ? classExpose.value() : bean.getClass().getSimpleName());
        jgen.writeStringField("@type", val);
    }

    protected void serializeContext(Object bean, JsonGenerator jgen, SerializerProvider serializerProvider, Deque<LdContext> contextStack) throws IOException {
        if (this.proxyUnwrapper != null) {
            bean = this.proxyUnwrapper.unwrapProxy(bean);
        }
        JacksonMixinSource mixinSource = new JacksonMixinSource(serializerProvider.getConfig());
        Class<?> mixInClass = mixinSource.findMixInClassFor(bean.getClass());
        LdContext parentContext = contextStack.peek();
        LdContext currentContext = new LdContext(parentContext, this.ldContextFactory.getVocab(mixinSource, bean, mixInClass), this.ldContextFactory.getTerms(mixinSource, bean, mixInClass));
        contextStack.push(currentContext);
        boolean mustWriteContext = parentContext == null || !parentContext.contains(currentContext);
        if (mustWriteContext) {
            jgen.writeObjectFieldStart("@context");
            if (parentContext == null || parentContext.vocab == null || currentContext.vocab != null && !currentContext.vocab.equals(parentContext.vocab)) {
                jgen.writeStringField("@vocab", currentContext.vocab);
            }
            for (Map.Entry<String, Object> termEntry : currentContext.terms.entrySet()) {
                if (termEntry.getValue() instanceof String) {
                    jgen.writeStringField(termEntry.getKey(), termEntry.getValue().toString());
                    continue;
                }
                jgen.writeObjectField(termEntry.getKey(), termEntry.getValue());
            }
            jgen.writeEndObject();
        }
    }

    public JsonSerializer<Object> unwrappingSerializer(NameTransformer unwrapper) {
        UnwrappingJacksonHydraSerializer unwrappingJacksonHydraSerializer = new UnwrappingJacksonHydraSerializer((BeanSerializerBase)this, this.proxyUnwrapper);
        return unwrappingJacksonHydraSerializer;
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        super.resolve(provider);
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        return super.createContextual(provider, property);
    }
}

