/*
 * Decompiled with CFR 0.152.
 */
package de.escalon.hypermedia.hydra.serialize;

import de.escalon.hypermedia.AnnotationUtils;
import de.escalon.hypermedia.hydra.mapping.ContextProvider;
import de.escalon.hypermedia.hydra.mapping.Expose;
import de.escalon.hypermedia.hydra.mapping.Term;
import de.escalon.hypermedia.hydra.mapping.Terms;
import de.escalon.hypermedia.hydra.mapping.Vocab;
import de.escalon.hypermedia.hydra.serialize.MixinSource;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;

public class LdContextFactory {
    public static final String HTTP_SCHEMA_ORG = "http://schema.org/";

    public String getVocab(MixinSource mixinSource, Object bean, Class<?> mixInClass) {
        String classVocab = this.vocabFromClass(bean.getClass(), HTTP_SCHEMA_ORG);
        Vocab mixinVocab = (Vocab)AnnotationUtils.getAnnotation(mixInClass, Vocab.class);
        Object nestedContextProviderFromMixin = this.getNestedContextProviderFromMixin(mixinSource, bean, mixInClass);
        String contextProviderVocab = null;
        if (nestedContextProviderFromMixin != null) {
            contextProviderVocab = this.getVocab(mixinSource, nestedContextProviderFromMixin, null);
        }
        String vocab = mixinVocab != null ? mixinVocab.value() : (classVocab != null ? classVocab : (contextProviderVocab != null ? contextProviderVocab : HTTP_SCHEMA_ORG));
        return vocab;
    }

    public Map<String, Object> getTerms(MixinSource mixinSource, Object bean, Class<?> mixInClass) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            Field[] fields;
            Class<?> beanClass = bean.getClass();
            Map<String, Object> termsMap = this.termsFromClass(beanClass);
            Map<String, Object> mixinTermsMap = this.getAnnotatedTerms(mixInClass, beanClass.getName());
            termsMap.putAll(mixinTermsMap);
            Object nestedContextProviderFromMixin = this.getNestedContextProviderFromMixin(mixinSource, bean, mixInClass);
            if (nestedContextProviderFromMixin != null) {
                termsMap.putAll(this.getTerms(mixinSource, nestedContextProviderFromMixin, null));
            }
            for (Field field : fields = beanClass.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers())) continue;
                Expose expose = field.getAnnotation(Expose.class);
                if (Enum.class.isAssignableFrom(field.getType())) {
                    this.addEnumTerms(termsMap, expose, field.getName(), (Enum)field.get(bean));
                    continue;
                }
                if (expose == null) continue;
                termsMap.put(field.getName(), expose.value());
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method method = propertyDescriptor.getReadMethod();
                if (method == null) continue;
                Expose expose = method.getAnnotation(Expose.class);
                if (Enum.class.isAssignableFrom(method.getReturnType())) {
                    this.addEnumTerms(termsMap, expose, propertyDescriptor.getName(), (Enum)method.invoke(bean, new Object[0]));
                    continue;
                }
                if (expose == null) continue;
                termsMap.put(propertyDescriptor.getName(), expose.value());
            }
            return termsMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> getAnnotatedTerms(AnnotatedElement annotatedElement, String name) {
        Terms annotatedTerms = (Terms)AnnotationUtils.getAnnotation((AnnotatedElement)annotatedElement, Terms.class);
        Term annotatedTerm = (Term)AnnotationUtils.getAnnotation((AnnotatedElement)annotatedElement, Term.class);
        if (annotatedTerms != null && annotatedTerm != null) {
            throw new IllegalStateException("found both @Terms and @Term in " + name + ", use either one or the other");
        }
        LinkedHashMap<String, Object> annotatedTermsMap = new LinkedHashMap<String, Object>();
        if (annotatedTerms != null) {
            Term[] terms;
            for (Term term : terms = annotatedTerms.value()) {
                String define = term.define();
                String as = term.as();
                boolean reverse = term.reverse();
                if (annotatedTermsMap.containsKey(as)) {
                    throw new IllegalStateException("duplicate definition of term '" + define + "' in " + name);
                }
                if (!reverse) {
                    annotatedTermsMap.put(define, as);
                    continue;
                }
                LinkedHashMap<String, String> reverseTerm = new LinkedHashMap<String, String>();
                reverseTerm.put("@reverse", as);
                annotatedTermsMap.put(define, reverseTerm);
            }
        }
        if (annotatedTerm != null) {
            annotatedTermsMap.put(annotatedTerm.define(), annotatedTerm.as());
        }
        return annotatedTermsMap;
    }

    private Object getNestedContextProviderFromMixin(MixinSource mixinSource, Object bean, Class<?> mixinClass) {
        if (mixinClass == null) {
            return null;
        }
        try {
            Method mixinContextProvider = this.getContextProvider(mixinClass);
            if (mixinContextProvider == null) {
                return null;
            }
            Class<?> beanClass = bean.getClass();
            Object contextual = beanClass.getMethod(mixinContextProvider.getName(), new Class[0]).invoke(bean, new Object[0]);
            Object ret = null;
            if (contextual instanceof Collection) {
                Collection collection = (Collection)contextual;
                if (!collection.isEmpty()) {
                    Object item = collection.iterator().next();
                    Class<?> mixInClass = mixinSource.findMixInClassFor(item.getClass());
                    ret = mixInClass == null ? item : this.getNestedContextProviderFromMixin(mixinSource, item, mixInClass);
                }
            } else if (contextual instanceof Map) {
                Map map = (Map)contextual;
                if (!map.isEmpty()) {
                    Object item = map.values().iterator().next();
                    Class<?> mixInClass = mixinSource.findMixInClassFor(item.getClass());
                    ret = mixInClass == null ? item : this.getNestedContextProviderFromMixin(mixinSource, item, mixInClass);
                }
            } else {
                ret = contextual;
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Method getContextProvider(Class<?> beanClass) {
        Class<ContextProvider> annotation = ContextProvider.class;
        Method contextProvider = AnnotationUtils.getAnnotatedMethod(beanClass, annotation);
        if (contextProvider.getParameterTypes().length > 0) {
            throw new IllegalStateException("the context provider method " + contextProvider.getName() + " must not have arguments");
        }
        return contextProvider;
    }

    private void addEnumTerms(Map<String, Object> termsMap, Expose expose, String name, Enum value) throws NoSuchFieldException {
        if (value != null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            if (expose != null) {
                map.put("@id", expose.value());
            }
            map.put("@type", "@vocab");
            termsMap.put(name, map);
            Expose enumValueExpose = (Expose)AnnotationUtils.getAnnotation((AnnotatedElement)value.getClass().getField(value.name()), Expose.class);
            if (enumValueExpose != null) {
                termsMap.put(value.toString(), enumValueExpose.value());
            } else {
                String camelCaseEnumValue = WordUtils.capitalizeFully((String)value.toString(), (char[])new char[]{'_'}).replaceAll("_", "");
                termsMap.put(value.toString(), camelCaseEnumValue);
            }
        }
    }

    public String vocabFromClass(Class<?> clazz, String defaultVocab) {
        Vocab packageVocab = (Vocab)AnnotationUtils.getAnnotation((AnnotatedElement)clazz.getPackage(), Vocab.class);
        Vocab classVocab = (Vocab)AnnotationUtils.getAnnotation(clazz, Vocab.class);
        String vocab = classVocab != null ? classVocab.value() : (packageVocab != null ? packageVocab.value() : defaultVocab);
        return vocab;
    }

    public Map<String, Object> termsFromClass(Class<?> clazz) {
        Map<String, Object> termsMap = this.getAnnotatedTerms(clazz.getPackage(), clazz.getPackage().getName());
        Map<String, Object> classTermsMap = this.getAnnotatedTerms(clazz, clazz.getName());
        termsMap.putAll(classTermsMap);
        return termsMap;
    }
}

