/*
 * Decompiled with CFR 0.152.
 */
package de.escalon.hypermedia.hydra.serialize;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class LdContext {
    private LdContext parentContext;
    public final String vocab;
    public final Map<String, Object> terms;

    public LdContext(LdContext parentContext, String vocab, Map<String, Object> terms) {
        this.parentContext = parentContext;
        this.vocab = vocab;
        this.terms = Collections.unmodifiableMap(terms);
    }

    public boolean contains(LdContext otherContext) {
        boolean ret = !this.hasSameVocabAs(otherContext) ? false : this.hasTermsOf(otherContext);
        return ret;
    }

    private boolean hasSameVocabAs(LdContext otherContext) {
        boolean ret = this.vocab == null ? (this.parentContext == null ? false : this.parentContext.hasSameVocabAs(otherContext)) : this.vocab.equals(otherContext.vocab);
        return ret;
    }

    private boolean hasTermsOf(LdContext otherContext) {
        String otherTerm;
        boolean ret = true;
        Iterator<String> iterator = otherContext.terms.keySet().iterator();
        while (iterator.hasNext() && (ret = this.hasEqualTerm(otherTerm = iterator.next(), otherContext.terms.get(otherTerm)))) {
        }
        return ret;
    }

    private boolean hasEqualTerm(String term, Object value) {
        boolean ret = this.terms.containsKey(term) ? this.terms.get(term).equals(value) : (this.parentContext == null ? false : this.parentContext.hasEqualTerm(term, value));
        return ret;
    }
}

