/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.wiremock.request.body;

import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import de.eosts.pactstubs.wiremock.request.body.RequestBodyPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberTypePattern
implements RequestBodyPattern<NumberTypeMatcher> {
    private static final Logger log = LoggerFactory.getLogger(NumberTypePattern.class);

    @Override
    public MatchesJsonPathPattern from(String jsonPath, NumberTypeMatcher matchingRule) {
        log.info("NumberType (matched via MatchesJsonPathPattern + RegexPattern) cannot verify type, i.e. 1 and \"1\" will match as integer");
        String regex = null;
        switch (matchingRule.getNumberType()) {
            case NUMBER: {
                regex = "^(\\d+(\\.\\d+)?)$";
                break;
            }
            case INTEGER: {
                regex = "^(\\d)$";
                break;
            }
            case DECIMAL: {
                regex = "^(\\d+\\.\\d+)$";
            }
        }
        return new MatchesJsonPathPattern(jsonPath, (StringValuePattern)new RegexPattern(regex));
    }
}

