/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.wiremock.request;

import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.matchingrules.MaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinMaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinTypeMatcher;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import de.eosts.pactstubs.wiremock.request.Pact2WireMockRequestPattern;
import de.eosts.pactstubs.wiremock.request.body.RequestBodyPatternFromMatchingRuleFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyPattern
implements Pact2WireMockRequestPattern {
    private static final Logger log = LoggerFactory.getLogger(BodyPattern.class);

    @Override
    public void accept(Request pactRequest, RequestPatternBuilder requestPatternBuilder) {
        OptionalBody body = pactRequest.getBody();
        if (body.isPresent()) {
            Map bodyRules = pactRequest.getMatchingRules().rulesForCategory("body").getMatchingRules();
            if (!bodyRules.isEmpty()) {
                DocumentContext documentContext = JsonPath.parse((String)new String(body.unwrap()));
                bodyRules.forEach((jsonPath, matchingRuleGroup) -> {
                    List rules = matchingRuleGroup.getRules();
                    rules.forEach(matchingRule -> {
                        requestPatternBuilder.withRequestBody(RequestBodyPatternFromMatchingRuleFactory.getInstance(jsonPath, matchingRule));
                        if (!(matchingRule instanceof MinTypeMatcher || matchingRule instanceof MaxTypeMatcher || matchingRule instanceof MinMaxTypeMatcher)) {
                            try {
                                documentContext.delete(jsonPath, new Predicate[0]);
                            }
                            catch (PathNotFoundException exception) {
                                log.info("Path not found for json path {}, should be ok assuming this is part of a nested array rule", jsonPath);
                            }
                        }
                    });
                });
                this.addStaticElementsToRequestPattern(requestPatternBuilder, documentContext);
            } else {
                requestPatternBuilder.withRequestBody((ContentPattern)new EqualToJsonPattern(new String(body.unwrap()), Boolean.valueOf(true), Boolean.valueOf(true)));
            }
        }
    }

    private void addStaticElementsToRequestPattern(RequestPatternBuilder requestPatternBuilder, DocumentContext documentContext) {
        Object json = documentContext.json();
        if (json instanceof Collection) {
            Collection asCollection = (Collection)json;
            BodyPattern.deepRemoveEmptyCollections(asCollection);
            if (!asCollection.isEmpty()) {
                requestPatternBuilder.withRequestBody((ContentPattern)new EqualToJsonPattern(documentContext.jsonString(), Boolean.valueOf(true), Boolean.valueOf(true)));
            }
        } else if (json instanceof Map) {
            Map asMap = (Map)json;
            BodyPattern.deepRemoveEmptyCollections(asMap.entrySet());
            if (!asMap.isEmpty()) {
                requestPatternBuilder.withRequestBody((ContentPattern)new EqualToJsonPattern(documentContext.jsonString(), Boolean.valueOf(true), Boolean.valueOf(true)));
            }
        } else {
            requestPatternBuilder.withRequestBody((ContentPattern)new EqualToJsonPattern(documentContext.jsonString(), Boolean.valueOf(true), Boolean.valueOf(true)));
        }
    }

    private static void deepRemoveEmptyCollections(Collection collection) {
        collection.forEach(o -> {
            if (o instanceof Map.Entry) {
                o = ((Map.Entry)o).getValue();
            }
            if (o instanceof Map) {
                BodyPattern.deepRemoveEmptyCollections(((Map)o).entrySet());
            } else if (o instanceof Collection) {
                BodyPattern.deepRemoveEmptyCollections((Collection)o);
            }
        });
        collection.removeIf(o -> o instanceof Map.Entry && (((Map.Entry)o).getValue() instanceof Collection && ((Collection)((Map.Entry)o).getValue()).isEmpty() || ((Map.Entry)o).getValue() instanceof Map && ((Map)((Map.Entry)o).getValue()).isEmpty()) || o instanceof Collection && ((Collection)o).isEmpty() || o instanceof Map && ((Map)o).isEmpty());
    }
}

