/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.wiremock.response;

import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.provider.ComparisonResult;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import de.eosts.pactstubs.compare.PactResponseComparator;
import de.eosts.pactstubs.compare.ResponseComparator;
import de.eosts.pactstubs.compare.ResponseComparisonResult;
import de.eosts.pactstubs.jsonpath.JsonPathResponseConverter;
import de.eosts.pactstubs.jsonpath.JsonPathWriter;
import de.eosts.pactstubs.jsonpath.WriteContextOperator;
import java.util.ArrayList;
import java.util.Collection;

public class PactResponseConverter
implements JsonPathResponseConverter<Response, ResponseDefinition> {
    private final ResponseComparator<Response, String> responseComparator;
    private final JsonPathWriter jsonPathWriter;

    public PactResponseConverter() {
        this.responseComparator = new PactResponseComparator();
        this.jsonPathWriter = new JsonPathWriter();
    }

    public PactResponseConverter(ResponseComparator<Response, String> responseComparator) {
        this.responseComparator = responseComparator;
        this.jsonPathWriter = new JsonPathWriter();
    }

    public PactResponseConverter(JsonPathWriter jsonPathWriter) {
        this.responseComparator = new PactResponseComparator();
        this.jsonPathWriter = jsonPathWriter;
    }

    public PactResponseConverter(ResponseComparator<Response, String> responseComparator, JsonPathWriter jsonPathWriter) {
        this.responseComparator = responseComparator;
        this.jsonPathWriter = jsonPathWriter;
    }

    @Override
    public ResponseComparisonResult<ResponseDefinition> convert(Response response, WriteContextOperator ... operators) {
        ResponseDefinitionBuilder responseDefinitionBuilder = new ResponseDefinitionBuilder();
        ComparisonResult validationResult = null;
        if (response.getBody().isPresent()) {
            String bodyAsString = new String(response.getBody().getValue());
            if (operators.length > 0) {
                String convertedBody = this.jsonPathWriter.write(bodyAsString, operators);
                validationResult = this.responseComparator.compare(response, convertedBody);
                responseDefinitionBuilder.withBody(convertedBody);
            } else {
                responseDefinitionBuilder.withBody(bodyAsString);
            }
        }
        ArrayList headerList = new ArrayList();
        response.getHeaders().forEach((headerName, headerValue) -> headerList.add(new HttpHeader(headerName, (Collection)headerValue)));
        return new ResponseComparisonResult<ResponseDefinition>(responseDefinitionBuilder.withStatus(response.getStatus()).withHeaders(new HttpHeaders(headerList)).build(), validationResult);
    }
}

