/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.wiremock.request.body;

import au.com.dius.pact.core.model.matchingrules.DateMatcher;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinMaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.TimeMatcher;
import au.com.dius.pact.core.model.matchingrules.TimestampMatcher;
import au.com.dius.pact.core.model.matchingrules.TypeMatcher;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import de.eosts.pactstubs.wiremock.request.body.DatePattern;
import de.eosts.pactstubs.wiremock.request.body.MaxTypePattern;
import de.eosts.pactstubs.wiremock.request.body.MinMaxTypePattern;
import de.eosts.pactstubs.wiremock.request.body.MinTypePattern;
import de.eosts.pactstubs.wiremock.request.body.NumberTypePattern;
import de.eosts.pactstubs.wiremock.request.body.RegexPattern;
import de.eosts.pactstubs.wiremock.request.body.TimePattern;
import de.eosts.pactstubs.wiremock.request.body.TimestampPattern;
import de.eosts.pactstubs.wiremock.request.body.TypePattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBodyPatternFromMatchingRuleFactory {
    private static final Logger log = LoggerFactory.getLogger(RequestBodyPatternFromMatchingRuleFactory.class);

    private RequestBodyPatternFromMatchingRuleFactory() {
    }

    public static ContentPattern getInstance(String jsonPath, MatchingRule matchingRule) {
        if (matchingRule instanceof TypeMatcher) {
            return new TypePattern().from(jsonPath, (TypeMatcher)matchingRule);
        }
        if (matchingRule instanceof MinTypeMatcher) {
            return new MinTypePattern().from(jsonPath, (MinTypeMatcher)matchingRule);
        }
        if (matchingRule instanceof MaxTypeMatcher) {
            return new MaxTypePattern().from(jsonPath, (MaxTypeMatcher)matchingRule);
        }
        if (matchingRule instanceof MinMaxTypeMatcher) {
            return new MinMaxTypePattern().from(jsonPath, (MinMaxTypeMatcher)matchingRule);
        }
        if (matchingRule instanceof RegexMatcher) {
            return new RegexPattern().from(jsonPath, (RegexMatcher)matchingRule);
        }
        if (matchingRule instanceof NumberTypeMatcher) {
            return new NumberTypePattern().from(jsonPath, (NumberTypeMatcher)matchingRule);
        }
        if (matchingRule instanceof DateMatcher) {
            return new DatePattern().from(jsonPath, (DateMatcher)matchingRule);
        }
        if (matchingRule instanceof TimeMatcher) {
            return new TimePattern().from(jsonPath, (TimeMatcher)matchingRule);
        }
        if (matchingRule instanceof TimestampMatcher) {
            return new TimestampPattern().from(jsonPath, (TimestampMatcher)matchingRule);
        }
        log.warn("no support for matchingrule: {} Matching jsonPath only.", (Object)matchingRule);
        return new MatchesJsonPathPattern(jsonPath);
    }
}

