/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.wiremock.request;

import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleGroup;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import de.eosts.pactstubs.wiremock.request.Pact2WireMockRequestPattern;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPattern
implements Pact2WireMockRequestPattern {
    private static final Logger log = LoggerFactory.getLogger(QueryPattern.class);

    @Override
    public void accept(Request pactRequest, RequestPatternBuilder requestPatternBuilder) {
        Map query = pactRequest.getQuery();
        if (!query.isEmpty()) {
            Map queryRules = pactRequest.getMatchingRules().rulesForCategory("query").getMatchingRules();
            query.forEach((queryKey, queryValue) -> {
                if (queryRules.containsKey(queryKey)) {
                    MatchingRule rule = (MatchingRule)((MatchingRuleGroup)queryRules.get(queryKey)).getRules().get(0);
                    requestPatternBuilder.withQueryParam(queryKey, (StringValuePattern)new RegexPattern(((RegexMatcher)rule).getRegex()));
                } else {
                    requestPatternBuilder.withQueryParam(queryKey, (StringValuePattern)new EqualToPattern((String)queryValue.get(0)));
                    if (queryValue.size() > 1) {
                        log.warn("WireMock only supports a single value for the same query param. Found additional value: {}", queryValue.get(1));
                    }
                }
            });
        }
    }
}

