/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.wiremock.request;

import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import de.eosts.pactstubs.compare.PactRequestComparator;
import de.eosts.pactstubs.compare.RequestComparator;
import de.eosts.pactstubs.compare.RequestComparisonResult;
import de.eosts.pactstubs.spec.SpecificRequestSpec;
import de.eosts.pactstubs.wiremock.request.BodyPattern;
import de.eosts.pactstubs.wiremock.request.HeaderPattern;
import de.eosts.pactstubs.wiremock.request.Pact2WireMockRequestPattern;
import de.eosts.pactstubs.wiremock.request.QueryPattern;
import de.eosts.pactstubs.wiremock.request.SpecificJsonBodyPattern;
import de.eosts.pactstubs.wiremock.request.SpecificQueryPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Pact2WireMockRequestConverter {
    private final List<Pact2WireMockRequestPattern> pact2WireMockRequestPatterns = new ArrayList<Pact2WireMockRequestPattern>();
    private final RequestPatternBuilder requestPatternBuilder;
    private final RequestComparator requestComparator;
    private final Request request;
    private final SpecificRequestSpec specificRequestSpec;

    public Pact2WireMockRequestConverter(Request request) {
        this(request, SpecificRequestSpec.builder().build());
    }

    public Pact2WireMockRequestConverter(Request request, SpecificRequestSpec specificRequestSpec) {
        this(request, specificRequestSpec, new PactRequestComparator());
    }

    public Pact2WireMockRequestConverter(Request request, SpecificRequestSpec specificRequestSpec, RequestComparator requestComparator) {
        this(request, specificRequestSpec, requestComparator, new RequestPatternBuilder(RequestMethod.fromString((String)request.getMethod()), (UrlPattern)Pact2WireMockRequestConverter.getUrlPathPattern(request, specificRequestSpec)));
    }

    public Pact2WireMockRequestConverter(Request request, SpecificRequestSpec specificRequestSpec, RequestComparator requestComparator, RequestPatternBuilder requestPatternBuilder) {
        this.request = request;
        this.requestPatternBuilder = requestPatternBuilder;
        this.specificRequestSpec = specificRequestSpec;
        this.requestComparator = requestComparator;
        this.addDefaultPattern();
    }

    public Pact2WireMockRequestConverter(Request request, Pact2WireMockRequestPattern ... pact2WireMockRequestPatterns) {
        this(request, SpecificRequestSpec.builder().build(), (RequestComparator)new PactRequestComparator(), pact2WireMockRequestPatterns);
    }

    public Pact2WireMockRequestConverter(Request request, SpecificRequestSpec specificRequestSpec, RequestComparator requestComparator, Pact2WireMockRequestPattern ... pact2WireMockRequestPatterns) {
        this.request = request;
        this.specificRequestSpec = specificRequestSpec;
        this.requestPatternBuilder = new RequestPatternBuilder(RequestMethod.fromString((String)request.getMethod()), (UrlPattern)Pact2WireMockRequestConverter.getUrlPathPattern(request, specificRequestSpec));
        this.requestComparator = requestComparator;
        this.pact2WireMockRequestPatterns.addAll(Arrays.asList(pact2WireMockRequestPatterns));
    }

    public Pact2WireMockRequestConverter(Request request, SpecificRequestSpec specificRequestSpec, RequestComparator requestComparator, RequestPatternBuilder requestPatternBuilder, Pact2WireMockRequestPattern ... pact2WireMockRequestPatterns) {
        this.request = request;
        this.specificRequestSpec = specificRequestSpec;
        this.requestPatternBuilder = requestPatternBuilder;
        this.requestComparator = requestComparator;
        this.pact2WireMockRequestPatterns.addAll(Arrays.asList(pact2WireMockRequestPatterns));
    }

    private void addDefaultPattern() {
        this.pact2WireMockRequestPatterns.add(this.specificRequestSpec.getQueryParams().map(stringStringMap -> new SpecificQueryPattern((Map<String, String>)stringStringMap)).orElseGet(QueryPattern::new));
        this.pact2WireMockRequestPatterns.add(this.specificRequestSpec.getJsonBody().map(jsonBody -> new SpecificJsonBodyPattern((String)jsonBody)).orElseGet(BodyPattern::new));
        this.pact2WireMockRequestPatterns.add(new HeaderPattern());
    }

    public RequestComparisonResult convert() {
        return new RequestComparisonResult(this.requestPatternBuilder().build(), this.requestComparator.compare(this.request, this.specificRequestSpec));
    }

    public RequestPatternBuilder requestPatternBuilder() {
        this.pact2WireMockRequestPatterns.forEach(pact2WireMockRequestPattern -> pact2WireMockRequestPattern.accept(this.request, this.requestPatternBuilder));
        return this.requestPatternBuilder;
    }

    private static UrlPathPattern getUrlPathPattern(Request pactRequest, SpecificRequestSpec specificRequestSpec) {
        return specificRequestSpec.getUrlPath().map(WireMock::urlPathEqualTo).orElseGet(() -> {
            List pathRules = pactRequest.getMatchingRules().rulesForCategory("path").allMatchingRules();
            if (!pathRules.isEmpty()) {
                String pathRegex = ((RegexMatcher)pathRules.get(0)).getRegex();
                return WireMock.urlPathMatching((String)pathRegex);
            }
            return WireMock.urlPathEqualTo((String)pactRequest.getPath());
        });
    }
}

