/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.spec;

import java.util.Map;
import java.util.Optional;

public class SpecificRequestSpec {
    private final String urlPath;
    private final Map<String, String> queryParams;
    private final String jsonBody;

    SpecificRequestSpec(String urlPath, Map<String, String> queryParams, String jsonBody) {
        this.urlPath = urlPath;
        this.queryParams = queryParams;
        this.jsonBody = jsonBody;
    }

    public static SpecificRequestSpecBuilder builder() {
        return new SpecificRequestSpecBuilder();
    }

    public Optional<String> getUrlPath() {
        return Optional.ofNullable(this.urlPath);
    }

    public Optional<Map<String, String>> getQueryParams() {
        return Optional.ofNullable(this.queryParams);
    }

    public Optional<String> getJsonBody() {
        return Optional.ofNullable(this.jsonBody);
    }

    public static class SpecificRequestSpecBuilder {
        private String urlPath;
        private Map<String, String> queryParams;
        private String jsonBody;

        SpecificRequestSpecBuilder() {
        }

        public SpecificRequestSpecBuilder urlPath(String urlPath) {
            this.urlPath = urlPath;
            return this;
        }

        public SpecificRequestSpecBuilder queryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public SpecificRequestSpecBuilder jsonBody(String jsonBody) {
            this.jsonBody = jsonBody;
            return this;
        }

        public SpecificRequestSpec build() {
            return new SpecificRequestSpec(this.urlPath, this.queryParams, this.jsonBody);
        }
    }
}

