/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.spec;

import java.util.Objects;
import java.util.Optional;

public class InteractionIdentifier {
    private final String consumer;
    private final String provider;
    private final String description;
    private final String providerState;

    InteractionIdentifier(String consumer, String provider, String description, String providerState) {
        this.consumer = Objects.requireNonNull(consumer);
        this.provider = Objects.requireNonNull(provider);
        this.description = Objects.requireNonNull(description);
        this.providerState = providerState;
    }

    public static InteractionIdentifierBuilder builder() {
        return new InteractionIdentifierBuilder();
    }

    public String getConsumer() {
        return this.consumer;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<String> getProviderState() {
        return Optional.ofNullable(this.providerState);
    }

    public static class InteractionIdentifierBuilder {
        private String consumer;
        private String provider;
        private String description;
        private String providerState;

        InteractionIdentifierBuilder() {
        }

        public InteractionIdentifierBuilder consumer(String consumer) {
            this.consumer = consumer;
            return this;
        }

        public InteractionIdentifierBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public InteractionIdentifierBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InteractionIdentifierBuilder providerState(String providerState) {
            this.providerState = providerState;
            return this;
        }

        public InteractionIdentifier build() {
            return new InteractionIdentifier(this.consumer, this.provider, this.description, this.providerState);
        }
    }
}

