/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.message;

import au.com.dius.pact.core.model.messaging.Message;
import au.com.dius.pact.provider.ComparisonResult;
import de.eosts.pactstubs.compare.PactMessageComparator;
import de.eosts.pactstubs.compare.ResponseComparator;
import de.eosts.pactstubs.compare.ResponseComparisonResult;
import de.eosts.pactstubs.jsonpath.JsonPathResponseConverter;
import de.eosts.pactstubs.jsonpath.JsonPathWriter;
import de.eosts.pactstubs.jsonpath.WriteContextOperator;

public class PactMessageConverter
implements JsonPathResponseConverter<Message, String> {
    private final ResponseComparator<Message, String> messageResponseComparator;
    private final JsonPathWriter jsonPathWriter;

    public PactMessageConverter() {
        this.messageResponseComparator = new PactMessageComparator();
        this.jsonPathWriter = new JsonPathWriter();
    }

    public PactMessageConverter(ResponseComparator<Message, String> messageResponseComparator) {
        this.messageResponseComparator = messageResponseComparator;
        this.jsonPathWriter = new JsonPathWriter();
    }

    public PactMessageConverter(JsonPathWriter jsonPathWriter) {
        this.messageResponseComparator = new PactMessageComparator();
        this.jsonPathWriter = jsonPathWriter;
    }

    public PactMessageConverter(ResponseComparator<Message, String> messageResponseComparator, JsonPathWriter jsonPathWriter) {
        this.messageResponseComparator = messageResponseComparator;
        this.jsonPathWriter = jsonPathWriter;
    }

    @Override
    public ResponseComparisonResult<String> convert(Message interaction, WriteContextOperator ... operators) {
        String message;
        ComparisonResult validationResult = null;
        String pactContents = new String(interaction.getContents().getValue());
        if (operators.length > 0) {
            message = this.jsonPathWriter.write(pactContents, operators);
            validationResult = this.messageResponseComparator.compare(interaction, message);
        } else {
            message = pactContents;
        }
        return new ResponseComparisonResult<String>(message, validationResult);
    }
}

