/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.loader;

import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import de.eosts.pactstubs.loader.PactBrokerInteractionLoaderBuilder;
import de.eosts.pactstubs.loader.PactFolderInteractionLoaderBuilder;
import de.eosts.pactstubs.loader.PactInstanceInteractionLoaderBuilder;
import de.eosts.pactstubs.loader.PactUrlInteractionLoaderBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PactInteractionLoader {
    private final PactLoader pactLoader;
    private final Map<PactPair, List<Interaction>> loadedInteractions = new HashMap<PactPair, List<Interaction>>();

    public PactInteractionLoader(PactLoader pactLoader) {
        this.pactLoader = pactLoader;
    }

    public static PactBrokerInteractionLoaderBuilder pactBrokerBuilder() {
        return new PactBrokerInteractionLoaderBuilder();
    }

    public static PactFolderInteractionLoaderBuilder folderBuilder() {
        return new PactFolderInteractionLoaderBuilder();
    }

    public static PactUrlInteractionLoaderBuilder urlsBuilder() {
        return new PactUrlInteractionLoaderBuilder();
    }

    public static PactInstanceInteractionLoaderBuilder pactInstanceBuilder() {
        return new PactInstanceInteractionLoaderBuilder();
    }

    public Interaction getInteraction(String consumer, String provider, String description) {
        List<Interaction> interactions = this.getOrCreateLoadedInteractions(consumer, provider);
        return interactions.stream().filter(interaction -> interaction.getDescription().equals(description)).findAny().orElseThrow(IllegalStateException::new);
    }

    public Interaction getInteraction(String consumer, String provider, String description, String providerState) {
        List<Interaction> interactions = this.getOrCreateLoadedInteractions(consumer, provider);
        return interactions.stream().filter(interaction -> interaction.getDescription().equals(description) && interaction.getProviderStates().stream().anyMatch(interactionState -> interactionState.getName().equals(providerState))).findAny().orElseThrow(IllegalStateException::new);
    }

    private List<Interaction> getOrCreateLoadedInteractions(String consumer, String provider) {
        List interactions = this.loadedInteractions.get(new PactPair(consumer, provider));
        if (interactions == null) {
            try {
                interactions = this.pactLoader.load(provider).stream().filter(pact -> pact.getConsumer().getName().equals(consumer)).findAny().orElseThrow(() -> new IllegalStateException("No interactions found for consumer " + consumer + " and provider " + provider)).getInteractions();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.loadedInteractions.put(new PactPair(consumer, provider), interactions);
        }
        return interactions;
    }

    private static class PactPair {
        private final String consumer;
        private final String provider;

        public PactPair(String consumer, String provider) {
            this.consumer = consumer;
            this.provider = provider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PactPair pair = (PactPair)o;
            return Objects.equals(this.consumer, pair.consumer) && Objects.equals(this.provider, pair.provider);
        }

        public int hashCode() {
            return Objects.hash(this.consumer, this.provider);
        }
    }
}

