/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs.compare;

import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleGroup;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import de.eosts.pactstubs.compare.RequestComparator;
import de.eosts.pactstubs.spec.SpecificRequestSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PactRequestComparator
implements RequestComparator {
    @Override
    public Map<String, String> compare(Request pactRequest, SpecificRequestSpec specificRequestSpec) {
        HashMap<String, String> mismatches = new HashMap<String, String>();
        specificRequestSpec.getUrlPath().ifPresent(urlPath -> mismatches.putAll(this.getMismatchesForUrlPath(pactRequest, (String)urlPath)));
        specificRequestSpec.getQueryParams().ifPresent(queryParams -> mismatches.putAll(this.getMismatchesForQueryParams((Map<String, String>)queryParams, pactRequest)));
        return mismatches;
    }

    private Map<String, String> getMismatchesForQueryParams(Map<String, String> queryParams, Request pactRequest) {
        HashMap<String, String> mismatches = new HashMap<String, String>();
        Map queryRules = pactRequest.getMatchingRules().rulesForCategory("query").getMatchingRules();
        Map query = pactRequest.getQuery();
        if (!query.isEmpty()) {
            query.forEach((queryKey, queryValue) -> {
                String specificParamValue = (String)queryParams.get(queryKey);
                if (queryRules.containsKey(queryKey)) {
                    MatchingRule rule = (MatchingRule)((MatchingRuleGroup)queryRules.get(queryKey)).getRules().get(0);
                    String regex = ((RegexMatcher)rule).getRegex();
                    if (specificParamValue == null || !specificParamValue.matches(regex)) {
                        mismatches.put((String)queryKey, specificParamValue + " !~ " + regex);
                    }
                } else if (!((String)queryValue.get(0)).equals(specificParamValue)) {
                    mismatches.put((String)queryKey, specificParamValue + " != " + (String)queryValue.get(0));
                }
            });
        }
        return mismatches;
    }

    private Map<String, String> getMismatchesForUrlPath(Request pactRequest, String urlPath) {
        HashMap<String, String> mismatches = new HashMap<String, String>();
        List pathRules = pactRequest.getMatchingRules().rulesForCategory("path").allMatchingRules();
        if (!pathRules.isEmpty()) {
            String pathRegex = ((RegexMatcher)pathRules.get(0)).getRegex();
            if (!urlPath.matches(pathRegex)) {
                mismatches.put(pathRegex, urlPath);
            }
        } else if (!urlPath.equals(pactRequest.getPath())) {
            mismatches.put(pactRequest.getPath(), urlPath);
        }
        return mismatches;
    }
}

