/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs;

import au.com.dius.pact.core.model.RequestResponseInteraction;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.provider.BodyComparisonResult;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import de.eosts.pactstubs.compare.RequestComparisonResult;
import de.eosts.pactstubs.compare.ResponseComparisonResult;
import de.eosts.pactstubs.exception.RequestNotVerifiedException;
import de.eosts.pactstubs.exception.ResponseNotVerifiedException;
import de.eosts.pactstubs.jsonpath.JsonPathResponseConverter;
import de.eosts.pactstubs.jsonpath.WriteContextOperator;
import de.eosts.pactstubs.loader.PactInteractionLoader;
import de.eosts.pactstubs.spec.InteractionIdentifier;
import de.eosts.pactstubs.spec.SpecificRequestSpec;
import de.eosts.pactstubs.wiremock.request.Pact2WireMockRequestConverter;
import de.eosts.pactstubs.wiremock.response.PactResponseConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pact2WireMock {
    private static final Logger log = LoggerFactory.getLogger(Pact2WireMock.class);
    private final PactInteractionLoader pactInteractionLoader;
    private final WireMock wireMock;
    private final JsonPathResponseConverter<Response, ResponseDefinition> pactResponseConverter;

    public Pact2WireMock(PactInteractionLoader pactInteractionLoader) {
        this.pactInteractionLoader = pactInteractionLoader;
        this.wireMock = new WireMock();
        this.pactResponseConverter = new PactResponseConverter();
    }

    public Pact2WireMock(PactInteractionLoader pactInteractionLoader, WireMock wireMock) {
        this.pactInteractionLoader = pactInteractionLoader;
        this.wireMock = wireMock;
        this.pactResponseConverter = new PactResponseConverter();
    }

    public Pact2WireMock(PactInteractionLoader pactInteractionLoader, WireMock wireMock, JsonPathResponseConverter<Response, ResponseDefinition> pactResponseConverter) {
        this.pactInteractionLoader = pactInteractionLoader;
        this.wireMock = wireMock;
        this.pactResponseConverter = pactResponseConverter;
    }

    public void stubFor(String consumer, String provider, String description, WriteContextOperator ... writeContextOperators) {
        this.stubFor(consumer, provider, description, SpecificRequestSpec.builder().build(), writeContextOperators);
    }

    public void stubFor(String consumer, String provider, String description, SpecificRequestSpec specificRequestSpec, WriteContextOperator ... writeContextOperators) {
        RequestResponseInteraction interaction = (RequestResponseInteraction)this.pactInteractionLoader.getInteraction(consumer, provider, description);
        this.stubFor(interaction, specificRequestSpec, writeContextOperators);
    }

    public void stubFor(String consumer, String provider, String description, String providerState, WriteContextOperator ... writeContextOperators) {
        this.stubFor(consumer, provider, description, providerState, SpecificRequestSpec.builder().build(), writeContextOperators);
    }

    public void stubFor(String consumer, String provider, String description, String providerState, SpecificRequestSpec specificRequestSpec, WriteContextOperator ... writeContextOperators) {
        RequestResponseInteraction interaction = (RequestResponseInteraction)this.pactInteractionLoader.getInteraction(consumer, provider, description, providerState);
        this.stubFor(interaction, specificRequestSpec, writeContextOperators);
    }

    public void stubFor(InteractionIdentifier interactionIdentifier, WriteContextOperator ... writeContextOperators) {
        this.stubFor(interactionIdentifier, SpecificRequestSpec.builder().build(), writeContextOperators);
    }

    public void stubFor(InteractionIdentifier interactionIdentifier, SpecificRequestSpec specificRequestSpec, WriteContextOperator ... writeContextOperators) {
        RequestResponseInteraction interaction = (RequestResponseInteraction)interactionIdentifier.getProviderState().map(state -> this.pactInteractionLoader.getInteraction(interactionIdentifier.getConsumer(), interactionIdentifier.getProvider(), interactionIdentifier.getDescription(), (String)state)).orElseGet(() -> this.pactInteractionLoader.getInteraction(interactionIdentifier.getConsumer(), interactionIdentifier.getProvider(), interactionIdentifier.getDescription()));
        this.stubFor(interaction, specificRequestSpec, writeContextOperators);
    }

    public void stubFor(RequestResponseInteraction interaction, WriteContextOperator ... writeContextOperators) {
        this.stubFor(interaction, SpecificRequestSpec.builder().build(), writeContextOperators);
    }

    public void stubFor(RequestResponseInteraction interaction, SpecificRequestSpec specificRequestSpec, WriteContextOperator ... writeContextOperators) {
        RequestComparisonResult requestComparisonResult = new Pact2WireMockRequestConverter(interaction.getRequest(), specificRequestSpec).convert();
        ResponseComparisonResult<ResponseDefinition> responseComparisonResult = this.pactResponseConverter.convert(interaction.getResponse(), writeContextOperators);
        ResponseDefinition responseDefinition = responseComparisonResult.getResponse();
        RequestPattern requestPattern = requestComparisonResult.getRequestPattern();
        log.debug("Configure WireMock with RequestPattern: {}", (Object)requestPattern);
        log.debug("Configure WireMock with ResponseDefinition: {}", (Object)responseDefinition);
        this.wireMock.register(new StubMapping(requestPattern, responseDefinition));
        if (responseComparisonResult.getComparisonResult() != null && !((BodyComparisonResult)responseComparisonResult.getComparisonResult().getBodyMismatches().toOption().toList().get(0)).getMismatches().isEmpty()) {
            throw new ResponseNotVerifiedException("Differences in \"" + interaction.getDescription() + "\": " + responseComparisonResult.getComparisonResult(), interaction.getResponse(), responseComparisonResult);
        }
        if (requestComparisonResult.getComparisonResult() != null && !requestComparisonResult.getComparisonResult().isEmpty()) {
            throw new RequestNotVerifiedException("Specific path and/or query doesn't match pact: {}", interaction.getRequest(), requestComparisonResult);
        }
    }

    public PactInteractionLoader getPactInteractionLoader() {
        return this.pactInteractionLoader;
    }

    public WireMock getWireMock() {
        return this.wireMock;
    }
}

