/*
 * Decompiled with CFR 0.152.
 */
package de.eosts.pactstubs;

import au.com.dius.pact.core.model.messaging.Message;
import au.com.dius.pact.provider.BodyComparisonResult;
import de.eosts.pactstubs.compare.ResponseComparisonResult;
import de.eosts.pactstubs.exception.MessageNotVerifiedException;
import de.eosts.pactstubs.jsonpath.JsonPathResponseConverter;
import de.eosts.pactstubs.jsonpath.WriteContextOperator;
import de.eosts.pactstubs.loader.PactInteractionLoader;
import de.eosts.pactstubs.message.PactMessageConverter;

public class Pact2Message {
    private final PactInteractionLoader pactInteractionLoader;
    private final JsonPathResponseConverter<Message, String> pactMessageConverter;

    public Pact2Message(PactInteractionLoader pactInteractionLoader) {
        this.pactInteractionLoader = pactInteractionLoader;
        this.pactMessageConverter = new PactMessageConverter();
    }

    public Pact2Message(PactInteractionLoader pactInteractionLoader, JsonPathResponseConverter<Message, String> pactMessageConverter) {
        this.pactInteractionLoader = pactInteractionLoader;
        this.pactMessageConverter = pactMessageConverter;
    }

    public String message(String consumer, String provider, String description, WriteContextOperator ... writeContextOperator) {
        return this.message((Message)this.pactInteractionLoader.getInteraction(consumer, provider, description), writeContextOperator);
    }

    public String message(String consumer, String provider, String description, String providerState, WriteContextOperator ... writeContextOperator) {
        return this.message((Message)this.pactInteractionLoader.getInteraction(consumer, provider, description, providerState), writeContextOperator);
    }

    public String message(Message interaction, WriteContextOperator ... writeContextOperator) {
        ResponseComparisonResult<String> convertedMessage = this.pactMessageConverter.convert(interaction, writeContextOperator);
        if (convertedMessage.getComparisonResult() != null && !((BodyComparisonResult)convertedMessage.getComparisonResult().getBodyMismatches().toOption().toList().get(0)).getMismatches().isEmpty()) {
            throw new MessageNotVerifiedException("Differences in \"" + interaction.getDescription() + "\": " + convertedMessage.getComparisonResult(), interaction.getContents(), convertedMessage);
        }
        return convertedMessage.getResponse();
    }

    public PactInteractionLoader getPactInteractionLoader() {
        return this.pactInteractionLoader;
    }
}

