/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.api.base;

import de.entwicklertraining.api.base.ApiCallCaptureInput;
import de.entwicklertraining.api.base.ApiRequestBuilderBase;
import de.entwicklertraining.api.base.ApiResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class ApiRequest<R extends ApiResponse<?>> {
    private final int maxExecutionTimeInSeconds;
    private final Map<String, String> additionalHeaders = new HashMap<String, String>();
    private final Consumer<ApiCallCaptureInput> captureOnSuccess;
    private final Consumer<ApiCallCaptureInput> captureOnError;
    private volatile boolean canceled = false;
    private final Supplier<Boolean> isCanceledSupplier;

    protected ApiRequest(ApiRequestBuilderBase<?, ?> builderBase) {
        this.maxExecutionTimeInSeconds = builderBase.maxExecutionTimeInSeconds;
        this.captureOnSuccess = builderBase.captureOnSuccess;
        this.captureOnError = builderBase.captureOnError;
        this.isCanceledSupplier = builderBase.isCanceledSupplier;
    }

    public int getMaxExecutionTimeInSeconds() {
        return this.maxExecutionTimeInSeconds;
    }

    public boolean hasCaptureOnSuccess() {
        return this.captureOnSuccess != null;
    }

    public boolean hasCaptureOnError() {
        return this.captureOnError != null;
    }

    public Consumer<ApiCallCaptureInput> getCaptureOnSuccess() {
        return this.captureOnSuccess;
    }

    public Consumer<ApiCallCaptureInput> getCaptureOnError() {
        return this.captureOnError;
    }

    public Supplier<Boolean> getIsCanceledSupplier() {
        return this.isCanceledSupplier;
    }

    public abstract String getRelativeUrl();

    public abstract String getHttpMethod();

    public abstract String getBody();

    public abstract R createResponse(String var1);

    public boolean isBinaryResponse() {
        return false;
    }

    public R createResponse(byte[] responseBytes) {
        throw new UnsupportedOperationException("This request doesn't support binary responses.");
    }

    public String getContentType() {
        return "application/json";
    }

    public byte[] getBodyBytes() {
        throw new UnsupportedOperationException("No binary body by default.");
    }

    public void setHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public Map<String, String> getAdditionalHeaders() {
        return Collections.unmodifiableMap(this.additionalHeaders);
    }
}

