/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.api.base;

import de.entwicklertraining.api.base.ApiRequest;
import java.util.Optional;
import java.util.function.Consumer;

public final class ApiClientSettings {
    private String bearerAuthenticationKey;
    private int maxRetries = 10;
    private long initialDelayMs = 1000L;
    private double exponentialBase = 2.0;
    private boolean useJitter = true;
    private int minSleepDurationForFinalRetryInSeconds = 500;
    private int maxExecutionTimeForFinalRetryInSeconds = 60;
    private Consumer<ApiRequest<?>> beforeSendAction;

    public ApiClientSettings() {
    }

    private ApiClientSettings(Builder builder) {
        this.bearerAuthenticationKey = builder.bearerAuthenticationKey;
        this.maxRetries = builder.maxRetries;
        this.initialDelayMs = builder.initialDelayMs;
        this.exponentialBase = builder.exponentialBase;
        this.useJitter = builder.useJitter;
        this.minSleepDurationForFinalRetryInSeconds = builder.minSleepDurationForFinalRetryInSeconds;
        this.maxExecutionTimeForFinalRetryInSeconds = builder.maxExecutionTimeForFinalRetryInSeconds;
        this.beforeSendAction = builder.beforeSendAction;
    }

    public Builder toBuilder() {
        return new Builder().maxRetries(this.maxRetries).initialDelayMs(this.initialDelayMs).exponentialBase(this.exponentialBase).useJitter(this.useJitter).minSleepDurationForFinalRetryInSeconds(this.minSleepDurationForFinalRetryInSeconds).maxExecutionTimeForFinalRetryInSeconds(this.maxExecutionTimeForFinalRetryInSeconds).beforeSend(this.beforeSendAction).setBearerAuthenticationKey(this.getBearerAuthenticationKey().orElse(null));
    }

    public Optional<String> getBearerAuthenticationKey() {
        return Optional.ofNullable(this.bearerAuthenticationKey);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public ApiClientSettings setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public long getInitialDelayMs() {
        return this.initialDelayMs;
    }

    public ApiClientSettings setInitialDelayMs(long initialDelayMs) {
        this.initialDelayMs = initialDelayMs;
        return this;
    }

    public double getExponentialBase() {
        return this.exponentialBase;
    }

    public ApiClientSettings setExponentialBase(double exponentialBase) {
        this.exponentialBase = exponentialBase;
        return this;
    }

    public boolean isUseJitter() {
        return this.useJitter;
    }

    public ApiClientSettings setUseJitter(boolean useJitter) {
        this.useJitter = useJitter;
        return this;
    }

    public int getMinSleepDurationForFinalRetryInSeconds() {
        return this.minSleepDurationForFinalRetryInSeconds;
    }

    public ApiClientSettings setMinSleepDurationForFinalRetryInSeconds(int seconds) {
        this.minSleepDurationForFinalRetryInSeconds = seconds;
        return this;
    }

    public int getMaxExecutionTimeForFinalRetryInSeconds() {
        return this.maxExecutionTimeForFinalRetryInSeconds;
    }

    public Consumer<ApiRequest<?>> getBeforeSendAction() {
        return this.beforeSendAction;
    }

    public ApiClientSettings setMaxExecutionTimeForFinalRetryInSeconds(int seconds) {
        this.maxExecutionTimeForFinalRetryInSeconds = seconds;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String bearerAuthenticationKey;
        private int maxRetries = 10;
        private long initialDelayMs = 1000L;
        private double exponentialBase = 2.0;
        private boolean useJitter = true;
        private int minSleepDurationForFinalRetryInSeconds = 500;
        private int maxExecutionTimeForFinalRetryInSeconds = 60;
        private Consumer<ApiRequest<?>> beforeSendAction;

        public Builder setBearerAuthenticationKey(String key) {
            this.bearerAuthenticationKey = key;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder initialDelayMs(long initialDelayMs) {
            this.initialDelayMs = initialDelayMs;
            return this;
        }

        public Builder exponentialBase(double exponentialBase) {
            this.exponentialBase = exponentialBase;
            return this;
        }

        public Builder useJitter(boolean useJitter) {
            this.useJitter = useJitter;
            return this;
        }

        public Builder minSleepDurationForFinalRetryInSeconds(int seconds) {
            this.minSleepDurationForFinalRetryInSeconds = seconds;
            return this;
        }

        public Builder maxExecutionTimeForFinalRetryInSeconds(int seconds) {
            this.maxExecutionTimeForFinalRetryInSeconds = seconds;
            return this;
        }

        public Builder beforeSend(Consumer<ApiRequest<?>> beforeSendAction) {
            this.beforeSendAction = beforeSendAction;
            return this;
        }

        public ApiClientSettings build() {
            return new ApiClientSettings(this);
        }
    }
}

