/*
 * Decompiled with CFR 0.152.
 */
package de.enterprise.starters.jpa.data.auditing;

import de.enterprise.starters.jpa.data.auditing.SpringSecurityAuditorAware;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.auditing.DateTimeProvider;
import org.springframework.data.domain.AuditorAware;

@Configuration
public class AuditingAutoConfiguration {

    @ConditionalOnClass(value={AuditorAware.class})
    static class SpringSecurityAuditorAwareConfiguration {
        SpringSecurityAuditorAwareConfiguration() {
        }

        @Bean
        SpringSecurityAuditorAware springSecurityAuditorAware() {
            return new SpringSecurityAuditorAware();
        }

        @Bean
        public DateTimeProvider zonedDateTimeProvider() {
            return new DateTimeProvider(){

                public Optional<TemporalAccessor> getNow() {
                    return Optional.of(ZonedDateTime.now());
                }
            };
        }
    }
}

