/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.chart.internal.HashUtils;
import org.jfree.data.DomainInfo;
import org.jfree.data.DomainOrder;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.general.Series;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.XYSeries;

public class XYSeriesCollection<S extends Comparable<S>>
extends AbstractIntervalXYDataset<S>
implements IntervalXYDataset<S>,
DomainInfo,
RangeInfo,
VetoableChangeListener,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -7590013825931496766L;
    private List<XYSeries<S>> data = new ArrayList<XYSeries<S>>();
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this, false);

    public XYSeriesCollection() {
        this(null);
    }

    public XYSeriesCollection(XYSeries<S> series) {
        this.addChangeListener(this.intervalDelegate);
        if (series != null) {
            this.data.add(series);
            series.addChangeListener(this);
        }
    }

    @Override
    public DomainOrder getDomainOrder() {
        int seriesCount = this.getSeriesCount();
        for (int i = 0; i < seriesCount; ++i) {
            XYSeries<int> s = this.getSeries((S)i);
            if (s.getAutoSort()) continue;
            return DomainOrder.NONE;
        }
        return DomainOrder.ASCENDING;
    }

    public void addSeries(XYSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        if (this.getSeriesIndex(series.getKey()) >= 0) {
            throw new IllegalArgumentException("This dataset already contains a series with the key " + series.getKey());
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int series) {
        Args.requireInRange(series, "series", 0, this.data.size() - 1);
        XYSeries<S> s = this.data.get(series);
        if (s != null) {
            this.removeSeries(s);
        }
    }

    public void removeSeries(XYSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        if (this.data.contains(series)) {
            series.removeChangeListener(this);
            this.data.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (XYSeries<S> series : this.data) {
            series.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public List<XYSeries<S>> getSeries() {
        try {
            return CloneUtils.clone(this.data);
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Unexpected exception in JFreeChart - please file a bug report.");
        }
    }

    @Override
    public int indexOf(XYSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        return this.data.indexOf(series);
    }

    public XYSeries<S> getSeries(int series) {
        Args.requireInRange(series, "series", 0, this.data.size() - 1);
        return this.data.get(series);
    }

    public XYSeries<S> getSeries(S key) {
        Args.nullNotPermitted(key, "key");
        for (XYSeries<S> series : this.data) {
            if (!key.equals(series.getKey())) continue;
            return series;
        }
        throw new UnknownKeyException("Key not found: " + key);
    }

    @Override
    public S getSeriesKey(int series) {
        return (S)this.getSeries((S)series).getKey();
    }

    public int getSeriesIndex(S key) {
        Args.nullNotPermitted(key, "key");
        int seriesCount = this.getSeriesCount();
        for (int i = 0; i < seriesCount; ++i) {
            XYSeries<S> series = this.data.get(i);
            if (!key.equals(series.getKey())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries((S)series).getItemCount();
    }

    @Override
    public Number getX(int series, int item) {
        XYSeries<S> s = this.data.get(series);
        return s.getX(item);
    }

    @Override
    public Number getStartX(int series, int item) {
        return this.intervalDelegate.getStartX(series, item);
    }

    @Override
    public Number getEndX(int series, int item) {
        return this.intervalDelegate.getEndX(series, item);
    }

    @Override
    public Number getY(int series, int index) {
        XYSeries<S> s = this.data.get(series);
        return s.getY(index);
    }

    @Override
    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYSeriesCollection)) {
            return false;
        }
        XYSeriesCollection that = (XYSeriesCollection)obj;
        if (!this.intervalDelegate.equals(that.intervalDelegate)) {
            return false;
        }
        return Objects.equals(this.data, that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XYSeriesCollection clone = (XYSeriesCollection)super.clone();
        clone.data = CloneUtils.cloneList(this.data);
        clone.intervalDelegate = (IntervalXYDelegate)this.intervalDelegate.clone();
        return clone;
    }

    public int hashCode() {
        int hash = 5;
        hash = HashUtils.hashCode(hash, this.intervalDelegate);
        hash = HashUtils.hashCode(hash, this.data);
        return hash;
    }

    @Override
    public double getDomainLowerBound(boolean includeInterval) {
        if (includeInterval) {
            return this.intervalDelegate.getDomainLowerBound(includeInterval);
        }
        double result = Double.NaN;
        int seriesCount = this.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            XYSeries<int> series = this.getSeries((S)s);
            double lowX = series.getMinX();
            if (Double.isNaN(result)) {
                result = lowX;
                continue;
            }
            if (Double.isNaN(lowX)) continue;
            result = Math.min(result, lowX);
        }
        return result;
    }

    @Override
    public double getDomainUpperBound(boolean includeInterval) {
        if (includeInterval) {
            return this.intervalDelegate.getDomainUpperBound(includeInterval);
        }
        double result = Double.NaN;
        int seriesCount = this.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            XYSeries<int> series = this.getSeries((S)s);
            double hiX = series.getMaxX();
            if (Double.isNaN(result)) {
                result = hiX;
                continue;
            }
            if (Double.isNaN(hiX)) continue;
            result = Math.max(result, hiX);
        }
        return result;
    }

    @Override
    public Range getDomainBounds(boolean includeInterval) {
        if (includeInterval) {
            return this.intervalDelegate.getDomainBounds(includeInterval);
        }
        double lower = Double.POSITIVE_INFINITY;
        double upper = Double.NEGATIVE_INFINITY;
        int seriesCount = this.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            double maxX;
            XYSeries<int> series = this.getSeries((S)s);
            double minX = series.getMinX();
            if (!Double.isNaN(minX)) {
                lower = Math.min(lower, minX);
            }
            if (Double.isNaN(maxX = series.getMaxX())) continue;
            upper = Math.max(upper, maxX);
        }
        if (lower > upper) {
            return null;
        }
        return new Range(lower, upper);
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double width) {
        if (width < 0.0) {
            throw new IllegalArgumentException("Negative 'width' argument.");
        }
        this.intervalDelegate.setFixedIntervalWidth(width);
        this.fireDatasetChanged();
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double factor) {
        this.intervalDelegate.setIntervalPositionFactor(factor);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean b) {
        this.intervalDelegate.setAutoWidth(b);
        this.fireDatasetChanged();
    }

    @Override
    public Range getRangeBounds(boolean includeInterval) {
        double lower = Double.POSITIVE_INFINITY;
        double upper = Double.NEGATIVE_INFINITY;
        int seriesCount = this.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            double maxY;
            XYSeries<int> series = this.getSeries((S)s);
            double minY = series.getMinY();
            if (!Double.isNaN(minY)) {
                lower = Math.min(lower, minY);
            }
            if (Double.isNaN(maxY = series.getMaxY())) continue;
            upper = Math.max(upper, maxY);
        }
        if (lower > upper) {
            return null;
        }
        return new Range(lower, upper);
    }

    @Override
    public double getRangeLowerBound(boolean includeInterval) {
        double result = Double.NaN;
        int seriesCount = this.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            XYSeries<int> series = this.getSeries((S)s);
            double lowY = series.getMinY();
            if (Double.isNaN(result)) {
                result = lowY;
                continue;
            }
            if (Double.isNaN(lowY)) continue;
            result = Math.min(result, lowY);
        }
        return result;
    }

    @Override
    public double getRangeUpperBound(boolean includeInterval) {
        double result = Double.NaN;
        int seriesCount = this.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            XYSeries<int> series = this.getSeries((S)s);
            double hiY = series.getMaxY();
            if (Double.isNaN(result)) {
                result = hiY;
                continue;
            }
            if (Double.isNaN(hiY)) continue;
            result = Math.max(result, hiY);
        }
        return result;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (!"Key".equals(e.getPropertyName())) {
            return;
        }
        Series s = (Series)e.getSource();
        if (this.getSeriesIndex(s.getKey()) == -1) {
            throw new IllegalStateException("Receiving events from a series that does not belong to this collection.");
        }
        Comparable key = (Comparable)e.getNewValue();
        if (this.getSeriesIndex(key) >= 0) {
            throw new PropertyVetoException("Duplicate key2", e);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Iterator<XYSeries<S>> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            XYSeries<S> item;
            XYSeries<S> series = item = iterator.next();
            series.addChangeListener(this);
        }
    }
}

