/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XIntervalDataItem;
import org.jfree.data.xy.XIntervalSeries;

public class XIntervalSeriesCollection<S extends Comparable<S>>
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
PublicCloneable,
Serializable {
    private List<XIntervalSeries<S>> data = new ArrayList<XIntervalSeries<S>>();

    public void addSeries(XIntervalSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public XIntervalSeries<S> getSeries(int series) {
        Args.requireInRange(series, "series", 0, this.data.size() - 1);
        return this.data.get(series);
    }

    @Override
    public S getSeriesKey(int series) {
        return (S)this.getSeries(series).getKey();
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    @Override
    public Number getX(int series, int item) {
        XIntervalSeries<S> s = this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s.getDataItem(item);
        return di.getX();
    }

    @Override
    public double getStartXValue(int series, int item) {
        XIntervalSeries<S> s = this.data.get(series);
        return s.getXLowValue(item);
    }

    @Override
    public double getEndXValue(int series, int item) {
        XIntervalSeries<S> s = this.data.get(series);
        return s.getXHighValue(item);
    }

    @Override
    public double getYValue(int series, int item) {
        XIntervalSeries<S> s = this.data.get(series);
        return s.getYValue(item);
    }

    @Override
    public Number getY(int series, int item) {
        XIntervalSeries<S> s = this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s.getDataItem(item);
        return di.getYValue();
    }

    @Override
    public Number getStartX(int series, int item) {
        XIntervalSeries<S> s = this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s.getDataItem(item);
        return di.getXLowValue();
    }

    @Override
    public Number getEndX(int series, int item) {
        XIntervalSeries<S> s = this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s.getDataItem(item);
        return di.getXHighValue();
    }

    @Override
    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public void removeSeries(int series) {
        Args.requireInRange(series, "series", 0, this.data.size() - 1);
        XIntervalSeries<S> ts = this.data.get(series);
        ts.removeChangeListener(this);
        this.data.remove(series);
        this.fireDatasetChanged();
    }

    public void removeSeries(XIntervalSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        if (this.data.contains(series)) {
            series.removeChangeListener(this);
            this.data.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (XIntervalSeries<S> series : this.data) {
            series.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XIntervalSeriesCollection)) {
            return false;
        }
        XIntervalSeriesCollection that = (XIntervalSeriesCollection)obj;
        return Objects.equals(this.data, that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XIntervalSeriesCollection clone = (XIntervalSeriesCollection)super.clone();
        clone.data = CloneUtils.cloneList(this.data);
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Iterator<XIntervalSeries<S>> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            XIntervalSeries<S> item;
            XIntervalSeries<S> series = item = iterator.next();
            series.addChangeListener(this);
        }
    }
}

