/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.Vector;
import org.jfree.data.xy.VectorDataItem;
import org.jfree.data.xy.VectorSeries;
import org.jfree.data.xy.VectorXYDataset;

public class VectorSeriesCollection<S extends Comparable<S>>
extends AbstractXYDataset<S>
implements VectorXYDataset<S>,
PublicCloneable,
Serializable {
    private List<VectorSeries<S>> data = new ArrayList<VectorSeries<S>>();

    public void addSeries(VectorSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean removeSeries(VectorSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        boolean removed = this.data.remove(series);
        if (removed) {
            series.removeChangeListener(this);
            this.fireDatasetChanged();
        }
        return removed;
    }

    public void removeAllSeries() {
        for (VectorSeries<S> series : this.data) {
            series.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public VectorSeries<S> getSeries(int series) {
        Args.requireInRange(series, "series", 0, this.data.size() - 1);
        return this.data.get(series);
    }

    @Override
    public S getSeriesKey(int series) {
        return (S)this.getSeries(series).getKey();
    }

    @Override
    public int indexOf(VectorSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        return this.data.indexOf(series);
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    @Override
    public double getXValue(int series, int item) {
        VectorSeries<S> s = this.data.get(series);
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getXValue();
    }

    @Override
    public Number getX(int series, int item) {
        return this.getXValue(series, item);
    }

    @Override
    public double getYValue(int series, int item) {
        VectorSeries<S> s = this.data.get(series);
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getYValue();
    }

    @Override
    public Number getY(int series, int item) {
        return this.getYValue(series, item);
    }

    @Override
    public Vector getVector(int series, int item) {
        VectorSeries<S> s = this.data.get(series);
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getVector();
    }

    @Override
    public double getVectorXValue(int series, int item) {
        VectorSeries<S> s = this.data.get(series);
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getVectorX();
    }

    @Override
    public double getVectorYValue(int series, int item) {
        VectorSeries<S> s = this.data.get(series);
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getVectorY();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VectorSeriesCollection)) {
            return false;
        }
        VectorSeriesCollection that = (VectorSeriesCollection)obj;
        return Objects.equals(this.data, that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        VectorSeriesCollection clone = (VectorSeriesCollection)super.clone();
        clone.data = CloneUtils.cloneList(this.data);
        return clone;
    }
}

