/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.data.xy.AbstractXYZDataset;
import org.jfree.data.xy.MatrixSeries;
import org.jfree.data.xy.XYZDataset;

public class MatrixSeriesCollection<S extends Comparable<S>>
extends AbstractXYZDataset
implements XYZDataset,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3197705779242543945L;
    private List<MatrixSeries<S>> seriesList = new ArrayList<MatrixSeries<S>>();

    public MatrixSeriesCollection() {
        this(null);
    }

    public MatrixSeriesCollection(MatrixSeries<S> series) {
        if (series != null) {
            this.seriesList.add(series);
            series.addChangeListener(this);
        }
    }

    @Override
    public int getItemCount(int seriesIndex) {
        return this.getSeries(seriesIndex).getItemCount();
    }

    public MatrixSeries<S> getSeries(int seriesIndex) {
        Args.requireInRange(seriesIndex, "seriesIndex", 0, this.seriesList.size() - 1);
        MatrixSeries<S> series = this.seriesList.get(seriesIndex);
        return series;
    }

    @Override
    public int getSeriesCount() {
        return this.seriesList.size();
    }

    @Override
    public S getSeriesKey(int seriesIndex) {
        return (S)this.getSeries(seriesIndex).getKey();
    }

    @Override
    public Number getX(int seriesIndex, int itemIndex) {
        MatrixSeries<S> series = this.seriesList.get(seriesIndex);
        return series.getItemColumn(itemIndex);
    }

    @Override
    public Number getY(int seriesIndex, int itemIndex) {
        MatrixSeries<S> series = this.seriesList.get(seriesIndex);
        return series.getItemRow(itemIndex);
    }

    @Override
    public Number getZ(int seriesIndex, int itemIndex) {
        MatrixSeries<S> series = this.seriesList.get(seriesIndex);
        return series.getItem(itemIndex);
    }

    public void addSeries(MatrixSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        this.seriesList.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof MatrixSeriesCollection) {
            MatrixSeriesCollection c = (MatrixSeriesCollection)obj;
            return Objects.equals(this.seriesList, c.seriesList);
        }
        return false;
    }

    public int hashCode() {
        return this.seriesList != null ? this.seriesList.hashCode() : 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MatrixSeriesCollection clone = (MatrixSeriesCollection)super.clone();
        clone.seriesList = CloneUtils.cloneList(this.seriesList);
        return clone;
    }

    public void removeAllSeries() {
        for (MatrixSeries<S> series : this.seriesList) {
            series.removeChangeListener(this);
        }
        this.seriesList.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(MatrixSeries<S> series) {
        Args.nullNotPermitted(series, "series");
        if (this.seriesList.contains(series)) {
            series.removeChangeListener(this);
            this.seriesList.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int seriesIndex) {
        Args.requireInRange(seriesIndex, "seriesIndex", 0, this.seriesList.size() - 1);
        MatrixSeries<S> series = this.seriesList.get(seriesIndex);
        series.removeChangeListener(this);
        this.seriesList.remove(seriesIndex);
        this.fireDatasetChanged();
    }
}

