/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.internal.Args;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.statistics.Statistics;

public abstract class BoxAndWhiskerCalculator {
    public static BoxAndWhiskerItem calculateBoxAndWhiskerStatistics(List<? extends Number> values) {
        return BoxAndWhiskerCalculator.calculateBoxAndWhiskerStatistics(values, true);
    }

    public static BoxAndWhiskerItem calculateBoxAndWhiskerStatistics(List<? extends Number> values, boolean stripNullAndNaNItems) {
        List<? extends Number> vlist;
        Args.nullNotPermitted(values, "values");
        if (stripNullAndNaNItems) {
            vlist = new ArrayList<Number>(values.size());
            for (Number number : values) {
                Number n;
                double v;
                if (!(number instanceof Number) || Double.isNaN(v = (n = number).doubleValue())) continue;
                vlist.add(n);
            }
        } else {
            vlist = values;
        }
        Collections.sort(vlist);
        double mean = Statistics.calculateMean(vlist, false);
        double median = Statistics.calculateMedian(vlist, false);
        double q1 = BoxAndWhiskerCalculator.calculateQ1(vlist);
        double q3 = BoxAndWhiskerCalculator.calculateQ3(vlist);
        double interQuartileRange = q3 - q1;
        double upperOutlierThreshold = q3 + interQuartileRange * 1.5;
        double lowerOutlierThreshold = q1 - interQuartileRange * 1.5;
        double upperFaroutThreshold = q3 + interQuartileRange * 2.0;
        double lowerFaroutThreshold = q1 - interQuartileRange * 2.0;
        double minRegularValue = Double.POSITIVE_INFINITY;
        double maxRegularValue = Double.NEGATIVE_INFINITY;
        double minOutlier = Double.POSITIVE_INFINITY;
        double maxOutlier = Double.NEGATIVE_INFINITY;
        ArrayList<Number> outliers = new ArrayList<Number>();
        for (Number number : vlist) {
            Number number2 = number;
            double value = number2.doubleValue();
            if (value > upperOutlierThreshold) {
                outliers.add(number2);
                if (value > maxOutlier && value <= upperFaroutThreshold) {
                    maxOutlier = value;
                }
            } else if (value < lowerOutlierThreshold) {
                outliers.add(number2);
                if (value < minOutlier && value >= lowerFaroutThreshold) {
                    minOutlier = value;
                }
            } else {
                minRegularValue = Math.min(minRegularValue, value);
                maxRegularValue = Math.max(maxRegularValue, value);
            }
            minOutlier = Math.min(minOutlier, minRegularValue);
            maxOutlier = Math.max(maxOutlier, maxRegularValue);
        }
        return new BoxAndWhiskerItem(mean, median, q1, q3, minRegularValue, maxRegularValue, minOutlier, maxOutlier, (List<? extends Number>)outliers);
    }

    public static double calculateQ1(List values) {
        Args.nullNotPermitted(values, "values");
        double result = Double.NaN;
        int count = values.size();
        if (count > 0) {
            result = count % 2 == 1 ? (count > 1 ? Statistics.calculateMedian(values, 0, count / 2) : Statistics.calculateMedian(values, 0, 0)) : Statistics.calculateMedian(values, 0, count / 2 - 1);
        }
        return result;
    }

    public static double calculateQ3(List values) {
        Args.nullNotPermitted(values, "values");
        double result = Double.NaN;
        int count = values.size();
        if (count > 0) {
            result = count % 2 == 1 ? (count > 1 ? Statistics.calculateMedian(values, count / 2, count - 1) : Statistics.calculateMedian(values, 0, 0)) : Statistics.calculateMedian(values, count / 2, count - 1);
        }
        return result;
    }
}

