/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.internal.Args;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;

public abstract class Series<K extends Comparable<K>>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6906561437538683581L;
    private final K key;
    private EventListenerList listeners;
    private boolean notify;

    protected Series(K key) {
        Args.nullNotPermitted(key, "key");
        this.key = key;
        this.listeners = new EventListenerList();
        this.notify = true;
    }

    public K getKey() {
        return this.key;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        if (this.notify != notify) {
            this.notify = notify;
            this.fireSeriesChanged();
        }
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public abstract int getItemCount();

    public Object clone() throws CloneNotSupportedException {
        Series clone = (Series)super.clone();
        clone.listeners = new EventListenerList();
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Series)) {
            return false;
        }
        Series that = (Series)obj;
        return this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public void addChangeListener(SeriesChangeListener listener) {
        this.listeners.add(SeriesChangeListener.class, listener);
    }

    public void removeChangeListener(SeriesChangeListener listener) {
        this.listeners.remove(SeriesChangeListener.class, listener);
    }

    public void fireSeriesChanged() {
        if (this.notify) {
            this.notifyListeners(new SeriesChangeEvent(this));
        }
    }

    protected void notifyListeners(SeriesChangeEvent event) {
        Object[] listenerList = this.listeners.getListenerList();
        for (int i = listenerList.length - 2; i >= 0; i -= 2) {
            if (listenerList[i] != SeriesChangeListener.class) continue;
            ((SeriesChangeListener)listenerList[i + 1]).seriesChanged(event);
        }
    }
}

