/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.time.TimePeriod;

public class TaskSeriesCollection<R extends Comparable<R>, C extends Comparable<C>>
extends AbstractSeriesDataset<R>
implements GanttCategoryDataset<R, C>,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2065799050738449903L;
    private List<C> keys = new ArrayList<C>();
    private List<TaskSeries<R>> data = new ArrayList<TaskSeries<R>>();

    public TaskSeries<R> getSeries(R key) {
        Args.nullNotPermitted(key, "key");
        TaskSeries<R> result = null;
        int index = this.getRowIndex(key);
        if (index >= 0) {
            result = this.getSeries(index);
        }
        return result;
    }

    public TaskSeries<R> getSeries(int series) {
        Args.requireInRange(series, "series", 0, this.data.size() - 1);
        return this.data.get(series);
    }

    @Override
    public int getSeriesCount() {
        return this.getRowCount();
    }

    @Override
    public R getSeriesKey(int series) {
        TaskSeries<R> ts = this.data.get(series);
        return (R)ts.getKey();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public List<R> getRowKeys() {
        ArrayList result = new ArrayList();
        for (TaskSeries<R> series : this.data) {
            result.add(series.getKey());
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return this.keys.size();
    }

    @Override
    public List<C> getColumnKeys() {
        return this.keys;
    }

    @Override
    public C getColumnKey(int index) {
        return (C)((Comparable)this.keys.get(index));
    }

    @Override
    public int getColumnIndex(C columnKey) {
        Args.nullNotPermitted(columnKey, "columnKey");
        return this.keys.indexOf(columnKey);
    }

    @Override
    public int getRowIndex(R rowKey) {
        int result = -1;
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            TaskSeries<R> s = this.data.get(i);
            if (!s.getKey().equals(rowKey)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public R getRowKey(int index) {
        TaskSeries<R> series = this.data.get(index);
        return (R)series.getKey();
    }

    public void add(TaskSeries<R> series) {
        Args.nullNotPermitted(series, "series");
        this.data.add(series);
        series.addChangeListener(this);
        for (Task task : series.getTasks()) {
            String key = task.getDescription();
            int index = this.keys.indexOf(key);
            if (index >= 0) continue;
            this.keys.add(key);
        }
        this.fireDatasetChanged();
    }

    public void remove(TaskSeries<R> series) {
        Args.nullNotPermitted(series, "series");
        if (this.data.contains(series)) {
            series.removeChangeListener(this);
            this.data.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void remove(int series) {
        Args.requireInRange(series, "series", 0, this.data.size() - 1);
        TaskSeries<R> ts = this.data.get(series);
        ts.removeChangeListener(this);
        this.data.remove(series);
        this.fireDatasetChanged();
    }

    public void removeAll() {
        for (TaskSeries<R> series : this.data) {
            series.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public Number getValue(R rowKey, C columnKey) {
        return this.getStartValue(rowKey, columnKey);
    }

    @Override
    public Number getValue(int row, int column) {
        return this.getStartValue(row, column);
    }

    @Override
    public Number getStartValue(R rowKey, C columnKey) {
        TimePeriod duration;
        Long result = null;
        int row = this.getRowIndex(rowKey);
        TaskSeries<R> series = this.data.get(row);
        Task task = series.get(columnKey.toString());
        if (task != null && (duration = task.getDuration()) != null) {
            result = duration.getStart().getTime();
        }
        return result;
    }

    @Override
    public Number getStartValue(int row, int column) {
        R rowKey = this.getRowKey(row);
        C columnKey = this.getColumnKey(column);
        return this.getStartValue(rowKey, columnKey);
    }

    @Override
    public Number getEndValue(R rowKey, C columnKey) {
        TimePeriod duration;
        Long result = null;
        int row = this.getRowIndex(rowKey);
        TaskSeries<R> series = this.data.get(row);
        Task task = series.get(columnKey.toString());
        if (task != null && (duration = task.getDuration()) != null) {
            result = duration.getEnd().getTime();
        }
        return result;
    }

    @Override
    public Number getEndValue(int row, int column) {
        R rowKey = this.getRowKey(row);
        C columnKey = this.getColumnKey(column);
        return this.getEndValue(rowKey, columnKey);
    }

    @Override
    public Number getPercentComplete(int row, int column) {
        R rowKey = this.getRowKey(row);
        C columnKey = this.getColumnKey(column);
        return this.getPercentComplete(rowKey, columnKey);
    }

    @Override
    public Number getPercentComplete(R rowKey, C columnKey) {
        Double result = null;
        int row = this.getRowIndex(rowKey);
        TaskSeries<R> series = this.data.get(row);
        Task task = series.get(columnKey.toString());
        if (task != null) {
            result = task.getPercentComplete();
        }
        return result;
    }

    @Override
    public int getSubIntervalCount(int row, int column) {
        R rowKey = this.getRowKey(row);
        C columnKey = this.getColumnKey(column);
        return this.getSubIntervalCount(rowKey, columnKey);
    }

    @Override
    public int getSubIntervalCount(R rowKey, C columnKey) {
        int result = 0;
        int row = this.getRowIndex(rowKey);
        TaskSeries<R> series = this.data.get(row);
        Task task = series.get(columnKey.toString());
        if (task != null) {
            result = task.getSubtaskCount();
        }
        return result;
    }

    @Override
    public Number getStartValue(int row, int column, int subinterval) {
        R rowKey = this.getRowKey(row);
        C columnKey = this.getColumnKey(column);
        return this.getStartValue(rowKey, columnKey, subinterval);
    }

    @Override
    public Number getStartValue(R rowKey, C columnKey, int subinterval) {
        TimePeriod duration;
        Task sub;
        Long result = null;
        int row = this.getRowIndex(rowKey);
        TaskSeries<R> series = this.data.get(row);
        Task task = series.get(columnKey.toString());
        if (task != null && (sub = task.getSubtask(subinterval)) != null && (duration = sub.getDuration()) != null) {
            result = duration.getStart().getTime();
        }
        return result;
    }

    @Override
    public Number getEndValue(int row, int column, int subinterval) {
        R rowKey = this.getRowKey(row);
        C columnKey = this.getColumnKey(column);
        return this.getEndValue(rowKey, columnKey, subinterval);
    }

    @Override
    public Number getEndValue(R rowKey, C columnKey, int subinterval) {
        TimePeriod duration;
        Task sub;
        Long result = null;
        int row = this.getRowIndex(rowKey);
        TaskSeries<R> series = this.data.get(row);
        Task task = series.get(columnKey.toString());
        if (task != null && (sub = task.getSubtask(subinterval)) != null && (duration = sub.getDuration()) != null) {
            result = duration.getEnd().getTime();
        }
        return result;
    }

    @Override
    public Number getPercentComplete(int row, int column, int subinterval) {
        R rowKey = this.getRowKey(row);
        C columnKey = this.getColumnKey(column);
        return this.getPercentComplete(rowKey, columnKey, subinterval);
    }

    @Override
    public Number getPercentComplete(R rowKey, C columnKey, int subinterval) {
        Task sub;
        Double result = null;
        int row = this.getRowIndex(rowKey);
        TaskSeries<R> series = this.data.get(row);
        Task task = series.get(columnKey.toString());
        if (task != null && (sub = task.getSubtask(subinterval)) != null) {
            result = sub.getPercentComplete();
        }
        return result;
    }

    @Override
    public void seriesChanged(SeriesChangeEvent event) {
        this.refreshKeys();
        this.fireDatasetChanged();
    }

    private void refreshKeys() {
        this.keys.clear();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            TaskSeries<R> series = this.data.get(i);
            for (Task task : series.getTasks()) {
                String key = task.getDescription();
                int index = this.keys.indexOf(key);
                if (index >= 0) continue;
                this.keys.add(key);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaskSeriesCollection)) {
            return false;
        }
        TaskSeriesCollection that = (TaskSeriesCollection)obj;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.data);
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TaskSeriesCollection clone = (TaskSeriesCollection)super.clone();
        clone.data = CloneUtils.cloneList(this.data);
        clone.keys = new ArrayList<C>(this.keys);
        return clone;
    }
}

